/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import com.ibm.uma.MethodPlugin;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.PluginModifyInfo;
import org.eclipse.epf.importing.wizards.SelectImportPluginSource;
import org.eclipse.epf.importing.wizards.SelectPluginsToImport;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportPluginWizard
extends Wizard
implements IImportWizard {
    private static final String WIZARD_TITLE = ImportResources.getString("Import.importPluginsWizard.title");
    protected SelectImportPluginSource page1;
    protected SelectPluginsToImport page2;
    protected PluginImportData data = new PluginImportData();
    protected PluginImportingService service = new PluginImportingService(this.data);

    public ImportPluginWizard() {
        this.setWindowTitle(WIZARD_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (LibraryProcessor.getInstance().isReadOnly()) {
            ImportPlugin.getDefault().getMsgDialog().displayError(WIZARD_TITLE, ImportResources.getString("Import.ImportPluginWizard.readonly"));
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportMethodPlugins.gif"));
        this.page1 = new SelectImportPluginSource(this.data, this.service);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new SelectPluginsToImport(this.data, this.service);
        this.addPage((IWizardPage)this.page2);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(LibraryUIImages.IMG_METHOD_PLUGIN);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() != this.page2) {
            return false;
        }
        return this.page2.isPageComplete();
    }

    public boolean performFinish() {
        boolean yes;
        PluginModifyInfo modifyInfo = this.checkModify();
        if (modifyInfo.readonlyPlugins.size() > 0) {
            String error = modifyInfo.getReadonlyMessage().toString();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.getString("Import.ImportConfigurationWizard.error"), error);
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            if (info.existingPlugin == null || !info.selected) continue;
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append("\t").append(info.name);
        }
        if (buffer.length() > 0 && !(yes = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(WIZARD_TITLE, ImportResources.getString("Import.ImportPluginWizard.warn_existing_plugins", buffer.toString())))) {
            return false;
        }
        if (modifyInfo.lockedPlugins.size() > 0) {
            String message = String.valueOf(modifyInfo.getLockedMessage().toString()) + ImportResources.getString("Import.ImportPluginWizard.confirm_continue");
            boolean yes2 = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(WIZARD_TITLE, message);
            if (!yes2) {
                return false;
            }
        }
        LibraryBackupUtil.promptBackupLibrary(null, (File)LibraryProcessor.getInstance().getLibraryRootPath());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(ImportResources.getString("Import.ImportPluginWizard.MSG1"), -1);
                        ImportPluginWizard.this.service.performImport(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.getString("Import.ImportPluginWizard.error"), realException.getMessage());
            return false;
        }
        ImportUIPreferences.setLastImportPluginPath(this.data.llData.getParentFolder());
        return true;
    }

    public PluginModifyInfo checkModify() {
        PluginModifyInfo modifyInfo = new PluginModifyInfo();
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            MethodPlugin plugin = info.existingPlugin;
            if (plugin == null || !info.selected) continue;
            if (!plugin.getUserChangeable().booleanValue()) {
                modifyInfo.lockedPlugins.add(plugin);
                continue;
            }
            IStatus status = TngUtil.checkEdit((EObject)plugin, (Object)this.getShell());
            if (status.isOK()) continue;
            modifyInfo.readonlyPlugins.add(plugin);
        }
        return modifyInfo;
    }
}

