/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import org.eclipse.epf.authoring.gef.util.Validation;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.commands.Command;

public class DeleteLinkCommand
extends Command {
    private Link link;
    private Node src;
    private Node target;
    private int srcIndex;
    private int targetIndex;
    private static final String LABEL = AuthoringUIResources.getString("AuthoringUI.gef.deleteLinkCommand.label");

    public DeleteLinkCommand(Link link, boolean isHardDelete) {
        super(LABEL);
        this.link = link;
        this.src = link.getSource();
        this.target = link.getTarget();
    }

    public boolean canExecute() {
        if (Validation.checkDelete(this.link) != null) {
            return false;
        }
        return this.link != null && this.src != null && this.target != null;
    }

    public void execute() {
        this.srcIndex = this.src.getOutgoingConnections().indexOf((Object)this.link);
        this.targetIndex = this.target.getIncomingConnections().indexOf((Object)this.link);
        if (this.srcIndex != -1 && this.targetIndex != -1) {
            this.src.getOutgoingConnections().remove(this.srcIndex);
            this.target.getIncomingConnections().remove(this.targetIndex);
        }
    }

    public void undo() {
        if (this.srcIndex != -1 && this.targetIndex != -1) {
            this.src.getOutgoingConnections().add(this.srcIndex, (Object)this.link);
            this.target.getIncomingConnections().add(this.targetIndex, (Object)this.link);
        }
    }
}

