/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.util;

import com.ibm.uma.Activity;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.RoleNode;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public final class Validation {
    private static final String errMsg_CanNotConnect = AuthoringUIResources.getString("AuthoringUI.DiagramValidation.err_cannot_connect.text");
    private static final String errMsg_SamePredAndSucc = AuthoringUIResources.getString("AuthoringUI.DiagramValidation.err_samepredandsuc.text");
    private static final String errMsg_CanNotDelete = AuthoringUIResources.getString("AuthoringUI.DiagramValidation.err_cannot_delete.text");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static String checkConnect(Node source, Node target) {
        if (source.getDiagram() != target.getDiagram()) {
            return AuthoringUIResources.getString("AuthoringUI.DiagramValidation.err_cannot_connect_different_diagram.text");
        }
        if (source.getDiagram() instanceof ActivityDiagram) {
            ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            Object object = source.getDiagram().getObject();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = adapterFactory.adapt(object, (Object)clazz);
            Object proc = null;
            if (adapter instanceof IBSItemProvider) {
                proc = ((IBSItemProvider)adapter).getTopItem();
            }
            ArrayList<Object> allElements = new ArrayList<Object>();
            AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator((AdapterFactory)adapterFactory, proc);
            while (iter.hasNext()) {
                Object obj = iter.next();
                allElements.add(TngUtil.unwrap(obj));
            }
            if (proc != null) {
                if (target.getDiagram().isReadOnly()) {
                    return errMsg_CanNotConnect;
                }
                if (source.getObject() instanceof WorkBreakdownElement) {
                    if (target.getObject() instanceof WorkBreakdownElement) {
                        if (ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)target.getObject()), (WorkBreakdownElement)((WorkBreakdownElement)source.getObject()), allElements)) {
                            return errMsg_SamePredAndSucc;
                        }
                        if (target.isReadOnly()) {
                            return errMsg_CanNotConnect;
                        }
                    } else if (target instanceof TypedNode) {
                        if (((TypedNode)target).getType() == 3 || ((TypedNode)target).getType() == 6) {
                            return errMsg_CanNotConnect;
                        }
                        TypedNode typedNode = (TypedNode)target;
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.eclipse.epf.diagram.model.WorkBreakdownElementNode");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)typedNode, (Class)clazz2);
                        WorkBreakdownElement pred = (WorkBreakdownElement)source.getObject();
                        Iterator iter2 = targetNodes.iterator();
                        while (iter2.hasNext()) {
                            Node node = (Node)iter2.next();
                            if (node.isReadOnly()) {
                                return errMsg_CanNotConnect;
                            }
                            if (!ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)node.getObject()), (WorkBreakdownElement)pred, allElements)) continue;
                            return errMsg_SamePredAndSucc;
                        }
                    }
                } else if (source instanceof TypedNode) {
                    Collection srcNodes;
                    if (target == source) {
                        return errMsg_CanNotConnect;
                    }
                    if (((TypedNode)source).getType() == 4 || ((TypedNode)source).getType() == 6) {
                        return errMsg_CanNotConnect;
                    }
                    if (target instanceof TypedNode) {
                        if (Validation.checkSyncBarCircularLooop((TypedNode)source, (TypedNode)target) != null) {
                            return errMsg_CanNotConnect;
                        }
                        if (((TypedNode)target).getType() == 3 || ((TypedNode)target).getType() == 6) {
                            return errMsg_CanNotConnect;
                        }
                        TypedNode typedNode = (TypedNode)source;
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$1 = Class.forName("org.eclipse.epf.diagram.model.WorkBreakdownElementNode");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!(srcNodes = GraphicalDataHelper.getSourceNodes((TypedNode)typedNode, (Class)clazz3)).isEmpty()) {
                            TypedNode typedNode2 = (TypedNode)target;
                            Class<?> clazz4 = class$1;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = class$1 = Class.forName("org.eclipse.epf.diagram.model.WorkBreakdownElementNode");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)typedNode2, (Class)clazz4);
                            Iterator iter3 = targetNodes.iterator();
                            while (iter3.hasNext()) {
                                Node node = (Node)iter3.next();
                                if (node.isReadOnly()) {
                                    return errMsg_CanNotConnect;
                                }
                                WorkBreakdownElement succ = (WorkBreakdownElement)node.getObject();
                                Iterator iterator = srcNodes.iterator();
                                while (iterator.hasNext()) {
                                    WorkBreakdownElement pred = (WorkBreakdownElement)((Node)iterator.next()).getObject();
                                    if (!ProcessUtil.checkCircular((WorkBreakdownElement)succ, (WorkBreakdownElement)pred, allElements)) continue;
                                    return errMsg_SamePredAndSucc;
                                }
                            }
                        }
                    } else if (target instanceof WorkBreakdownElementNode) {
                        if (target.isReadOnly()) {
                            return errMsg_CanNotConnect;
                        }
                        TypedNode typedNode = (TypedNode)source;
                        Class<?> clazz5 = class$1;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$1 = Class.forName("org.eclipse.epf.diagram.model.WorkBreakdownElementNode");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        srcNodes = GraphicalDataHelper.getSourceNodes((TypedNode)typedNode, (Class)clazz5);
                        WorkBreakdownElement succ = (WorkBreakdownElement)target.getObject();
                        Iterator iterator = srcNodes.iterator();
                        while (iterator.hasNext()) {
                            WorkBreakdownElement pred = (WorkBreakdownElement)((Node)iterator.next()).getObject();
                            if (!ProcessUtil.checkCircular((WorkBreakdownElement)succ, (WorkBreakdownElement)pred, allElements)) continue;
                            return errMsg_SamePredAndSucc;
                        }
                    }
                }
            }
        } else if (source.getDiagram() instanceof ActivityDetailDiagram) {
            if (source.isReadOnly() || target.isReadOnly()) {
                return errMsg_CanNotConnect;
            }
            if (source.getObject() instanceof RoleDescriptor || target.getObject() instanceof RoleDescriptor || source.getObject() instanceof TaskDescriptor && target.getObject() instanceof TaskDescriptor || source.getObject() instanceof WorkProductDescriptor && target.getObject() instanceof WorkProductDescriptor) {
                return errMsg_CanNotConnect;
            }
            Iterator iter = source.getOutgoingConnections().iterator();
            while (iter.hasNext()) {
                Link link = (Link)iter.next();
                if (link.getTarget() != target) continue;
                return errMsg_CanNotConnect;
            }
        } else if (source.getDiagram() instanceof WorkProductDependencyDiagram && (source.isReadOnly() || target.isReadOnly())) {
            return errMsg_CanNotConnect;
        }
        return null;
    }

    public static String checkDelete(Link link) {
        Node source = link.getSource();
        Node target = link.getTarget();
        if (target != null && target.getDiagram() instanceof ActivityDiagram) {
            if (target instanceof WorkBreakdownElementNode) {
                if (source instanceof WorkBreakdownElementNode) {
                    if (link.getTarget().isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                    return null;
                }
                if (source instanceof TypedNode) {
                    TypedNode sourceNode = (TypedNode)source;
                    if (sourceNode.getType() == 2) {
                        return null;
                    }
                    if (sourceNode.getType() == 1) {
                        return Validation.checkSyncBarIncomingLinks(sourceNode);
                    }
                    if (sourceNode.isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                }
            } else if (target instanceof TypedNode) {
                TypedNode typedNode = (TypedNode)target;
                if (typedNode.getType() == 2) {
                    return null;
                }
                if (source instanceof WorkBreakdownElementNode) {
                    if (Validation.checkSyncBarOutgoingLinks((TypedNode)target) == null) {
                        return null;
                    }
                    if (source.isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                }
                if (source instanceof TypedNode) {
                    TypedNode sourceTypedNode = (TypedNode)source;
                    if (sourceTypedNode.getType() == 2) {
                        return null;
                    }
                    if (sourceTypedNode.getType() == 1) {
                        return Validation.checkSyncBarIncomingLinks(sourceTypedNode);
                    }
                }
            }
        }
        return null;
    }

    public static String checkDelete(Node node) {
        if (node.isReadOnly()) {
            return errMsg_CanNotDelete;
        }
        Diagram diagram = node.getDiagram();
        if (diagram instanceof ActivityDiagram) {
            if (node instanceof TypedNode) {
                TypedNode typedNode = (TypedNode)node;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.epf.diagram.model.WorkBreakdownElementNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)typedNode, (Class)clazz);
                Iterator iter = targetNodes.iterator();
                while (iter.hasNext()) {
                    Node target = (Node)iter.next();
                    if (!target.isReadOnly()) continue;
                    return errMsg_CanNotDelete;
                }
            }
        } else if (diagram instanceof ActivityDetailDiagram && node instanceof RoleNode) {
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkReconnect(Node source, Node target, Link link) {
        if (source.getDiagram() instanceof ActivityDiagram && link.getTarget() != null) {
            if (link.getTarget().isReadOnly()) {
                return errMsg_CanNotConnect;
            }
            if (link.getTarget() instanceof TypedNode) {
                TypedNode typedNode = (TypedNode)link.getTarget();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.epf.diagram.model.WorkBreakdownElementNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)typedNode, (Class)clazz);
                Iterator iter = targetNodes.iterator();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    if (!node.isReadOnly()) continue;
                    return errMsg_CanNotConnect;
                }
            }
        }
        return Validation.checkConnect(source, target, link);
    }

    public static String checkConnect(Node source, Node target, Link link) {
        if (source == target && !(source.getObject() instanceof Activity)) {
            return errMsg_CanNotConnect;
        }
        EList links = source.getOutgoingConnections();
        if (links != null) {
            if (links.contains(link) && link.getTarget().equals(target)) {
                return null;
            }
            Iterator iter = links.iterator();
            while (iter.hasNext()) {
                Link linkx = (Link)iter.next();
                Node linkxtarget = linkx.getTarget();
                if (linkxtarget == null || !linkxtarget.equals(target)) continue;
                return errMsg_CanNotConnect;
            }
        }
        return Validation.checkConnect(source, target);
    }

    public static String checkSyncBarCircularLooop(TypedNode sNode, TypedNode tNode) {
        EList list = tNode.getOutgoingConnections();
        if (!list.isEmpty() && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                Node typednode = link.getTarget();
                if (sNode.equals(typednode)) {
                    return errMsg_CanNotConnect;
                }
                if (!(typednode instanceof TypedNode)) continue;
                return Validation.checkSyncBarCircularLooop(sNode, (TypedNode)typednode);
            }
        }
        return null;
    }

    public static String checkSyncBarIncomingLinks(TypedNode typedNode) {
        Iterator iter = typedNode.getIncomingConnections().iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            Node source = link.getSource();
            if (!(source instanceof WorkBreakdownElementNode ? source.isReadOnly() : source instanceof TypedNode && ((TypedNode)source).getType() == 1 && Validation.checkSyncBarIncomingLinks((TypedNode)source) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkSyncBarOutgoingLinks(TypedNode typedNode) {
        Iterator iter = typedNode.getOutgoingConnections().iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            Node target = link.getTarget();
            if (!(target instanceof WorkBreakdownElementNode ? target.isReadOnly() : target instanceof TypedNode && ((TypedNode)target).getType() == 1 && Validation.checkSyncBarOutgoingLinks((TypedNode)target) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }
}

