/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.io.File;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttachmentDialog
extends Dialog {
    protected Button okButton;
    protected Button cancelButton;
    private Text attachment;

    public AttachmentDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)dialogArea.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        GridData gridData = (GridData)dialogArea.getLayoutData();
        gridData.verticalIndent = 10;
        layout.numColumns = 3;
        Label urlLabel = new Label(dialogArea, 0);
        urlLabel.setText(AuthoringUIResources.getString("AuthoringUI.AttachmentDialogFileURL.text"));
        this.attachment = new Text(dialogArea, 2048);
        gridData.widthHint = 300;
        this.attachment.setLayoutData((Object)gridData);
        this.attachment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AttachmentDialog.this.okButton != null) {
                    AttachmentDialog.this.okButton.setEnabled(AttachmentDialog.this.attachment.getText().trim().length() > 0);
                }
            }
        });
        Button browseButton = new Button(dialogArea, 0);
        browseButton.setText(AuthoringUIText.BROWSE_BUTTON_TEXT);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                String imageFile = dialog.open();
                if (imageFile != null && imageFile.length() > 0) {
                    File file = new File(imageFile);
                    try {
                        String url = file.toURL().toExternalForm();
                        AttachmentDialog.this.attachment.setText(url);
                    }
                    catch (Exception exception) {}
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        super.getShell().setText(AuthoringUIResources.getString("AuthoringUI.AttachmentDialogattachFile.text"));
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = super.getButton(0);
        this.cancelButton = super.getButton(1);
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public String getAttachmentPath() {
        return this.attachment.getText();
    }
}

