/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.CustomCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Role;
import com.ibm.uma.RoleSet;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.authoring.ui.filters.CustomCategoryFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class RoleCategoriesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "roleCategoriesPage";
    private Role role;

    public RoleCategoriesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.CATEGORIES_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.role = (Role)this.contentElement;
        this.setAllowChange1(true);
        this.setAllowChange2(true);
        this.setUseCategory3(false);
        this.setCategoryIsSingleSelection1(false);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getRoleSets((Role)((Role)object)).toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                RoleSet roleSet = (RoleSet)it.next();
                LibraryManager.getInstance().addToRoleSet(this.getActionManager(), roleSet, this.role);
                if (!this.usedCategories.contains(roleSet)) continue;
                this.usedCategories.remove(roleSet);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                RoleSet roleSet = (RoleSet)it.next();
                LibraryManager.getInstance().removeFromRoleSet(this.getActionManager(), roleSet, this.role);
                if (this.usedCategories.contains(roleSet)) continue;
                this.usedCategories.add(roleSet);
            }
        }
    }

    protected void initContentProviderSelected2() {
        this.contentProviderSelected2 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getCustomCategories((DescribableElement)((Role)object)).toArray();
            }
        };
        this.viewer_selected2.setContentProvider((IContentProvider)this.contentProviderSelected2);
    }

    protected void addItemsToModel2(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                CustomCategory customCategory = (CustomCategory)it.next();
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.role);
                if (!this.usedCategories.contains(customCategory)) continue;
                this.usedCategories.remove(customCategory);
            }
        }
    }

    protected void removeItemsFromModel2(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                CustomCategory customCategory = (CustomCategory)it.next();
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.role);
                if (this.usedCategories.contains(customCategory)) continue;
                this.usedCategories.add(customCategory);
            }
        }
    }

    protected Object getContentElement() {
        return this.role;
    }

    protected String getTabString() {
        return FilterConstants.ROLESETS;
    }

    protected String getTabString2() {
        return FilterConstants.CUSTOM_CATEGORIES;
    }

    protected IFilter getFilter() {
        this.filter = new CategoryFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof RoleSet;
            }
        };
        return this.filter;
    }

    protected IFilter getFilter2() {
        this.filter = new CustomCategoryFilter();
        return this.filter;
    }
}

