/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.Artifact;
import com.ibm.uma.ArtifactDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.Deliverable;
import com.ibm.uma.DeliverableDescription;
import com.ibm.uma.Outcome;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescription;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.filters.WorkProductFilter;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.VariabilityBaseElementFilter;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkProductDescriptionPage
extends DescriptionFormPage {
    private static final String FORM_PAGE_ID = "workProductDescriptionPage";
    private IMethodRichText ctrl_impact;
    private IMethodRichText ctrl_reason;
    private IMethodRichText ctrl_brief_outline;
    private IMethodRichText ctrl_representation_options;
    private IMethodRichText ctrl_external_desc;
    private IMethodRichText ctrl_packaging_guidance;
    private WorkProduct workProduct;

    public WorkProductDescriptionPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.workProduct = (WorkProduct)this.contentElement;
        this.purposeOn = true;
        this.externalIdOn = true;
        if (!(this.contentElement instanceof Outcome)) {
            this.notationSectionOn = true;
        }
        this.tailoringSectionOn = true;
        this.iconSectionOn = true;
    }

    protected void createNotationSectionContent() {
        super.createNotationSectionContent();
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.BRIEF_OUTLINE_TEXT, 40, 400, 4);
            this.ctrl_representation_options = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.REPRESENTATION_OPTIONS_TEXT, 40, 400, 4);
        } else if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.EXTERNAL_DESCRIPTION_TEXT, 40, 400, 4);
            this.ctrl_packaging_guidance = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.PACKAGING_GUIDANCE_TEXT, 40, 400, 4);
        }
    }

    protected void createTailoringSectionContent() {
        super.createTailoringSectionContent();
        this.ctrl_impact = this.createRichTextEditWithLinkForSection(this.toolkit, this.tailoringComposite, AuthoringUIText.IMPACT_OF_NOT_HAVING_TEXT, 40, 400, 5);
        this.ctrl_reason = this.createRichTextEditWithLinkForSection(this.toolkit, this.tailoringComposite, AuthoringUIText.REASON_FOR_NOT_NEEDING_TEXT, 40, 400, 5);
    }

    protected void addListeners() {
        final IActionManager actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        super.addListeners();
        this.ctrl_purpose.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_purpose.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_Purpose());
        this.ctrl_purpose.addModifyListener(this.contentModifyListener);
        this.ctrl_purpose.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_purpose;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getPurpose();
                if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_Purpose(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                    WorkProductDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_external_id.addModifyListener(this.contentModifyListener);
        this.ctrl_external_id.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                boolean success;
                String oldContent = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getExternalId();
                if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(WorkProductDescriptionPage.this.ctrl_external_id, oldContent)) {
                    return;
                }
                String newContent = WorkProductDescriptionPage.this.ctrl_external_id.getText();
                if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ExternalId(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                    WorkProductDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_impact.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_impact.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ImpactOfNotHaving());
        this.ctrl_impact.addModifyListener(this.contentModifyListener);
        this.ctrl_impact.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_impact;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getImpactOfNotHaving();
                if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ImpactOfNotHaving(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                    WorkProductDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_reason.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_reason.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ReasonsForNotNeeding());
        this.ctrl_reason.addModifyListener(this.contentModifyListener);
        this.ctrl_reason.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_reason;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getReasonsForNotNeeding();
                if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ReasonsForNotNeeding(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                    WorkProductDescriptionPage.this.updateChangeDate();
                }
            }
        });
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_brief_outline.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_BriefOutline());
            this.ctrl_brief_outline.addModifyListener(this.contentModifyListener);
            this.ctrl_brief_outline.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    boolean success;
                    String newContent;
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_brief_outline;
                    if (!control.getModified()) {
                        return;
                    }
                    String oldContent = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getBriefOutline();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        return;
                    }
                    String string = newContent = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded.getText() : WorkProductDescriptionPage.this.ctrl_brief_outline.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_BriefOutline(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
            this.ctrl_representation_options.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_representation_options.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_RepresentationOptions());
            this.ctrl_representation_options.addModifyListener(this.contentModifyListener);
            this.ctrl_representation_options.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    boolean success;
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_representation_options;
                    if (!control.getModified()) {
                        return;
                    }
                    String oldContent = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getRepresentationOptions();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_RepresentationOptions(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
        }
        if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_external_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_ExternalDescription());
            this.ctrl_external_desc.addModifyListener(this.contentModifyListener);
            this.ctrl_external_desc.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    boolean success;
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_external_desc;
                    if (!control.getModified()) {
                        return;
                    }
                    String oldContent = ((DeliverableDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getExternalDescription();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_ExternalDescription(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
            this.ctrl_packaging_guidance.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_packaging_guidance.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_PackagingGuidance());
            this.ctrl_packaging_guidance.addModifyListener(this.contentModifyListener);
            this.ctrl_packaging_guidance.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    boolean success;
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_packaging_guidance;
                    if (!control.getModified()) {
                        return;
                    }
                    String oldContent = ((DeliverableDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getPackagingGuidance();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_PackagingGuidance(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
        }
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_impact.setEditable(editable);
        this.ctrl_reason.setEditable(editable);
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline.setEditable(editable);
            this.ctrl_representation_options.setEditable(editable);
        }
        if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc.setEditable(editable);
            this.ctrl_packaging_guidance.setEditable(editable);
        }
    }

    protected void loadData() {
        super.loadData();
        WorkProductDescription content = (WorkProductDescription)this.workProduct.getPresentation();
        String purpose = content.getPurpose();
        String impact = content.getImpactOfNotHaving();
        String reason = content.getReasonsForNotNeeding();
        this.ctrl_purpose.setText(purpose == null ? "" : purpose);
        this.ctrl_impact.setText(impact == null ? "" : impact);
        this.ctrl_reason.setText(reason == null ? "" : reason);
        if (this.externalIdOn) {
            String external_id = content.getExternalId();
            this.ctrl_external_id.setText(external_id == null ? "" : external_id);
        }
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline.setText(((ArtifactDescription)content).getBriefOutline() == null ? "" : ((ArtifactDescription)content).getBriefOutline());
            this.ctrl_representation_options.setText(((ArtifactDescription)content).getRepresentationOptions() == null ? "" : ((ArtifactDescription)content).getRepresentationOptions());
        } else if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc.setText(((DeliverableDescription)content).getExternalDescription() == null ? "" : ((DeliverableDescription)content).getExternalDescription());
            this.ctrl_packaging_guidance.setText(((DeliverableDescription)content).getPackagingGuidance() == null ? "" : ((DeliverableDescription)content).getPackagingGuidance());
        }
    }

    protected Object getContentElement() {
        return this.workProduct;
    }

    protected String getTabString() {
        return FilterConstants.WORKPRODUCTS;
    }

    protected IFilter getFilter() {
        this.filter = new WorkProductFilter(){
            List badlist = new ArrayList();

            protected boolean childAccept(Object obj) {
                if (super.childAccept(obj) && obj instanceof ContentElement && obj instanceof WorkProduct && ((ContentElement)this.getHelper().getContentElement()).getType().equals(((ContentElement)obj).getType())) {
                    if (obj instanceof Deliverable && WorkProductDescriptionPage.this.workProduct instanceof Deliverable) {
                        if (!UIHelper.checkCircularDeliverables((Deliverable)obj, (Deliverable)WorkProductDescriptionPage.this.workProduct)) {
                            this.badlist.add(obj);
                            return false;
                        }
                        if (((Deliverable)obj).getVariabilityBasedOnElement() != null && !UIHelper.checkCircularDeliverables((Deliverable)((Deliverable)obj).getVariabilityBasedOnElement(), (Deliverable)WorkProductDescriptionPage.this.workProduct)) {
                            this.badlist.add(obj);
                            return false;
                        }
                        Iterator it1 = TngUtil.getGeneralizers((VariabilityElement)((Deliverable)obj));
                        while (it1.hasNext()) {
                            VariabilityElement ve = (VariabilityElement)it1.next();
                            if (ve == null) continue;
                            if (ve.equals(obj)) {
                                return false;
                            }
                            if (UIHelper.checkCircularDeliverables((Deliverable)ve, (Deliverable)WorkProductDescriptionPage.this.workProduct)) continue;
                            this.badlist.add(obj);
                            return false;
                        }
                        ArrayList templist = new ArrayList();
                        Iterator iterator = this.badlist.iterator();
                        while (iterator.hasNext()) {
                            Object bad = iterator.next();
                            UIHelper.deliverablePartsChain((Deliverable)bad, templist);
                        }
                        if (templist.contains(obj)) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        ((ContentFilter)this.filter).setAdditionalFilters(new IFilter[]{new VariabilityBaseElementFilter((VariabilityElement)this.workProduct)});
        return this.filter;
    }
}

