/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.preferences.ProcessEditorPreferencePage;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ProcessEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    private static final String WBS_TXT = AuthoringUIResources.getString("AuthoringUI.ProcessEditor.WorkBreakdownStructure");
    private static final String TBS_TXT = AuthoringUIResources.getString("AuthoringUI.ProcessEditor.TeamAllocation");
    private static final String WPBS_TXT = AuthoringUIResources.getString("AuthoringUI.ProcessEditor.WorkProductUsage");
    private ListViewer selectedColumnListViewer;
    private List wbsColumnDescriptors;
    private List tbsColumnDescriptors;
    private List wpbsColumnDescriptors;
    private Button addButton;
    private Button removeButton;
    private Button downButton;
    private Button upButton;
    private static final String[] BS_NAMES = new String[]{WBS_TXT, TBS_TXT, WPBS_TXT};
    private List[] columnDescriptorLists;
    private static final List[] ALL_COLUMN_DESCRIPTOR_LISTS = new List[]{ProcessEditor.ALL_WBS_COLUMNS, ProcessEditor.ALL_TBS_COLUMNS, ProcessEditor.ALL_WPBS_COLUMNS};
    private Button configSwitchAlwaysButton;
    private Button configSwitchNeverButton;
    private Button configSwitchPromptButton;
    private Button inheritSuppressionButton;

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AuthoringUIPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        this.initData();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(768));
        Composite columnsComposite = new Composite(composite, 0);
        columnsComposite.setLayout((Layout)new GridLayout(1, false));
        columnsComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(columnsComposite, 0);
        label.setText(AuthoringUIResources.getString("AuthoringUI.columnselection.text"));
        final Combo bsCombo = new Combo(columnsComposite, 2056);
        bsCombo.setItems(BS_NAMES);
        bsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                int id = combo.getSelectionIndex();
                if (id != -1) {
                    ProcessEditorPreferencePage.this.selectedColumnListViewer.setInput((Object)ProcessEditorPreferencePage.this.columnDescriptorLists[id]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        bsCombo.select(0);
        Composite listComposite = new Composite(composite, 0);
        listComposite.setLayout((Layout)new GridLayout(2, false));
        listComposite.setLayoutData((Object)new GridData(768));
        this.selectedColumnListViewer = new ListViewer(listComposite, 2818);
        final ColumnDescriptorProvider itemProvider = new ColumnDescriptorProvider();
        this.selectedColumnListViewer.setContentProvider((IContentProvider)itemProvider);
        this.selectedColumnListViewer.setLabelProvider((IBaseLabelProvider)itemProvider);
        this.selectedColumnListViewer.setInput((Object)this.wbsColumnDescriptors);
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        buttonsComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = 80;
        buttonsComposite.setLayoutData((Object)gridData);
        GridData layoutData = new GridData(768);
        this.addButton = new Button(buttonsComposite, 0);
        this.addButton.setText(AuthoringUIText.ADD_BUTTON_TEXT);
        this.addButton.setLayoutData((Object)layoutData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int id = bsCombo.getSelectionIndex();
                List input = ALL_COLUMN_DESCRIPTOR_LISTS[id];
                List selectedColumns = ProcessEditorPreferencePage.this.columnDescriptorLists[id];
                ListSelectionDialog dlg = new ListSelectionDialog(this, Display.getCurrent().getActiveShell(), input, (IStructuredContentProvider)itemProvider, itemProvider, AuthoringUIResources.getString("AuthoringUI.selectColumnstoAdd.text"), selectedColumns){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ List val$selectedColumns;
                    {
                        this.this$1 = var1_1;
                        this.val$selectedColumns = list;
                        super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                    }

                    protected Control createDialogArea(Composite parent) {
                        Control control = super.createDialogArea(parent);
                        this.getViewer().addFilter(new ViewerFilter(this, this.val$selectedColumns){
                            final /* synthetic */ 3 this$2;
                            private final /* synthetic */ List val$selectedColumns;
                            {
                                this.this$2 = var1_1;
                                this.val$selectedColumns = list;
                            }

                            public boolean select(Viewer viewer, Object parentElement, Object element) {
                                return !this.val$selectedColumns.contains(element);
                            }
                        });
                        return control;
                    }
                };
                if (dlg.open() == 0) {
                    selectedColumns.addAll(Arrays.asList(dlg.getResult()));
                    ProcessEditorPreferencePage.this.selectedColumnListViewer.refresh();
                }
            }
        });
        this.removeButton = new Button(buttonsComposite, 0);
        this.removeButton.setText(AuthoringUIResources.getString("AuthoringUI.removeButton.text"));
        this.removeButton.setLayoutData((Object)layoutData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List columns = (List)ProcessEditorPreferencePage.this.selectedColumnListViewer.getInput();
                List removeList = ((IStructuredSelection)ProcessEditorPreferencePage.this.selectedColumnListViewer.getSelection()).toList();
                if (removeList.contains(ProcessEditor.COL_DESC_ID) || removeList.contains(ProcessEditor.COL_DESC_PRESENTATION_NAME)) {
                    return;
                }
                columns.removeAll(removeList);
                ProcessEditorPreferencePage.this.selectedColumnListViewer.refresh();
            }
        });
        this.upButton = new Button(buttonsComposite, 0);
        this.upButton.setText(AuthoringUIText.UP_BUTTON_TEXT);
        this.upButton.setLayoutData((Object)layoutData);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected;
                IStructuredSelection selection = (IStructuredSelection)ProcessEditorPreferencePage.this.selectedColumnListViewer.getSelection();
                if (selection.size() > 1) {
                    return;
                }
                EList columns = (EList)ProcessEditorPreferencePage.this.selectedColumnListViewer.getInput();
                int id = columns.indexOf(selected = selection.getFirstElement());
                if (id < 3) {
                    return;
                }
                columns.move(id - 1, id);
                ProcessEditorPreferencePage.this.selectedColumnListViewer.refresh();
                ProcessEditorPreferencePage.this.selectedColumnListViewer.setSelection((ISelection)new StructuredSelection(selected), true);
            }
        });
        this.downButton = new Button(buttonsComposite, 0);
        this.downButton.setText(AuthoringUIText.DOWN_BUTTON_TEXT);
        this.downButton.setLayoutData((Object)layoutData);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected;
                IStructuredSelection selection = (IStructuredSelection)ProcessEditorPreferencePage.this.selectedColumnListViewer.getSelection();
                if (selection.size() > 1) {
                    return;
                }
                EList columns = (EList)ProcessEditorPreferencePage.this.selectedColumnListViewer.getInput();
                int id = columns.indexOf(selected = selection.getFirstElement());
                if (id == columns.size() - 1 || id < 2) {
                    return;
                }
                columns.move(id + 1, id);
                ProcessEditorPreferencePage.this.selectedColumnListViewer.refresh();
                ProcessEditorPreferencePage.this.selectedColumnListViewer.setSelection((ISelection)new StructuredSelection(selected), true);
            }
        });
        Group configSwitchGroup = new Group(composite, 8);
        configSwitchGroup.setLayout((Layout)new GridLayout(3, false));
        configSwitchGroup.setLayoutData((Object)new GridData(768));
        configSwitchGroup.setText(AuthoringUIResources.getString("AuthoringUI.ProcessEditorPreferencePage.switchConfiguration"));
        this.configSwitchAlwaysButton = new Button((Composite)configSwitchGroup, 16);
        this.configSwitchAlwaysButton.setText(LibraryUIResources.getString((String)"LibraryUI.preferences.always"));
        this.configSwitchNeverButton = new Button((Composite)configSwitchGroup, 16);
        this.configSwitchNeverButton.setText(LibraryUIResources.getString((String)"LibraryUI.preferences.never"));
        this.configSwitchPromptButton = new Button((Composite)configSwitchGroup, 16);
        this.configSwitchPromptButton.setText(LibraryUIResources.getString((String)"LibraryUI.preferences.prompt"));
        this.setSwitchConfigButton(LibraryUIPreferences.getSwitchConfig());
        Group suppressionGroup = new Group(composite, 8);
        suppressionGroup.setLayout((Layout)new GridLayout());
        suppressionGroup.setLayoutData((Object)new GridData(768));
        suppressionGroup.setText(AuthoringUIResources.getString("AuthoringUI.ProcessEditorPreferencePage.suppressionGroupTitle"));
        this.inheritSuppressionButton = new Button((Composite)suppressionGroup, 32);
        this.inheritSuppressionButton.setText(AuthoringUIResources.getString("AuthoringUI.ProcessEditorPreferencePage.inheritSuppressionState"));
        this.inheritSuppressionButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.epf.library.edit.inherit_suppression_state"));
        return composite;
    }

    private void initData() {
        IPreferenceStore store = this.getPreferenceStore();
        String str = store.getString("org.eclipse.epf.library.edit.wbs_columns");
        if (str == null) {
            str = store.getDefaultString("org.eclipse.epf.library.edit.wbs_columns");
        }
        this.wbsColumnDescriptors = ProcessEditor.toColumnDescriptorList(str);
        str = store.getString("org.eclipse.epf.library.edit.tbs_columns");
        if (str == null) {
            str = store.getDefaultString("org.eclipse.epf.library.edit.tbs_columns");
        }
        this.tbsColumnDescriptors = ProcessEditor.toColumnDescriptorList(str);
        str = store.getString("org.eclipse.epf.library.edit.wpbs_columns");
        if (str == null) {
            str = store.getDefaultString("org.eclipse.epf.library.edit.wpbs_columns");
        }
        this.wpbsColumnDescriptors = ProcessEditor.toColumnDescriptorList(str);
        this.columnDescriptorLists = new List[]{this.wbsColumnDescriptors, this.tbsColumnDescriptors, this.wpbsColumnDescriptors};
    }

    protected void performDefaults() {
        super.performDefaults();
        this.wbsColumnDescriptors.clear();
        this.wbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_WBS_COLUMNS);
        this.tbsColumnDescriptors.clear();
        this.tbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_TBS_COLUMNS);
        this.wpbsColumnDescriptors.clear();
        this.wpbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_WPBS_COLUMNS);
        this.inheritSuppressionButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.epf.library.edit.inherit_suppression_state"));
        this.setSwitchConfigButton("prompt");
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.epf.library.edit.wbs_columns", ProcessEditorPreferencePage.toString(this.wbsColumnDescriptors));
        store.setValue("org.eclipse.epf.library.edit.tbs_columns", ProcessEditorPreferencePage.toString(this.tbsColumnDescriptors));
        store.setValue("org.eclipse.epf.library.edit.wpbs_columns", ProcessEditorPreferencePage.toString(this.wpbsColumnDescriptors));
        store.setValue("org.eclipse.epf.library.edit.inherit_suppression_state", this.inheritSuppressionButton.getSelection());
        LibraryUIPreferences.setSwitchConfig((String)this.getSwitchConfigValue());
        return true;
    }

    public static String toString(List columnDescriptors) {
        StringBuffer strBuf = new StringBuffer();
        int max = columnDescriptors.size() - 1;
        int i = 0;
        while (i < max) {
            strBuf.append(((ColumnDescriptor)columnDescriptors.get((int)i)).id).append(',');
            ++i;
        }
        strBuf.append(((ColumnDescriptor)columnDescriptors.get((int)max)).id);
        return strBuf.toString();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
    }

    private String getSwitchConfigValue() {
        if (this.configSwitchAlwaysButton.getSelection()) {
            return "always";
        }
        if (this.configSwitchNeverButton.getSelection()) {
            return "never";
        }
        if (this.configSwitchPromptButton.getSelection()) {
            return "prompt";
        }
        return "prompt";
    }

    private void setSwitchConfigButton(String value) {
        if ("always".equals(value)) {
            this.configSwitchAlwaysButton.setSelection(true);
            this.configSwitchNeverButton.setSelection(false);
            this.configSwitchPromptButton.setSelection(false);
        } else if ("never".equals(value)) {
            this.configSwitchAlwaysButton.setSelection(false);
            this.configSwitchNeverButton.setSelection(true);
            this.configSwitchPromptButton.setSelection(false);
        } else {
            this.configSwitchAlwaysButton.setSelection(false);
            this.configSwitchNeverButton.setSelection(false);
            this.configSwitchPromptButton.setSelection(true);
        }
    }

    private static class ColumnDescriptorProvider
    implements ITreeContentProvider,
    ILabelProvider {
        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((ColumnDescriptor)element).label;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

