/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryWizard;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewLibraryMainPage
extends WizardPage
implements Listener {
    public static final String PAGE_NAME;
    protected LibraryLocationData llData;
    private Composite composite;
    private Text nameText;
    private Text briefDescText;
    private Text pathText;
    private Button browseButton;
    private Button defaultPathCheckbox;
    private Text ctrlInEditing;
    private String parentDir;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.authoring.ui.wizards.NewLibraryMainPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public NewLibraryMainPage(LibraryLocationData llData) {
        super(PAGE_NAME);
        this.setTitle(AuthoringUIResources.getString("AuthoringUIPlugin.NewLibraryMainPage.pageTitle"));
        this.setDescription(AuthoringUIResources.getString("AuthoringUIPlugin.NewLibraryMainPage.pageDescription"));
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
        this.llData = llData;
    }

    public void createControl(Composite parent) {
        GridData labelGridData = new GridData(2);
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.composite.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(this.composite, 0);
        nameLabel.setText(AuthoringUIText.NAME_TEXT);
        nameLabel.setLayoutData((Object)labelGridData);
        this.nameText = new Text(this.composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        ((GridData)this.nameText.getLayoutData()).horizontalSpan = 2;
        Label briefDescLabel = new Label(this.composite, 0);
        briefDescLabel.setText(AuthoringUIText.DESCRIPTION_TEXT);
        briefDescLabel.setLayoutData((Object)labelGridData);
        this.briefDescText = new Text(this.composite, 2626);
        this.briefDescText.setLayoutData((Object)new GridData(768));
        ((GridData)this.briefDescText.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.briefDescText.getLayoutData()).heightHint = 70;
        ((GridData)this.briefDescText.getLayoutData()).widthHint = 480;
        Label pathLabel = new Label(this.composite, 0);
        pathLabel.setText(AuthoringUIResources.getString("AuthoringUIPlugin.AbstractNewLibraryPage.DirectoryLabel"));
        this.pathText = new Text(this.composite, 2048);
        this.pathText.setLayoutData((Object)new GridData(768));
        this.browseButton = new Button(this.composite, 0);
        this.browseButton.setText(AuthoringUIText.BROWSE_BUTTON_TEXT);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLibraryMainPage.this.openDirectoryDialog();
            }
        });
        new Label(this.composite, 0);
        this.defaultPathCheckbox = new Button(this.composite, 32);
        this.defaultPathCheckbox.setText(AuthoringUIResources.getString("AuthoringUIPlugin.AbstractNewLibraryPage.UseDefaultDirectoryButtonLabel"));
        this.initDataFromDTO();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    private void addListeners() {
        this.nameText.addListener(24, (Listener)this);
        this.nameText.addListener(15, (Listener)this);
        this.nameText.addListener(16, (Listener)this);
        this.briefDescText.addListener(24, (Listener)this);
        this.briefDescText.addListener(16, (Listener)this);
        this.pathText.addListener(15, (Listener)this);
        this.pathText.addListener(24, (Listener)this);
        this.pathText.addListener(16, (Listener)this);
        this.defaultPathCheckbox.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        int idx;
        this.setPageComplete(this.isPageComplete());
        if (event.widget == this.nameText && event.type == 15) {
            this.parentDir = this.pathText.getText();
            String currentName = this.nameText.getText();
            if (currentName.length() > 0 && this.parentDir.endsWith(String.valueOf(File.separator) + currentName)) {
                idx = this.parentDir.lastIndexOf(String.valueOf(File.separator) + currentName);
                this.parentDir = this.parentDir.substring(0, idx);
            }
            if (!this.parentDir.endsWith(File.separator)) {
                this.parentDir = String.valueOf(this.parentDir) + File.separator;
            }
            this.ctrlInEditing = this.nameText;
        }
        if (event.widget == this.nameText && this.ctrlInEditing == this.nameText) {
            this.pathText.setText(String.valueOf(this.parentDir) + this.nameText.getText());
            this.setPathValidMessage();
        }
        if (event.widget == this.nameText && event.type == 16) {
            this.ctrlInEditing = null;
        }
        if (event.widget == this.pathText && event.type == 15) {
            this.ctrlInEditing = this.pathText;
        }
        if (event.widget == this.pathText && this.ctrlInEditing == this.pathText) {
            String parentLibPath;
            idx = (parentLibPath = this.pathText.getText()).lastIndexOf(File.separator);
            String libName = parentLibPath.substring(idx >= 0 ? idx + 1 : 0);
            this.nameText.setText(libName != null ? libName : "");
            if (event.type == 16 || !parentLibPath.startsWith("\\")) {
                this.setPathValidMessage();
            } else {
                this.setErrorMessage(null);
            }
        }
        if (event.widget == this.pathText && event.type == 16) {
            this.ctrlInEditing = null;
        }
        if (event.widget == this.defaultPathCheckbox) {
            if (!this.defaultPathCheckbox.getSelection()) {
                this.pathText.setText(this.llData.getParentFolder());
                this.pathText.setEditable(true);
                this.browseButton.setEnabled(true);
            } else {
                this.pathText.setText(this.llData.getDefaultLibDir());
                this.pathText.setEditable(false);
                this.browseButton.setEnabled(false);
            }
            this.appendLibraryNemeToPath();
        }
        NewLibraryWizard wizard = (NewLibraryWizard)this.getWizard();
        wizard.okToComplete = this.isPageComplete();
        this.getWizard().getContainer().updateButtons();
    }

    private void setPathValidMessage() {
        IStatus status = LibraryProcessor.isValidLibrary((String)this.pathText.getText());
        if (status.isOK()) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(status.getMessage());
        }
    }

    private void appendLibraryNemeToPath() {
        String libName = this.nameText.getText().trim();
        String libPath = this.pathText.getText().trim();
        if (libName.length() > 0) {
            if (!libPath.endsWith(File.separator)) {
                libPath = String.valueOf(libPath) + File.separator;
            }
            this.pathText.setText(String.valueOf(libPath) + libName);
        }
    }

    public static boolean isTextNonEmpty(Text t) {
        String s = t.getText();
        return s != null && s.trim().length() > 0;
    }

    private void initDataFromDTO() {
        this.nameText.setText(AuthoringUIResources.getString("AuthoringUIPlugin.AbstractNewLibraryPage.DefaultLibraryName"));
        this.nameText.setSelection(0, this.nameText.getText().length());
        this.briefDescText.setText(AuthoringUIResources.getString("AuthoringUIPlugin.AbstractNewLibraryPage.DefaultLibraryDescription"));
        this.pathText.setText(this.llData.getParentFolder());
        boolean checked = this.llData.isDefLibDirChecked();
        if (checked) {
            this.pathText.setText(this.llData.getDefaultLibDir());
            this.pathText.setEditable(false);
            this.browseButton.setEnabled(false);
        }
        this.defaultPathCheckbox.setSelection(checked);
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog dd = new DirectoryDialog(this.composite.getShell(), 0);
            String destination = dd.open();
            if (destination != null) {
                this.pathText.setText(destination);
                this.appendLibraryNemeToPath();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveData() {
        this.llData.setOkPressed(true);
        this.llData.setLibName(this.nameText.getText().trim());
        this.llData.setLibBriefDescription(this.briefDescText.getText().trim());
        Path libPath = new Path(this.pathText.getText());
        this.llData.setParentFolder(libPath.removeLastSegments(1).addTrailingSeparator() + this.nameText.getText().trim());
        this.llData.setDefLibDirChecked(this.defaultPathCheckbox.getSelection());
    }

    public boolean isPageComplete() {
        return NewLibraryMainPage.isTextNonEmpty(this.nameText) && NewLibraryMainPage.isTextNonEmpty(this.pathText) && this.getErrorMessage() == null;
    }
}

