/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import com.ibm.uma.MethodPlugin;
import com.ibm.uma.UmaFactory;
import java.util.ArrayList;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.wizards.NewMethodPluginWizardPage;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewMethodPluginWizard
extends Wizard
implements INewWizard {
    private NewMethodPluginWizardPage mainPage;
    private MethodPlugin newPlugin;

    public NewMethodPluginWizard() {
        this.setWindowTitle(AuthoringUIResources.getString("AuthoringUI.newPluginWizard.title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mainPage = new NewMethodPluginWizardPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        if (!this.mainPage.validateName()) {
            return false;
        }
        String pluginName = this.mainPage.getPluginName();
        if (pluginName != null && pluginName.length() > 0) {
            try {
                this.newPlugin = UmaFactory.eINSTANCE.createMethodPlugin();
                this.newPlugin.setName(StrUtil.makeValidFileName((String)pluginName));
                this.newPlugin.setBriefDescription(this.mainPage.getBriefDescription());
                this.newPlugin.setAuthors(this.mainPage.getAuthors());
                Object[] referencedPlugins = this.mainPage.getReferencedPlugins();
                int i = 0;
                while (i < referencedPlugins.length) {
                    MethodPlugin plugin = (MethodPlugin)referencedPlugins[i];
                    if (plugin != null) {
                        this.newPlugin.getBases().add(plugin);
                    }
                    ++i;
                }
                LibraryProcessor.getInstance().addMethodPlugin(ModelStorage.initialize((MethodPlugin)this.newPlugin));
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        ArrayList<MethodPlugin> selection = new ArrayList<MethodPlugin>();
                        selection.add(NewMethodPluginWizard.this.newPlugin);
                        LibraryView.getView().setSelectionToViewer(selection);
                        EditorChooser.getInstance().openEditor(NewMethodPluginWizard.this.newPlugin);
                    }
                });
                return true;
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.newPluginWizard.title"), AuthoringUIResources.getString("AuthoringUI.newPluginError.msg"), AuthoringUIResources.getString("AuthoringUI.newPluginError.reason"), (Throwable)e);
            }
        }
        return false;
    }
}

