/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;

public class DirectoryValidator {
    public static boolean checkAndCreateDir(String dir, String title, String errorMsg) {
        boolean answer = false;
        File file = new File(dir);
        if (file.exists()) {
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                answer = LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, LibraryUIResources.formatString("LibraryUI.deleteFilesConfirmation.msg", dir));
                if (answer) {
                    try {
                        answer = FileUtil.deleteAllFiles((String)file.getAbsolutePath());
                        if (!answer) {
                            LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, errorMsg, LibraryUIResources.formatString("LibraryUI.deleteFilesError.reason", dir));
                        }
                    }
                    catch (Exception e) {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, errorMsg, LibraryUIResources.formatString("LibraryUI.deleteFilesError.reason", dir), (Throwable)e);
                        answer = false;
                    }
                }
            } else {
                answer = true;
            }
        } else if (!file.isAbsolute()) {
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, LibraryUIResources.getString("LibraryUI.DirectoryValidator.invalid_path"));
            answer = false;
        } else {
            try {
                if (!file.mkdirs()) {
                    LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, errorMsg, LibraryUIResources.formatString("LibraryUI.createPathError.reason", dir));
                    answer = false;
                } else {
                    answer = true;
                }
            }
            catch (Exception e) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, errorMsg, LibraryUIResources.formatString("LibraryUI.createPathError.reason", dir), (Throwable)e);
                answer = false;
            }
        }
        return answer;
    }
}

