/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.dialogs.LibraryBackupDialog;
import org.eclipse.swt.widgets.Shell;

public class LibraryBackupUtil {
    private String path = null;

    public static void promptBackupLibrary(Shell shell, File libPath) {
        new LibraryBackupUtil().doBackup(shell, libPath);
    }

    private void doBackup(final Shell shell, final File libPath) {
        this.path = null;
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String backupPath;
                String message;
                String title;
                LibraryBackupDialog dlg;
                Shell s = shell;
                if (s == null) {
                    s = MsgBox.getDefaultShell();
                }
                if (s == null) {
                    s = new Shell(MsgBox.getDisplay());
                }
                if ((dlg = new LibraryBackupDialog(s, title = LibraryUIResources.getString("LibraryUI.LibraryBackupUtil.title"), message = LibraryUIResources.getString("LibraryUI.LibraryBackupUtil.text"), backupPath = String.valueOf(libPath.getAbsolutePath()) + ".backup")).open() == 0) {
                    LibraryBackupUtil.this.path = dlg.getPath();
                }
            }
        });
        if (this.path != null) {
            LibraryBackupUtil.backup(libPath, new File(this.path));
        }
    }

    public static void backup(final File source, final File dest) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String excludes = ".lock";
                    LayoutResources.copyDir((File)source, (File)dest, (String)"**", (String)excludes);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        };
        UserInteractionHelper.runWithProgress((Runnable)runnable, (String)LibraryUIResources.getString("LibraryUI.LibraryBackupUtil.copying"));
    }
}

