/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit;

import com.ibm.uma.Guidance;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import java.util.Comparator;
import org.eclipse.epf.library.edit.util.Comparators;

public class PresentationContext {
    public static final PresentationContext INSTANCE = new PresentationContext();
    private boolean showPresentationNames = false;
    private Comparator comparator = Comparators.DEFAULT_COMPARATOR;
    private Comparator guidanceTypeComparator = new Comparators.TypeComparator(){

        protected Comparator getDefaultComparator() {
            return PresentationContext.this.comparator;
        }

        protected int getOrderId(Object obj) {
            if (obj instanceof Guidance) {
                int id = ((Guidance)obj).eClass().getClassifierID();
                if (id == 84) {
                    id = Integer.MAX_VALUE;
                }
                return id;
            }
            return -1;
        }
    };
    private Comparator processPackageComparator = new Comparators.TypeComparator(){

        protected Comparator getDefaultComparator() {
            return PresentationContext.this.comparator;
        }

        protected int getOrderId(Object obj) {
            if (obj instanceof ProcessComponent) {
                return Integer.MAX_VALUE;
            }
            if (obj instanceof ProcessPackage) {
                return 0;
            }
            return -1;
        }
    };

    private PresentationContext() {
    }

    public boolean isShowPresentationNames() {
        return this.showPresentationNames;
    }

    public void setShowPresentationNames(boolean showPresentationNames) {
        this.showPresentationNames = showPresentationNames;
        this.comparator = showPresentationNames ? Comparators.PRESENTATION_NAME_COMPARATOR : Comparators.DEFAULT_COMPARATOR;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Comparator getGuidanceTypeComparator() {
        return this.guidanceTypeComparator;
    }

    public Comparator getProcessPackageComparator() {
        return this.processPackageComparator;
    }
}

