/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.category;

import com.ibm.uma.ContentCategory;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.Discipline;
import com.ibm.uma.DisciplineGrouping;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.epf.library.edit.category.InheritedCategoryPackageListener;
import org.eclipse.epf.library.edit.util.TngUtil;

public class InheritedDisciplinePackageListener
extends InheritedCategoryPackageListener {
    public InheritedDisciplinePackageListener(ContentPackage pkg) {
        super(pkg);
    }

    public boolean isEmpty(ContentCategory element) {
        if (element instanceof DisciplineGrouping) {
            Iterator iter = ((DisciplineGrouping)element).getDisciplines().iterator();
            while (iter.hasNext()) {
                Discipline discipline = (Discipline)iter.next();
                if (discipline.getVariabilityBasedOnElement() != null && discipline.getTasks().isEmpty()) continue;
                return false;
            }
            return true;
        }
        if (element instanceof Discipline) {
            return ((Discipline)element).getTasks().isEmpty();
        }
        return false;
    }

    public boolean accept(Object obj) {
        return (obj instanceof DisciplineGrouping || obj instanceof Discipline) && ((ContentCategory)obj).getVariabilityBasedOnElement() == null;
    }

    protected ContentCategory createCategory(ContentCategory targetCategory) {
        if (targetCategory instanceof DisciplineGrouping) {
            return UmaFactory.eINSTANCE.createDisciplineGrouping();
        }
        if (targetCategory instanceof Discipline) {
            return UmaFactory.eINSTANCE.createDiscipline();
        }
        return null;
    }

    protected void prepareInherited(Collection inheritedList) {
        ArrayList categories = new ArrayList(inheritedList);
        categories.addAll(this.categoryPackage.getContentElements());
        Iterator iter = inheritedList.iterator();
        while (iter.hasNext()) {
            ContentCategory inherited;
            Discipline element;
            ContentCategory category = (ContentCategory)iter.next();
            VariabilityElement baseCategory = category.getVariabilityBasedOnElement();
            if (baseCategory instanceof DisciplineGrouping) {
                DisciplineGrouping disciplineGrouping = (DisciplineGrouping)category;
                Iterator iterator = ((DisciplineGrouping)baseCategory).getDisciplines().iterator();
                while (iterator.hasNext()) {
                    element = (Discipline)iterator.next();
                    inherited = TngUtil.findInherited(categories, (ContentCategory)element);
                    if (inherited == null) continue;
                    disciplineGrouping.getDisciplines().add(inherited);
                }
                continue;
            }
            if (!(baseCategory instanceof Discipline)) continue;
            Discipline discipline = (Discipline)category;
            Iterator iteration = AssociationHelper.getDisciplineGroups((Discipline)((Discipline)baseCategory)).iterator();
            while (iteration.hasNext()) {
                element = (DisciplineGrouping)iteration.next();
                inherited = TngUtil.findInherited(categories, (ContentCategory)element);
                if (inherited == null) continue;
                ((DisciplineGrouping)inherited).getDisciplines().add(discipline);
            }
        }
    }

    protected void prepareRemove(ContentCategory element) {
        if (element instanceof Discipline) {
            AssociationHelper.getDisciplineGroups((Discipline)((Discipline)element)).clear();
        }
    }
}

