/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.ContentElement;
import com.ibm.uma.Section;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.SectionList;

public class AddToSectionListCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private ContentElement contentElement;
    private SectionList sectionList;
    private Section section;
    private Collection modifiedResources;
    private boolean added;

    public AddToSectionListCommand(ContentElement contentElement, Section section, SectionList sectionList) {
        this.contentElement = contentElement;
        this.sectionList = sectionList;
        this.section = section;
        this.modifiedResources = new HashSet();
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.contentElement.getPresentation().eResource() != null) {
            this.modifiedResources.add(this.contentElement.getPresentation().eResource());
        }
        return this.modifiedResources;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.contentElement == null) {
            return;
        }
        this.sectionList.add(this.section);
        this.added = true;
        this.sectionList.apply();
    }

    public void undo() {
        if (this.added) {
            this.sectionList.remove(this.section);
            this.sectionList.apply();
            this.added = false;
        }
    }

    public Collection getAffectedObjects() {
        return Collections.singletonList(this.contentElement);
    }
}

