/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.MethodUnit;
import com.ibm.uma.NamedElement;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessElement;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.MessageException;
import com.ibm.uma.util.UmaUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.CommandStatusChecker;
import org.eclipse.epf.library.edit.command.Reference;
import org.eclipse.epf.library.edit.command.SaveStatus;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.UniquenessValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MethodElementAddCommand
extends CommandWrapper {
    protected boolean canUndo = true;
    protected AddCommand addCommand;
    protected Map elementToOldPluginMap;
    protected boolean removeXRefRequired;
    protected MethodPlugin ownerPlugin;
    protected ArrayList addList;
    protected MultiStatus status;
    protected boolean runWithProgress;
    protected ArrayList featuresToCheck;
    private static ResourceManager resMgr = null;
    private static StringValidator stringValidator = null;

    public MethodElementAddCommand(Command command) {
        this(command, true);
    }

    public MethodElementAddCommand(Command command, boolean runWithProgress) {
        super(command);
        this.addCommand = (AddCommand)TngUtil.unwrap(command);
        this.setRunWithProgress(runWithProgress);
    }

    public void setRunWithProgress(boolean runWithProgress) {
        this.runWithProgress = runWithProgress;
    }

    public boolean canUndo() {
        return this.canUndo;
    }

    public void execute() {
        this.doAdd();
    }

    public IStatus getStatus() {
        return this.status;
    }

    private boolean isMove() {
        Command cmd = TngUtil.unwrap(this.command);
        if (cmd instanceof AddCommand) {
            Iterator iter = ((AddCommand)cmd).getCollection().iterator();
            if (iter.hasNext()) {
                EObject element = (EObject)iter.next();
                return UmaUtil.getMethodPlugin((EObject)element) != null;
            }
        }
        return false;
    }

    public static Collection getIllegalOutgoingReferences(MethodPlugin ownerPlugin, EObject e, Collection illegalReferences) {
        if (illegalReferences == null) {
            illegalReferences = new ArrayList<Reference>();
        }
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)e.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject eObject = (EObject)featureIterator.next();
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)eObject);
            if (plugin == null || plugin == ownerPlugin || Misc.isBaseOf(plugin, ownerPlugin)) continue;
            illegalReferences.add(new Reference(e, featureIterator.feature(), eObject, -1));
        }
        return illegalReferences;
    }

    private static void removeReferences(Collection references) {
        Iterator iter = references.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            if (ref.feature.isMany()) {
                List list = (List)ref.owner.eGet(ref.feature);
                list.remove(ref.value);
                continue;
            }
            ref.owner.eSet(ref.feature, null);
        }
    }

    public static Collection removeIllegalReferences(MethodPlugin ownerPlugin, EObject e) {
        Collection removeRefs = MethodElementAddCommand.getIllegalOutgoingReferences(ownerPlugin, e, null);
        MethodElementAddCommand.removeReferences(removeRefs);
        return removeRefs;
    }

    public static void removeIllegalReferencesRecursively(MethodPlugin ownerPlugin, EObject e) {
        MethodElementAddCommand.removeIllegalReferences(ownerPlugin, e);
        TreeIterator iterator = e.eAllContents();
        while (iterator.hasNext()) {
            MethodElementAddCommand.removeIllegalReferences(ownerPlugin, e);
        }
    }

    private static boolean hasNext(Iterator iter) {
        return iter.hasNext();
    }

    public static boolean hasIllegalReference(MethodPlugin ownerPlugin, EObject e, Collection moveList) {
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)e.eCrossReferences().iterator();
        while (MethodElementAddCommand.hasNext((Iterator)featureIterator)) {
            MethodPlugin plugin;
            EObject eObject = (EObject)featureIterator.next();
            if (moveList.contains(eObject) || (plugin = UmaUtil.getMethodPlugin((EObject)eObject)) == null || plugin == ownerPlugin || Misc.isBaseOf(plugin, ownerPlugin)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReferencedIllegally(MethodPlugin ownerPlugin, MethodElement e, Collection moveList) {
        Collection references = AssociationHelper.getReferences((MethodElement)e);
        Iterator iter = references.iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin;
            MethodElement element = (MethodElement)iter.next();
            if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(element) || moveList.contains(element) || (plugin = UmaUtil.getMethodPlugin((EObject)element)) == null || plugin == ownerPlugin || Misc.isBaseOf(ownerPlugin, plugin)) continue;
            return true;
        }
        return false;
    }

    private static void checkModify(EObject element) {
        IStatus status = TngUtil.checkEdit(element, null);
        if (!status.isOK()) {
            throw new MessageException(TngUtil.getMessage(status));
        }
    }

    public static Collection removeIllegalReferencesTo(MethodPlugin ownerPlugin, MethodElement e, Collection moveList) {
        ArrayList<MethodElement> affectedReferencers = new ArrayList<MethodElement>();
        Collection references = AssociationHelper.getReferences((MethodElement)e);
        Iterator iter = references.iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin;
            MethodElement element = (MethodElement)iter.next();
            if (moveList.contains(element) || (plugin = UmaUtil.getMethodPlugin((EObject)element)) == null || plugin == ownerPlugin || Misc.isBaseOf(ownerPlugin, plugin)) continue;
            MethodElementAddCommand.checkModify((EObject)element);
            MethodElementAddCommand.removeReferences((EObject)element, (EObject)e);
            affectedReferencers.add(element);
        }
        return affectedReferencers;
    }

    private static Collection getXReferences(EObject referencer, EObject referenced, Collection xReferences) {
        if (xReferences == null) {
            xReferences = new ArrayList<EStructuralFeature>();
        }
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)referencer.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject eObject = (EObject)featureIterator.next();
            EStructuralFeature feature = featureIterator.feature();
            if (eObject != referenced) continue;
            xReferences.add(feature);
        }
        return xReferences;
    }

    public static Collection removeReferences(EObject referencer, EObject referenced) {
        Collection removeRefs = MethodElementAddCommand.getXReferences(referencer, referenced, null);
        Iterator iter = removeRefs.iterator();
        while (iter.hasNext()) {
            EStructuralFeature f = (EStructuralFeature)iter.next();
            if (f.isMany()) {
                ((Collection)referencer.eGet(f)).remove(referenced);
                continue;
            }
            referencer.eSet(f, null);
        }
        return removeRefs;
    }

    public static boolean hasIllegalReferenceIncludingAllChildren(MethodPlugin ownerPlugin, MethodElement e, Collection moveList) {
        if (ownerPlugin == UmaUtil.getMethodPlugin((EObject)e)) {
            return false;
        }
        if (MethodElementAddCommand.hasIllegalReference(ownerPlugin, (EObject)e, moveList)) {
            return true;
        }
        TreeIterator iterator = e.eAllContents();
        while (iterator.hasNext()) {
            if (!MethodElementAddCommand.hasIllegalReference(ownerPlugin, (EObject)iterator.next(), moveList)) continue;
            return true;
        }
        return false;
    }

    protected void superExecute() {
        super.execute();
    }

    protected Collection getFeaturesToCheck() {
        if (this.featuresToCheck == null) {
            this.featuresToCheck = new ArrayList();
            this.featuresToCheck.add(UmaPackage.eINSTANCE.getNamedElement_Name());
        }
        return this.featuresToCheck;
    }

    protected IValidator createValidator(EObject e, EStructuralFeature feature) {
        IValidator validator = null;
        validator = e instanceof ContentElement && feature == UmaPackage.eINSTANCE.getNamedElement_Name() && this.addCommand.getOwner() instanceof ContentPackage && this.addCommand.getFeature() == UmaPackage.eINSTANCE.getContentPackage_ContentElements() ? new ContentElementNameValidator(this.addCommand.getOwner(), this.addCommand.getFeature(), (ContentElement)e, new ValidatorFactory.TypeFilter(e)) : (e instanceof ProcessComponent && feature == UmaPackage.eINSTANCE.getNamedElement_Name() && this.addCommand.getOwner() instanceof ProcessPackage && this.addCommand.getFeature() == UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() ? IValidatorFactory.INSTANCE.createNameValidator((Object)this.addCommand.getOwner(), (NamedElement)e) : new UniquenessValidator(this.addCommand.getOwner(), this.addCommand.getFeature(), new ValidatorFactory.TypeFilter(e), e, feature));
        return validator;
    }

    private void getOffStringToCheckName(Object e, Collection objectsToCheckName) {
        if (this.addCommand.getOwner() instanceof ProcessPackage && this.addCommand.getFeature() == UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() && e instanceof ProcessPackage && !(e instanceof ProcessComponent)) {
            MethodElementAddCommand.getProcessComponents((ProcessPackage)e, objectsToCheckName);
        }
    }

    private static void getProcessComponents(ProcessPackage pkg, Collection objectsToCheckName) {
        Iterator iter = pkg.getChildPackages().iterator();
        while (iter.hasNext()) {
            Object childPkg = iter.next();
            if (childPkg instanceof ProcessComponent) {
                objectsToCheckName.add(childPkg);
                continue;
            }
            if (!(childPkg instanceof ProcessPackage)) continue;
            MethodElementAddCommand.getProcessComponents((ProcessPackage)childPkg, objectsToCheckName);
        }
    }

    private boolean checkStringValue(NamedElement e, EStructuralFeature feature, Collection objectsToAdd) {
        IValidator validator = this.createValidator((EObject)e, feature);
        if (validator != null) {
            String newName = null;
            try {
                newName = MethodElementAddCommand.checkStringValue(e, feature, validator, objectsToAdd);
            }
            catch (OperationCanceledException operationCanceledException) {
                return false;
            }
            if (newName != null) {
                e.eSet(feature, (Object)newName);
                this.featureChanged((EObject)e, feature, newName);
            }
        }
        return true;
    }

    protected boolean checkStringValue(EStructuralFeature feature) {
        NamedElement e;
        ArrayList objectsToCheckName = new ArrayList();
        Collection objectsToAdd = this.addCommand.getCollection();
        Iterator iter = objectsToAdd.iterator();
        while (iter.hasNext()) {
            e = (NamedElement)iter.next();
            if (!this.checkStringValue(e, feature, objectsToAdd)) {
                return false;
            }
            this.getOffStringToCheckName(e, objectsToCheckName);
        }
        iter = objectsToCheckName.iterator();
        while (iter.hasNext()) {
            e = (NamedElement)iter.next();
            if (this.checkStringValue(e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), objectsToCheckName)) continue;
            return false;
        }
        return true;
    }

    protected void featureChanged(EObject object, EStructuralFeature feature, Object newValue) {
    }

    private static Collection getElementsToCheckName(AddCommand addCommand) {
        ArrayList elements = new ArrayList(addCommand.getCollection());
        Iterator iter = addCommand.getCollection().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof ProcessPackage)) continue;
            AbstractTreeIterator iterator = new AbstractTreeIterator(element, false){
                private static final long serialVersionUID = 1L;

                protected Iterator getChildren(Object object) {
                    if (object instanceof ProcessComponent) {
                        return Collections.EMPTY_LIST.iterator();
                    }
                    if (object instanceof ProcessPackage) {
                        return ((ProcessPackage)object).getChildPackages().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            };
            while (iterator.hasNext()) {
                Object pkg = iterator.next();
                if (!(pkg instanceof ProcessComponent)) continue;
                elements.add(pkg);
            }
        }
        return elements;
    }

    protected static Map checkName(AddCommand addCommand) {
        Collection elementsToCheck = MethodElementAddCommand.getElementsToCheckName(addCommand);
        HashMap<NamedElement, String> elementToNewNameMap = new HashMap<NamedElement, String>();
        Iterator iter = elementsToCheck.iterator();
        while (iter.hasNext()) {
            NamedElement e = (NamedElement)iter.next();
            IValidator validator = e instanceof ContentElement ? new ContentElementNameValidator(addCommand.getOwner(), addCommand.getFeature(), (ContentElement)e, new ValidatorFactory.TypeFilter((EObject)e)) : IValidatorFactory.INSTANCE.createNameValidator((Object)addCommand.getOwner(), e);
            String newName = null;
            try {
                newName = MethodElementAddCommand.checkStringValue(e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), validator, elementsToCheck);
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            if (newName == null) continue;
            IStatus status = UserInteractionHelper.checkModify((EObject)e, null);
            String title = LibraryEditResources.getString("LibraryEdit.errorDialog.title");
            String msg = MessageFormat.format(LibraryEditResources.getString("LibraryEdit.errorDialog.cannotRename"), TngUtil.getTypeText((EObject)e), e.getName(), newName);
            while (!status.isOK()) {
                if (LibraryEditPlugin.INSTANCE.getMsgDialog().displayConfirmation(title, msg, status) != 1) continue;
                return null;
            }
            elementToNewNameMap.put(e, newName);
        }
        return elementToNewNameMap;
    }

    public static String checkStringValue(NamedElement e, EStructuralFeature feature, IValidator validator, Collection objectsToAdd) throws OperationCanceledException {
        String msg;
        final StringValidator strValidator = MethodElementAddCommand.getStringValidator();
        strValidator.setElements(objectsToAdd);
        strValidator.setFeature(feature);
        strValidator.setValidator(validator);
        String str = (String)e.eGet(feature);
        if (str != null && str.length() > 0 && (msg = strValidator.isValid(str)) != null) {
            String featureTxt = TngUtil.getFeatureText(feature);
            String title = LibraryEditResources.getString("LibraryEdit.resolveNameConflictDialog.title");
            String dlgMsg = LibraryEditResources.formatString("LibraryEdit.resolveNameConflictDialog.text", StrUtil.toLower((String)featureTxt), e.getName());
            String currentValue = (String)e.eGet(feature);
            IInputValidator inputValidator = new IInputValidator(){

                public String isValid(String newText) {
                    if (strValidator != null) {
                        return UserInteractionHelper.getSimpleErrorMessage(strValidator.isValid(newText));
                    }
                    return null;
                }
            };
            InputDialog inputDlg = new InputDialog(MsgBox.getDefaultShell(), title, dlgMsg, currentValue, inputValidator);
            if (inputDlg.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDlg.getValue();
        }
        return null;
    }

    public Collection getAffectedObjects() {
        Set<EObject> affectedObjects = super.getAffectedObjects();
        if (affectedObjects == null) {
            EObject owner = this.addCommand.getOwner();
            affectedObjects = owner == null ? Collections.EMPTY_SET : Collections.singleton(owner);
        }
        return affectedObjects;
    }

    protected Collection getElementsToCheckForIllegalReferences() {
        return this.addCommand.getCollection();
    }

    private static boolean isExcludedFromOutgoingReferenceCheck(Object e) {
        return e instanceof ProcessPackage || e instanceof ProcessElement;
    }

    protected String checkForIllegalReferences() {
        Object element;
        Collection elements = this.getElementsToCheckForIllegalReferences();
        this.addList = new ArrayList(elements);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            element = (EObject)iter.next();
            TreeIterator iterator = element.eAllContents();
            while (iterator.hasNext()) {
                this.addList.add(iterator.next());
            }
        }
        this.ownerPlugin = UmaUtil.getMethodPlugin((EObject)this.addCommand.getOwner());
        this.removeXRefRequired = false;
        iter = this.addCommand.getCollection().iterator();
        while (iter.hasNext()) {
            element = iter.next();
            if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(element) || !(element instanceof MethodElement) || !MethodElementAddCommand.hasIllegalReferenceIncludingAllChildren(this.ownerPlugin, (MethodElement)element, this.addList)) continue;
            this.removeXRefRequired = true;
            break;
        }
        if (this.removeXRefRequired) {
            return LibraryEditResources.getString("LibraryEdit.invalidReferencesError.reason");
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected void saveModifiedResources() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [6 : 423->427)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doAdd() {
        try {
            Iterator iter = this.getFeaturesToCheck().iterator();
            while (iter.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                if (this.checkStringValue(feature)) continue;
                return;
            }
            boolean showWarning = false;
            EditingDomain ed = this.addCommand.getDomain();
            if (ed instanceof TraceableAdapterFactoryEditingDomain) {
                Map copyToOriginalMap = ((TraceableAdapterFactoryEditingDomain)ed).getCopyToOriginalMap();
                if (this.addCommand.getCollection() != null && this.addCommand.getCollection().size() > 0 && copyToOriginalMap.containsKey(this.addCommand.getCollection().toArray()[0])) {
                    this.elementToOldPluginMap = new HashMap();
                    Iterator iter2 = copyToOriginalMap.entrySet().iterator();
                    while (iter2.hasNext()) {
                        Map.Entry entry = iter2.next();
                        if (!(entry.getValue() instanceof MethodElement) || entry.getValue() instanceof MethodConfiguration) continue;
                        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)entry.getValue()));
                        if (plugin != null) {
                            this.elementToOldPluginMap.put(entry.getKey(), plugin);
                            continue;
                        }
                        showWarning = true;
                    }
                }
            }
            if (showWarning) {
                LibraryEditPlugin.getDefault().getMsgDialog().displayWarning(this.getLabel(), LibraryEditResources.getString("LibraryEdit.MethodElementAddCommand.originalNotFoundWarning.msg"));
            }
            final StringBuffer msgBuff = new StringBuffer();
            Object operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    String msg = MethodElementAddCommand.this.checkForIllegalReferences();
                    if (msg != null) {
                        msgBuff.append(msg);
                    }
                }
            };
            NullProgressMonitor defaultMonitor = null;
            if (!this.runWithProgress) {
                defaultMonitor = new NullProgressMonitor();
            }
            if (this.runWithProgress) {
                UserInteractionHelper.runWithProgress(operation, LibraryEditResources.getString("LibraryEdit.checkingReferencesTask.name"));
            } else {
                try {
                    operation.run((IProgressMonitor)defaultMonitor);
                }
                catch (RuntimeException e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    throw e;
                }
                catch (Exception e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    throw new RuntimeException(e.toString());
                }
            }
            if (msgBuff.length() > 0 && MsgBox.prompt((Shell)Display.getCurrent().getActiveShell(), (String)msgBuff.toString(), (int)192) == 128) {
                return;
            }
            this.status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.getString("LibraryEdit.MethodElementAddCommand.errorSavingFiles"), null);
            operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    if (MethodElementAddCommand.this.removeXRefRequired) {
                        monitor.subTask("");
                        Iterator iter = MethodElementAddCommand.this.addList.iterator();
                        while (iter.hasNext()) {
                            EObject element = (EObject)iter.next();
                            if (!(element instanceof MethodElement)) continue;
                            MethodElementAddCommand.removeIllegalReferences(MethodElementAddCommand.this.ownerPlugin, element);
                        }
                    }
                    MethodElementAddCommand.this.superExecute();
                    monitor.subTask(LibraryEditResources.getString("LibraryEdit.savingModifiedFilesTask.name"));
                    MethodElementAddCommand.this.saveModifiedResources();
                    if (!MethodElementAddCommand.this.status.isOK()) {
                        MethodElementAddCommand.this.undo();
                    }
                }
            };
            if (this.runWithProgress) {
                UserInteractionHelper.runWithProgress(operation, "");
            } else {
                try {
                    operation.run((IProgressMonitor)defaultMonitor);
                }
                catch (RuntimeException e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    throw e;
                }
                catch (Exception e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    throw new RuntimeException(e.toString());
                }
            }
            if (!this.status.isOK()) {
                LibraryEditPlugin.getDefault().getMsgDialog().displayError(this.getLabel(), LibraryEditResources.getString("LibraryEdit.error.msgWithDetails"), (IStatus)this.status);
                return;
            }
        }
        catch (RuntimeException e) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(this.getLabel(), LibraryEditResources.getString("LibraryEdit.error.msg"), (Throwable)e);
        }
    }

    public static void setResourceManager(ResourceManager resMgr) {
        MethodElementAddCommand.resMgr = resMgr;
    }

    private static StringValidator getStringValidator() {
        if (stringValidator == null) {
            stringValidator = new StringValidator();
        }
        return stringValidator;
    }

    static /* synthetic */ ResourceManager access$2() {
        return resMgr;
    }

    private static class ContainmentInfo {
        EObject container;
        int index;

        ContainmentInfo(EObject container, int index) {
            this.container = container;
            this.index = index;
        }
    }

    private static class IllegalReferenceRemover {
        private MethodPlugin targetPlugin;
        private Collection elementsToMove;
        private List illegalReferences;
        private Set affectedResources;
        private ArrayList removedReferences;
        private boolean searchOutgoingRefs;
        private boolean searchIncomingRefs;

        public IllegalReferenceRemover(MethodPlugin targetPlugin, Collection elementsToMove, boolean searchOutgoingRefs, boolean searchIncomingRefs) {
            this.targetPlugin = targetPlugin;
            this.elementsToMove = elementsToMove;
            this.searchOutgoingRefs = searchOutgoingRefs;
            this.searchIncomingRefs = searchIncomingRefs;
        }

        public Set getAffectedResources() {
            if (this.affectedResources == null) {
                this.illegalReferences = new ArrayList();
                Iterator iterator = this.elementsToMove.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (!(obj instanceof MethodElement)) continue;
                    MethodElement e = (MethodElement)obj;
                    if (this.searchOutgoingRefs && MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(obj)) {
                        MethodElementAddCommand.getIllegalOutgoingReferences(this.targetPlugin, (EObject)e, this.illegalReferences);
                    }
                    if (!this.searchIncomingRefs) continue;
                    Collection references = AssociationHelper.getReferences((MethodElement)e);
                    Iterator iter = references.iterator();
                    while (iter.hasNext()) {
                        MethodPlugin plugin;
                        MethodElement element = (MethodElement)iter.next();
                        if (this.elementsToMove.contains(element) || (plugin = UmaUtil.getMethodPlugin((EObject)element)) == null || plugin == this.targetPlugin || Misc.isBaseOf(this.targetPlugin, plugin)) continue;
                        Collection xRefs = MethodElementAddCommand.getXReferences((EObject)element, (EObject)e, null);
                        Iterator iter1 = xRefs.iterator();
                        while (iter1.hasNext()) {
                            EStructuralFeature f = (EStructuralFeature)iter1.next();
                            this.illegalReferences.add(new Reference((EObject)element, f, e));
                        }
                    }
                }
                this.affectedResources = new HashSet();
                Iterator iter = this.illegalReferences.iterator();
                while (iter.hasNext()) {
                    Reference ref = (Reference)iter.next();
                    if (ref.owner.eResource() == null) continue;
                    this.affectedResources.add(ref.owner.eResource());
                }
            }
            return this.affectedResources;
        }

        public void removeIllegalReferences() {
            this.removedReferences = new ArrayList();
            Iterator iter = this.illegalReferences.iterator();
            while (iter.hasNext()) {
                Reference ref = (Reference)iter.next();
                if (ref.feature.isMany()) {
                    List list = (List)ref.owner.eGet(ref.feature);
                    list.remove(ref.value);
                } else {
                    ref.owner.eSet(ref.feature, null);
                }
                this.removedReferences.add(ref);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void restoreRemovedReferences() {
            if (this.removedReferences == null) {
                return;
            }
            i = this.removedReferences.size() - 1;
            while (i > -1) {
                ref = (Reference)this.removedReferences.get(i);
                if (ref.feature.isMany()) {
                    list = (List)ref.owner.eGet(ref.feature);
                    if (ref.index != -1) {
                        if (list.contains(ref.value)) ** GOTO lbl23
                        if (ref.index < list.size()) {
                            list.add(ref.index, ref.value);
                        }
                        list.add(ref.value);
                    } else {
                        list.add(ref.value);
                    }
                } else {
                    ref.owner.eSet(ref.feature, ref.value);
                }
lbl23:
                // 5 sources

                --i;
            }
        }
    }

    public static class MoveOperation {
        private static final int STATE_START = 0;
        private static final int STATE_SAVED_FILES = 80;
        private static final int STATE_MOVED_FILES = 70;
        private static final int STATE_COPIED_RESOURCES = 90;
        private static final int STATE_END = 100;
        private AddCommand addCommand;
        private Collection moveList;
        private boolean removeXRefRequired = false;
        private boolean isRefenrecedIllegally = false;
        private MethodPlugin ownerPlugin;
        private Map elementToOldPluginMap;
        private Map elementToNewNameMap;
        private IProgressMonitor monitor;
        private Shell shell;
        private HashSet movedResources;
        private MultiStatus status;
        private int state;
        protected Set modifiedResources;
        private IllegalReferenceRemover illegalReferenceRemover;
        private HashMap elementToOldContainerMap;

        public MoveOperation(Command command, IProgressMonitor monitor, Shell shell) {
            this.addCommand = (AddCommand)TngUtil.unwrap(command);
            this.monitor = monitor;
            this.shell = shell;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public boolean reloadNeeded() {
            return this.status != null && CommandStatusChecker.hasRollbackError((IStatus)this.status);
        }

        private void undo() {
            NamedElement e;
            Map.Entry entry;
            Iterator iter;
            if (this.elementToNewNameMap != null) {
                iter = this.elementToNewNameMap.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    e = (NamedElement)entry.getKey();
                    e.setName((String)entry.getValue());
                }
            }
            if (this.elementToOldContainerMap != null) {
                iter = this.elementToOldContainerMap.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    e = (EObject)entry.getKey();
                    ContainmentInfo containmentInfo = (ContainmentInfo)entry.getValue();
                    EStructuralFeature f = this.addCommand.getFeature();
                    if (f.isMany()) {
                        ((List)containmentInfo.container.eGet(f)).add(containmentInfo.index, e);
                        continue;
                    }
                    containmentInfo.container.eSet(f, (Object)e);
                }
            }
            if (this.illegalReferenceRemover != null) {
                this.illegalReferenceRemover.restoreRemovedReferences();
            }
        }

        public void run() {
            this.state = 0;
            this.status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.getString("LibraryEdit.error.reason"), null);
            if (this.checkName()) {
                String msg;
                Throwable ex;
                StringBuffer msgBuffer = new StringBuffer();
                Object runnable = new IRunnableWithProgress(this, msgBuffer){
                    final /* synthetic */ MoveOperation this$1;
                    private final /* synthetic */ StringBuffer val$msgBuffer;
                    {
                        this.this$1 = moveOperation;
                        this.val$msgBuffer = stringBuffer;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.subTask(LibraryEditResources.getString("LibraryEdit.checkingReferencesTask.name"));
                        String msg = MoveOperation.access$0(this.this$1);
                        if (msg != null) {
                            this.val$msgBuffer.append(msg);
                        }
                    }
                };
                try {
                    ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.shell.getDisplay());
                }
                catch (Exception e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    Throwable ex2 = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                    String msg2 = TngUtil.toStackTraceString(ex2);
                    this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg2, ex2));
                    return;
                }
                if (msgBuffer.length() > 0 && MsgBox.prompt((Shell)this.shell, (String)msgBuffer.toString(), (int)192) == 128) {
                    return;
                }
                HashMap<EObject, Resource> elementToOldResourceMap = new HashMap<EObject, Resource>();
                Iterator<Object> iter = this.moveList.iterator();
                while (iter.hasNext()) {
                    EObject element = (EObject)iter.next();
                    if (!(element instanceof MethodElement)) continue;
                    elementToOldResourceMap.put(element, element.eResource());
                }
                if (this.removeXRefRequired || this.isRefenrecedIllegally) {
                    this.illegalReferenceRemover = new IllegalReferenceRemover(this.ownerPlugin, this.moveList, this.removeXRefRequired, this.isRefenrecedIllegally);
                    runnable = new IRunnableWithProgress(this){
                        final /* synthetic */ MoveOperation this$1;
                        {
                            this.this$1 = moveOperation;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.subTask(LibraryEditResources.getString("LibraryEdit.checkAffectedResourcesTask.name"));
                            this.this$1.modifiedResources = MoveOperation.access$1(this.this$1).getAffectedResources();
                        }
                    };
                    try {
                        ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.shell.getDisplay());
                    }
                    catch (Exception e) {
                        LibraryEditPlugin.INSTANCE.log(e);
                        ex = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                        String msg3 = TngUtil.toStackTraceString(ex);
                        this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg3, ex));
                        return;
                    }
                    IStatus execStatus = UserInteractionHelper.checkModify(this.modifiedResources, this.shell);
                    if (!execStatus.isOK()) {
                        LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.moveDialog.title"), execStatus);
                        return;
                    }
                    try {
                        this.monitor.subTask(LibraryEditResources.getString("LibraryEdit.removingReferencestask.name"));
                        this.illegalReferenceRemover.removeIllegalReferences();
                    }
                    catch (Exception e) {
                        this.undo();
                        msg = TngUtil.toStackTraceString(e);
                        this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, (Throwable)e));
                    }
                } else {
                    this.modifiedResources = new HashSet();
                    this.monitor.subTask("");
                }
                iter = this.elementToNewNameMap.entrySet().iterator();
                while (iter.hasNext()) {
                    ContentElement e;
                    Map.Entry entry = (Map.Entry)iter.next();
                    NamedElement element = (NamedElement)entry.getKey();
                    element.setName((String)entry.getValue());
                    this.modifiedResources.add(element.eResource());
                    if (!(element instanceof MethodUnit)) continue;
                    this.movedResources.add(element.eResource());
                    if (!(element instanceof ContentElement) || !ContentDescriptionFactory.hasPresentation((MethodElement)(e = (ContentElement)element))) continue;
                    this.movedResources.add(e.getPresentation());
                }
                runnable = new IRunnableWithProgress(this, elementToOldResourceMap){
                    final /* synthetic */ MoveOperation this$1;
                    private final /* synthetic */ Map val$elementToOldResourceMap;
                    {
                        this.this$1 = moveOperation;
                        this.val$elementToOldResourceMap = map;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.setTaskName(LibraryEditResources.getString("LibraryEdit.movingTask.name"));
                        MoveOperation.access$2(this.this$1, monitor, this.val$elementToOldResourceMap, this.this$1.modifiedResources);
                    }
                };
                try {
                    ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.shell.getDisplay());
                }
                catch (Exception e) {
                    this.undo();
                    ex = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                    msg = TngUtil.toStackTraceString(ex);
                    this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, ex));
                    return;
                }
                ArrayList resources = new ArrayList(this.movedResources);
                resources.removeAll(this.modifiedResources);
                IStatus execStatus = UserInteractionHelper.checkModify(resources, this.shell);
                if (!execStatus.isOK()) {
                    LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.moveDialog.title"), execStatus);
                    this.undo();
                    return;
                }
                runnable = new IRunnableWithProgress(this){
                    final /* synthetic */ MoveOperation this$1;
                    {
                        this.this$1 = moveOperation;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IStatus saveStatus = MoveOperation.access$3(this.this$1, monitor);
                            if (!saveStatus.isOK()) {
                                MoveOperation.access$4(this.this$1).add(saveStatus);
                            }
                        }
                        catch (RuntimeException e) {
                            LibraryEditPlugin.INSTANCE.log(e);
                            throw e;
                        }
                    }
                };
                try {
                    ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.shell.getDisplay());
                }
                catch (Exception e) {
                    Throwable ex3 = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                    String msg4 = TngUtil.toStackTraceString(ex3);
                    this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg4, ex3));
                    return;
                }
            }
            this.state = 100;
        }

        private boolean checkName() {
            this.elementToNewNameMap = MethodElementAddCommand.checkName(this.addCommand);
            return this.elementToNewNameMap != null;
        }

        private String checkForIllegalReferences() {
            Object element;
            this.elementToOldPluginMap = new HashMap();
            this.moveList = new ArrayList(this.addCommand.getCollection());
            this.movedResources = new HashSet();
            Iterator iter = this.addCommand.getCollection().iterator();
            while (iter.hasNext()) {
                element = (EObject)iter.next();
                if (element instanceof MethodElement) {
                    this.elementToOldPluginMap.put(element, UmaUtil.getMethodPlugin((EObject)element));
                }
                TreeIterator iterator = element.eAllContents();
                while (iterator.hasNext()) {
                    this.moveList.add(iterator.next());
                }
            }
            this.ownerPlugin = UmaUtil.getMethodPlugin((EObject)this.addCommand.getOwner());
            iter = this.addCommand.getCollection().iterator();
            while (iter.hasNext()) {
                element = iter.next();
                if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(element) || !(element instanceof MethodElement) || !MethodElementAddCommand.hasIllegalReferenceIncludingAllChildren(this.ownerPlugin, (MethodElement)element, this.moveList)) continue;
                this.removeXRefRequired = true;
                break;
            }
            iter = this.moveList.iterator();
            while (iter.hasNext()) {
                element = iter.next();
                if (!(element instanceof MethodElement) || !MethodElementAddCommand.isReferencedIllegally(this.ownerPlugin, (MethodElement)element, this.moveList)) continue;
                this.isRefenrecedIllegally = true;
                break;
            }
            if (this.removeXRefRequired || this.isRefenrecedIllegally) {
                return LibraryEditResources.getString("LibraryEdit.invalidReferencesError.reason");
            }
            return null;
        }

        private void doMove(IProgressMonitor monitor, Map elementToOldResourceMap, Set modifiedResources) {
            monitor.subTask("");
            this.elementToOldContainerMap = new HashMap();
            Iterator iter = this.addCommand.getCollection().iterator();
            while (iter.hasNext()) {
                EObject element = (EObject)iter.next();
                if (!(element instanceof MethodElement)) continue;
                EObject container = element.eContainer();
                EStructuralFeature feature = element.eContainingFeature();
                int index = feature.isMany() ? ((List)container.eGet(feature)).indexOf(element) : -1;
                this.elementToOldContainerMap.put(element, new ContainmentInfo(container, index));
            }
            this.addCommand.execute();
            Resource newResource = this.addCommand.getOwner().eResource();
            modifiedResources.add(newResource);
            Iterator iter2 = this.addCommand.getAffectedObjects().iterator();
            while (iter2.hasNext()) {
                Object plugin;
                EObject element = (EObject)TngUtil.unwrap(iter2.next());
                if (!(element instanceof MethodElement)) continue;
                EObject oldContainer = ((ContainmentInfo)this.elementToOldContainerMap.get((Object)element)).container;
                if (oldContainer.eResource() != newResource && !oldContainer.eResource().getContents().isEmpty()) {
                    modifiedResources.add(oldContainer.eResource());
                    Resource oldResource = (Resource)elementToOldResourceMap.get(element);
                    if (oldContainer.eResource() != oldResource) {
                        this.movedResources.add(oldResource);
                    }
                }
                if (this.ownerPlugin == (plugin = this.elementToOldPluginMap.get(element))) continue;
                TreeIterator iterator = element.eAllContents();
                while (iterator.hasNext()) {
                    EObject e = (EObject)iterator.next();
                    if (!UmaUtil.hasDirectResource((EObject)e)) continue;
                    this.movedResources.add(e.eResource());
                    this.elementToOldPluginMap.put(e, plugin);
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IStatus save(IProgressMonitor monitor) {
            block26: {
                status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.getString("LibraryEdit.MethodElementAddCommand.errorSavingFiles"), null);
                monitor.subTask(LibraryEditResources.getString("LibraryEdit.savingModifiedFilesTask.name"));
                persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                try {
                    try {
                        block25: {
                            if (!this.movedResources.isEmpty()) {
                                monitor.subTask(LibraryEditResources.getString("LibraryEdit.movingFilesTask.name"));
                                persister.adjustLocation((Collection)this.movedResources);
                            }
                            this.state = 70;
                            iter = this.modifiedResources.iterator();
                            while (true) {
                                if (!iter.hasNext()) {
                                    persister.commit();
                                    this.state = 80;
                                    if (MethodElementAddCommand.access$2() != null) {
                                        break;
                                    }
                                    break block25;
                                }
                                resource = (Resource)iter.next();
                                try {
                                    persister.save(resource);
                                }
                                catch (Exception e) {
                                    msg = LibraryEditResources.formatString("LibraryEdit.saveFileError.reason", resource.getURI().toFileString());
                                    status.add((IStatus)new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, msg, e));
                                    var11_13 = null;
                                    if (status.getSeverity() == 4) {
                                        try {
                                            persister.rollback();
                                        }
                                        catch (Exception e) {
                                            LibraryEditPlugin.INSTANCE.log(e);
                                            msg = new StringWriter();
                                            e.printStackTrace(new PrintWriter(msg));
                                            newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                                            status.add((IStatus)newStatus);
                                        }
                                    }
                                    break block26;
                                }
                            }
                            monitor.subTask(LibraryEditResources.getString("LibraryEdit.copyingResourcesTask.name"));
                            elementsToCopyRefContents = new ArrayList<E>();
                            iter = this.movedResources.iterator();
                            while (true) {
                                if (!iter.hasNext()) {
                                    modified = MethodElementAddCommand.access$2().copyReferencedContents(elementsToCopyRefContents, this.elementToOldPluginMap);
                                    if (modified != null && !modified.isEmpty()) {
                                        iter = modified.iterator();
                                        break;
                                    }
                                    break block25;
                                }
                                resource = (Resource)iter.next();
                                elementsToCopyRefContents.addAll(resource.getContents());
                            }
                            while (iter.hasNext()) {
                                resource = (Resource)iter.next();
                                pathArgs = new Object[]{resource.getURI().toFileString()};
                                try {
                                    monitor.subTask(MessageFormat.format(LibraryEditResources.getString("LibraryEdit.savingFileTask.name"), pathArgs));
                                    persister.save(resource);
                                }
                                catch (Exception e) {
                                    msg = MessageFormat.format(LibraryEditResources.getString("LibraryEdit.saveFileError.reason"), pathArgs);
                                    status.add((IStatus)new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, msg, e));
                                    var11_14 = null;
                                    if (status.getSeverity() == 4) {
                                        ** try [egrp 4[TRYBLOCK] [7 : 512->521)] { 
lbl67:
                                        // 1 sources

                                        persister.rollback();
lbl69:
                                        // 1 sources

                                        catch (Exception e) {
                                            LibraryEditPlugin.INSTANCE.log(e);
                                            msg = new StringWriter();
                                            e.printStackTrace(new PrintWriter(msg));
                                            newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                                            status.add((IStatus)newStatus);
                                        }
                                    }
                                    break block26;
                                }
                            }
                        }
                        persister.commit();
                        this.state = 90;
                    }
                    catch (RuntimeException e) {
                        msg = new StringWriter();
                        e.printStackTrace(new PrintWriter(msg));
                        newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, msg.toString(), e);
                        status.add((IStatus)newStatus);
                    }
                }
                catch (Throwable var12_32) {
                    var11_15 = null;
                    if (status.getSeverity() != 4) throw var12_32;
                    ** try [egrp 4[TRYBLOCK] [7 : 512->521)] { 
lbl91:
                    // 1 sources

                    persister.rollback();
                    throw var12_32;
lbl93:
                    // 1 sources

                    catch (Exception e) {
                        LibraryEditPlugin.INSTANCE.log(e);
                        msg = new StringWriter();
                        e.printStackTrace(new PrintWriter(msg));
                        newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                        status.add((IStatus)newStatus);
                    }
                    throw var12_32;
                }
                {
                    var11_16 = null;
                }
                if (status.getSeverity() == 4) {
                    ** try [egrp 4[TRYBLOCK] [7 : 512->521)] { 
lbl103:
                    // 1 sources

                    persister.rollback();
                    break block26;
lbl105:
                    // 1 sources

                    catch (Exception e) {
                        LibraryEditPlugin.INSTANCE.log(e);
                        msg = new StringWriter();
                        e.printStackTrace(new PrintWriter(msg));
                        newStatus = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, msg.toString(), e);
                        status.add((IStatus)newStatus);
                    }
                }
            }
            monitor.subTask(LibraryEditResources.getString("LibraryEdit.command.done"));
            return status;
        }

        static /* synthetic */ String access$0(MoveOperation moveOperation) {
            return moveOperation.checkForIllegalReferences();
        }

        static /* synthetic */ IllegalReferenceRemover access$1(MoveOperation moveOperation) {
            return moveOperation.illegalReferenceRemover;
        }

        static /* synthetic */ void access$2(MoveOperation moveOperation, IProgressMonitor iProgressMonitor, Map map, Set set) {
            moveOperation.doMove(iProgressMonitor, map, set);
        }

        static /* synthetic */ IStatus access$3(MoveOperation moveOperation, IProgressMonitor iProgressMonitor) {
            return moveOperation.save(iProgressMonitor);
        }

        static /* synthetic */ MultiStatus access$4(MoveOperation moveOperation) {
            return moveOperation.status;
        }
    }

    public static interface ResourceManager {
        public Collection copyReferencedContents(Collection var1, Map var2);
    }

    public static class BasicResourceManager
    implements ResourceManager {
        public Collection copyReferencedContents(Collection elements, Map elementToOldPluginMap) {
            return null;
        }
    }

    private static class StringValidator
    implements IInputValidator {
        private Collection elements;
        private IValidator validator;
        private EStructuralFeature feature;

        StringValidator() {
        }

        public StringValidator(Collection elements, EStructuralFeature feature) {
            this.elements = elements;
            this.feature = feature;
        }

        public void setElements(Collection elements) {
            this.elements = elements;
        }

        public void setFeature(EStructuralFeature feature) {
            this.feature = feature;
        }

        public void setValidator(IValidator validator) {
            this.validator = validator;
        }

        public String isValid(String newText) {
            if (this.validator instanceof UniquenessValidator) {
                EObject obj = ((UniquenessValidator)this.validator).getEObject();
                int classID = obj.eClass().getClassifierID();
                newText = newText.trim();
                Iterator iter = this.elements.iterator();
                while (iter.hasNext()) {
                    EObject e = (EObject)iter.next();
                    String str = (String)e.eGet(this.feature);
                    if (obj == e || classID != e.eClass().getClassifierID() || !newText.equalsIgnoreCase(str)) continue;
                    return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", newText);
                }
            }
            return this.validator.isValid(newText);
        }
    }
}

