/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.MethodPlugin;
import com.ibm.uma.ProcessElement;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.UmaUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;

public class RemoveReferencesCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private MethodPlugin plugin;
    private MethodPlugin base;
    private Map featureValuePairToObjectMap;
    private Collection modifiedResources;

    public RemoveReferencesCommand(MethodPlugin plugin, MethodPlugin base) {
        this.plugin = plugin;
        this.base = base;
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }

    public void execute() {
        this.featureValuePairToObjectMap = new HashMap();
        this.modifiedResources = new HashSet();
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)this.plugin.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject ref = (EObject)featureIterator.next();
            EStructuralFeature f = featureIterator.feature();
            if (f == UmaPackage.eINSTANCE.getMethodPlugin_Bases() || UmaUtil.getMethodPlugin((EObject)ref) != this.base) continue;
            this.featureValuePairToObjectMap.put(new FeatureValuePair(f, ref), this.plugin);
        }
        TreeIterator iter = this.plugin.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element instanceof ProcessElement) continue;
            EContentsEList.FeatureIterator featureIterator2 = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
            while (featureIterator2.hasNext()) {
                EObject ref = (EObject)featureIterator2.next();
                if (UmaUtil.getMethodPlugin((EObject)ref) != this.base) continue;
                EStructuralFeature f = featureIterator2.feature();
                this.featureValuePairToObjectMap.put(new FeatureValuePair(f, ref), element);
            }
        }
        this.redo();
    }

    public void redo() {
        Iterator iter = this.featureValuePairToObjectMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            FeatureValuePair fvPair = (FeatureValuePair)entry.getKey();
            EObject element = (EObject)entry.getValue();
            if (fvPair.feature.isMany()) {
                ((Collection)element.eGet(fvPair.feature)).remove(fvPair.value);
            } else {
                element.eSet(fvPair.feature, null);
            }
            if (element.eResource() == null) continue;
            this.modifiedResources.add(element.eResource());
        }
    }

    public void undo() {
        Iterator iter = this.featureValuePairToObjectMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            FeatureValuePair fvPair = (FeatureValuePair)entry.getKey();
            EObject element = (EObject)entry.getValue();
            if (fvPair.feature.isMany()) {
                ((Collection)element.eGet(fvPair.feature)).add(fvPair.value);
                continue;
            }
            element.eSet(fvPair.feature, fvPair.value);
        }
    }

    private static class FeatureValuePair {
        EStructuralFeature feature;
        Object value;

        FeatureValuePair(EStructuralFeature f, Object v) {
            this.feature = f;
            this.value = v;
        }
    }
}

