/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import com.ibm.uma.ContentPackage;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.util.UmaUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.ModelStructure;

public class MethodConfigurationElementList {
    private MethodConfiguration methodConfig;
    private List filterList;

    public MethodConfigurationElementList(MethodConfiguration methodConfig, List filterList) {
        this.methodConfig = methodConfig;
        this.filterList = filterList;
    }

    protected boolean checkAcceptance() {
        return true;
    }

    protected boolean accept(Object object) {
        int size = this.filterList.size();
        int i = 0;
        while (i < size) {
            IFilter filter = (IFilter)this.filterList.get(i);
            if (!filter.accept(object)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Iterator newIterator(ContentPackage pkg) {
        return new ElementIterator(pkg);
    }

    private void getAllElements(ContentPackage pkg, List list) {
        Iterator iter = this.newIterator(pkg);
        while (iter.hasNext()) {
            Object e = iter.next();
            if (e instanceof ContentPackage) continue;
            list.add(e);
        }
    }

    public List getList() {
        ArrayList list = new ArrayList();
        Iterator iter = this.methodConfig.getMethodPluginSelection().iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)iter.next();
            ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
            if (pkg == null) continue;
            this.getAllElements(pkg, list);
        }
        return list;
    }

    protected class ElementIterator
    extends AbstractTreeIterator {
        private static final long serialVersionUID = -2291438970123985906L;

        protected ElementIterator(ContentPackage contentPkg) {
            super((Object)contentPkg, false);
        }

        protected List getChildrenList(Object object) {
            ArrayList children = new ArrayList();
            if (object instanceof ContentPackage) {
                ContentPackage pkg = (ContentPackage)object;
                List packages = pkg.getChildPackages();
                int size = packages.size();
                int i = 0;
                while (i < size) {
                    Object obj = packages.get(i);
                    if (obj instanceof ContentPackage && MethodConfigurationElementList.this.methodConfig.getMethodPackageSelection().contains(obj)) {
                        children.add(obj);
                    }
                    ++i;
                }
                if (MethodConfigurationElementList.this.checkAcceptance()) {
                    List elements = pkg.getContentElements();
                    size = elements.size();
                    int i2 = 0;
                    while (i2 < size) {
                        Object obj = elements.get(i2);
                        if (MethodConfigurationElementList.this.accept(obj)) {
                            children.add(obj);
                        }
                        ++i2;
                    }
                } else {
                    children.addAll(pkg.getContentElements());
                }
            }
            return children;
        }

        protected Iterator getChildren(Object object) {
            return this.getChildrenList(object).iterator();
        }
    }
}

