/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.Deliverable;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.PBSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class OBSDropCommand
extends BSDropCommand {
    private ArrayList wpDescList;
    private ArrayList roleDescList;
    private Map roleDescTeamProfileMap;
    private Map wpDescToDeliverableParts;
    private HashMap wpdToDeliverableDescriptorMap;
    private HashMap wpdToTaskFeaturesMap;
    private IConfigurator configrator;
    private boolean newDuplicatesRemoved;

    public OBSDropCommand(Activity act, List roles) {
        super(act, roles);
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof Role) continue;
            iter.remove();
        }
    }

    public OBSDropCommand(Activity activity, List dropElements, MethodConfiguration config, Set synchFeatures, IConfigurator configurator) {
        super(activity, dropElements, config, synchFeatures);
        this.configrator = configurator;
    }

    protected boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.roleDescList = new ArrayList();
        this.taskDescList = new ArrayList();
        this.wpDescList = new ArrayList();
        this.wpDescToDeliverableParts = new HashMap();
        this.wpdToDeliverableDescriptorMap = new HashMap();
        MethodConfiguration config = this.getMethodConfiguration();
        Set descriptorsToRefresh = this.synchronize ? this.batchCommand.getDescriptorsToRefresh() : null;
        int i = 0;
        while (i < this.dropElements.size()) {
            List selectedWorkProducts;
            List workProducts;
            RoleDescriptor roleDesc;
            Role role = (Role)this.dropElements.get(i);
            if (TngUtil.isContributor((VariabilityElement)role)) {
                role = (Role)TngUtil.getBase((VariabilityElement)role);
            }
            if ((roleDesc = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, this.activity, config)) == null) {
                roleDesc = ProcessUtil.createRoleDescriptor(role);
                this.roleDescList.add(roleDesc);
            } else if (this.synchronize && roleDesc.getIsSynchronizedWithSource().booleanValue()) {
                this.batchCommand.getDescriptorsToRefresh().add(roleDesc);
            }
            if (!this.synchronize && (workProducts = ProcessUtil.getWorkProductsForRole(role, config)) != null && !workProducts.isEmpty() && (selectedWorkProducts = UserInteractionHelper.selectWorkProducts(workProducts, role)) != null) {
                HashSet allSelectedTasks = new HashSet();
                int j = 0;
                while (j < selectedWorkProducts.size()) {
                    List tasks;
                    WorkProductDescriptor wpDesc;
                    WorkProduct wp = (WorkProduct)selectedWorkProducts.get(j);
                    if (TngUtil.isContributor((VariabilityElement)wp)) {
                        wp = (WorkProduct)TngUtil.getBase((VariabilityElement)wp);
                    }
                    if ((wpDesc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)wp, this.activity, config)) == null) {
                        wpDesc = ProcessCommandUtil.createWorkProductDescriptor(wp, config, this.wpDescToDeliverableParts);
                        this.wpDescList.add(wpDesc);
                        WorkProductDescriptor descriptor = UserInteractionHelper.getDeliverable(this.activity, wp);
                        if (descriptor != null) {
                            this.wpdToDeliverableDescriptorMap.put(wpDesc, descriptor);
                        }
                    } else {
                        if (descriptorsToRefresh != null && wpDesc.getIsSynchronizedWithSource().booleanValue()) {
                            descriptorsToRefresh.add(wpDesc);
                        }
                        if (wp instanceof Deliverable && this.synchFeatures.contains(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())) {
                            ProcessCommandUtil.createDeliverableParts(wpDesc, (Deliverable)wp, config, this.wpDescToDeliverableParts, descriptorsToRefresh);
                        }
                    }
                    if ((tasks = ProcessUtil.getTasksForWorkProduct(wp, config)) != null && tasks.size() > 0) {
                        List selectedTasks = UserInteractionHelper.selectTasks(tasks, wp);
                        if (selectedTasks != null && !selectedTasks.isEmpty()) {
                            allSelectedTasks.addAll(selectedTasks);
                        } else {
                            PBSDropCommand.addResponsibleRole(wpDesc, this.activity, this.roleDescList, null, config);
                        }
                    } else {
                        PBSDropCommand.addResponsibleRole(wpDesc, this.activity, this.roleDescList, null, config);
                    }
                    ++j;
                }
                if (allSelectedTasks != null && !allSelectedTasks.isEmpty()) {
                    Iterator itor = allSelectedTasks.iterator();
                    while (itor.hasNext()) {
                        Task task = (Task)itor.next();
                        PBSDropCommand.addToDescriptorLists(task, this.activity, this.taskDescList, this.roleDescList, this.wpDescList, this.wpDescToDeliverableParts, descriptorsToRefresh, this.batchCommand.getObjectToNewFeatureValuesMap(), config, this.synchFeatures);
                    }
                }
            }
            ++i;
        }
        return !this.roleDescList.isEmpty() || !this.taskDescList.isEmpty() || !this.wpDescList.isEmpty() || this.wpDescToDeliverableParts != null && !this.wpDescToDeliverableParts.isEmpty() || !this.wpdToDeliverableDescriptorMap.isEmpty() || descriptorsToRefresh != null && !descriptorsToRefresh.isEmpty() || this.batchCommand.canExecute();
    }

    protected void doExecute() {
        ProcessPackage pkg;
        Map.Entry entry;
        Iterator iter;
        this.removeNewDuplicates();
        this.activity.getBreakdownElements().addAll(this.roleDescList);
        if (this.roleDescTeamProfileMap == null) {
            this.roleDescTeamProfileMap = new HashMap();
            iter = this.roleDescList.iterator();
            while (iter.hasNext()) {
                RoleDescriptor roleDesc = (RoleDescriptor)iter.next();
                TeamProfile teamProfile = UserInteractionHelper.getTeam(this.activity, roleDesc.getRole());
                if (teamProfile == null) continue;
                this.roleDescTeamProfileMap.put(roleDesc, teamProfile);
            }
        }
        iter = this.roleDescTeamProfileMap.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            TeamProfile team = (TeamProfile)entry.getValue();
            team.getTeamRoles().add(entry.getKey());
        }
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            iter = this.wpdToDeliverableDescriptorMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                deliverable.getDeliverableParts().add(entry.getKey());
            }
        }
        this.activity.getBreakdownElements().addAll(this.wpDescList);
        this.activity.getBreakdownElements().addAll(this.taskDescList);
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            iter = this.wpDescToDeliverableParts.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                wpDesc.getDeliverableParts().addAll((Collection)entry.getValue());
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().addAll(this.taskDescList);
            pkg.getProcessElements().addAll(this.roleDescList);
            pkg.getProcessElements().addAll(this.wpDescList);
            Iterator iter2 = this.wpDescToDeliverableParts.values().iterator();
            while (iter2.hasNext()) {
                pkg.getProcessElements().addAll((Collection)iter2.next());
            }
        }
        this.getModifiedResources().add(this.activity.eResource());
    }

    private void removeNewDuplicates() {
        if (this.synchronize && !this.newDuplicatesRemoved) {
            Iterator iter = this.wpDescList.iterator();
            while (iter.hasNext()) {
                WorkProductDescriptor wpd = (WorkProductDescriptor)iter.next();
                Object desc = ProcessCommandUtil.getDescriptor((Object)wpd.getWorkProduct(), this.activity, this.getMethodConfiguration());
                if (desc == null) continue;
                iter.remove();
                if (this.wpDescToDeliverableParts != null) {
                    this.wpDescToDeliverableParts.remove(wpd);
                }
                if (this.wpdToTaskFeaturesMap != null) {
                    this.wpdToTaskFeaturesMap.remove(wpd);
                }
                if (this.wpdToDeliverableDescriptorMap == null) continue;
                this.wpdToDeliverableDescriptorMap.remove(wpd);
            }
            this.newDuplicatesRemoved = true;
        }
    }

    protected void doUndo() {
        ProcessPackage pkg;
        Map.Entry entry;
        this.activity.getBreakdownElements().removeAll(this.roleDescList);
        Iterator iter = this.roleDescTeamProfileMap.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            TeamProfile team = (TeamProfile)entry.getValue();
            team.getTeamRoles().remove(entry.getKey());
        }
        this.activity.getBreakdownElements().removeAll(this.wpDescList);
        this.activity.getBreakdownElements().removeAll(this.taskDescList);
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            iter = this.wpDescToDeliverableParts.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                wpDesc.getDeliverableParts().removeAll((Collection)entry.getValue());
            }
        }
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            iter = this.wpdToDeliverableDescriptorMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                deliverable.getDeliverableParts().remove(entry.getKey());
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().removeAll(this.taskDescList);
            pkg.getProcessElements().removeAll(this.roleDescList);
            pkg.getProcessElements().removeAll(this.wpDescList);
            Iterator iter2 = this.wpDescToDeliverableParts.values().iterator();
            while (iter2.hasNext()) {
                pkg.getProcessElements().removeAll((Collection)iter2.next());
            }
        }
    }

    public Collection getAffectedObjects() {
        if (this.roleDescList != null) {
            return this.roleDescList;
        }
        return super.getAffectedObjects();
    }

    public void dispose() {
        if (this.roleDescList != null) {
            this.roleDescList.clear();
        }
        if (this.roleDescTeamProfileMap != null) {
            this.roleDescTeamProfileMap.clear();
        }
        if (this.wpDescList != null) {
            this.wpDescList.clear();
        }
        if (this.wpDescToDeliverableParts != null) {
            this.wpDescToDeliverableParts.clear();
        }
        if (this.wpdToDeliverableDescriptorMap != null) {
            this.wpdToDeliverableDescriptorMap.clear();
        }
        if (this.wpdToTaskFeaturesMap != null) {
            this.wpdToTaskFeaturesMap.clear();
        }
        super.dispose();
    }
}

