/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.ContentElement;
import com.ibm.uma.CustomCategory;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Section;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.UmaUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.model.ModelFactory;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.library.edit.util.model.OrderInfoCollection;
import org.eclipse.epf.library.edit.util.model.util.StringResource;

public class ContentElementOrderList
extends BasicEList {
    private static final long serialVersionUID = 3257572797487069233L;
    private static final String ORDER_INFO_NAME = "content elements";
    private static final Map DEFAULT_SAVE_OPTIONS = new HashMap();
    public static final int CONTENT_ELEMENTS__FOR_ELEMENT_ONLY = 1;
    public static final int CONTENT_ELEMENTS__FOR_ELEMENT_AND_PARENTS = 2;
    private ContentElement editElement;
    private boolean mixed = true;
    private boolean changed = false;

    static {
        DEFAULT_SAVE_OPTIONS.put("ENCODING", "ASCII");
    }

    private static boolean isContributor(VariabilityElement e) {
        return e.getVariabilityBasedOnElement() != null && e.getVariabilityType() == VariabilityType.CONTRIBUTES_LITERAL;
    }

    public ContentElementOrderList(ContentElement e, int scope) {
        this.editElement = e;
        if (scope == 1) {
            this.mixed = false;
        } else if (scope == 2) {
            this.calculateParentsOnly(e);
        } else {
            this.mixed = false;
        }
    }

    private void calculateParentsOnly(ContentElement e) {
        Iterator iter = null;
        if (ContentElementOrderList.isContributor((VariabilityElement)e) || ContentElementOrderList.isExtended(e)) {
            ArrayList<ContentElement> supers = new ArrayList<ContentElement>();
            UmaUtil.getAllSupersBoth(supers, (VariabilityElement)e, (VariabilityType)VariabilityType.CONTRIBUTES_LITERAL, (VariabilityType)VariabilityType.EXTENDS_LITERAL);
            supers.add(e);
            iter = supers.iterator();
        } else {
            this.mixed = false;
        }
        if (this.mixed) {
            OrderInfo latestInfo = null;
            HashMap<String, ContentElement> guidMap = new HashMap<String, ContentElement>();
            LinkedList<ContentElement> elements = new LinkedList<ContentElement>();
            while (iter.hasNext()) {
                ContentElement element = (ContentElement)iter.next();
                guidMap.put(element.getGuid(), element);
                elements.add(element);
                OrderInfo orderInfo = TngUtil.getOrderInfo((MethodElement)element, ORDER_INFO_NAME);
                if (orderInfo == null || latestInfo != null && orderInfo.getTimestamp() <= latestInfo.getTimestamp()) continue;
                latestInfo = orderInfo;
            }
            if (latestInfo != null) {
                int size = latestInfo.getGUIDs().size();
                int i = 0;
                while (i < size) {
                    Object guid = latestInfo.getGUIDs().get(i);
                    Object element = guidMap.get(guid);
                    if (element != null) {
                        super.add(element);
                        elements.remove(element);
                    }
                    ++i;
                }
            }
            super.addAll(elements);
        }
    }

    public ContentElementOrderList(ContentElement e) {
        this.editElement = e;
        Object iter = null;
        if (ContentElementOrderList.isContributor((VariabilityElement)e) || TngUtil.hasContributor((VariabilityElement)e)) {
            VariabilityElement base = TngUtil.getBase((VariabilityElement)e);
            iter = new AbstractTreeIterator(base){

                protected Iterator getChildren(Object object) {
                    ArrayList<VariabilityElement> children = new ArrayList<VariabilityElement>();
                    Iterator iterator = AssociationHelper.getImmediateVarieties((VariabilityElement)((VariabilityElement)object)).iterator();
                    while (iterator.hasNext()) {
                        VariabilityElement element = (VariabilityElement)iterator.next();
                        if (element.getVariabilityType() != VariabilityType.CONTRIBUTES_LITERAL) continue;
                        children.add(element);
                    }
                    return children.iterator();
                }
            };
        } else if (ContentElementOrderList.isExtended(e)) {
            System.out.println("$$$ for " + e.getName() + " = extended is true");
            ArrayList<ContentElement> supers = new ArrayList<ContentElement>();
            UmaUtil.getAllSupers(supers, (VariabilityElement)e, (VariabilityType)VariabilityType.EXTENDS_LITERAL);
            supers.add(e);
            iter = supers.iterator();
        } else {
            this.mixed = false;
        }
        if (this.mixed) {
            OrderInfo latestInfo = null;
            HashMap<String, ContentElement> guidMap = new HashMap<String, ContentElement>();
            LinkedList<ContentElement> elements = new LinkedList<ContentElement>();
            while (iter.hasNext()) {
                ContentElement element = (ContentElement)iter.next();
                guidMap.put(element.getGuid(), element);
                elements.add(element);
                OrderInfo orderInfo = TngUtil.getOrderInfo((MethodElement)element, ORDER_INFO_NAME);
                if (orderInfo == null || latestInfo != null && orderInfo.getTimestamp() <= latestInfo.getTimestamp()) continue;
                latestInfo = orderInfo;
            }
            if (latestInfo != null) {
                int size = latestInfo.getGUIDs().size();
                int i = 0;
                while (i < size) {
                    Object guid = latestInfo.getGUIDs().get(i);
                    Object element = guidMap.get(guid);
                    if (element != null) {
                        super.add(element);
                        elements.remove(element);
                    }
                    ++i;
                }
            }
            super.addAll(elements);
        }
    }

    private static boolean isExtended(ContentElement e) {
        return e.getVariabilityBasedOnElement() != null && e.getVariabilityType() == VariabilityType.EXTENDS_LITERAL;
    }

    public void apply() {
        if (!this.mixed || !this.changed) {
            return;
        }
        String str = this.editElement.getOrderingGuide();
        OrderInfoCollection orderInfos = null;
        StringResource res = null;
        if (str == null || str.length() == 0) {
            orderInfos = ModelFactory.eINSTANCE.createOrderInfoCollection();
        } else {
            res = new StringResource(str);
            try {
                res.load(null);
                orderInfos = res.getContents().isEmpty() ? ModelFactory.eINSTANCE.createOrderInfoCollection() : (OrderInfoCollection)res.getContents().get(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        OrderInfo sectOrderInfo = null;
        Iterator iter = orderInfos.getOrderInfos().iterator();
        while (iter.hasNext()) {
            OrderInfo orderInfo = (OrderInfo)iter.next();
            if (!ORDER_INFO_NAME.equalsIgnoreCase(orderInfo.getName())) continue;
            sectOrderInfo = orderInfo;
            break;
        }
        if (sectOrderInfo == null) {
            sectOrderInfo = ModelFactory.eINSTANCE.createOrderInfo();
            sectOrderInfo.setName(ORDER_INFO_NAME);
            orderInfos.getOrderInfos().add((Object)sectOrderInfo);
        } else {
            sectOrderInfo.getGUIDs().clear();
        }
        int size = this.size();
        int i = 0;
        while (i < size) {
            Section sect = (Section)this.get(i);
            sectOrderInfo.getGUIDs().add((Object)sect.getGuid());
            ++i;
        }
        sectOrderInfo.setTimestamp(System.currentTimeMillis());
        if (res == null) {
            res = new StringResource(null);
            res.getContents().add((Object)orderInfos);
        }
        try {
            res.save(DEFAULT_SAVE_OPTIONS);
            str = res.getString();
            this.editElement.setOrderingGuide(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public boolean canRemove(ContentElement contentElement) {
        return ((CustomCategory)this.editElement).getCategorizedElements().contains(contentElement);
    }

    public Object remove(int index) {
        if (this.mixed) {
            if (!this.canRemove((ContentElement)this.get(index))) {
                return null;
            }
            Object removed = super.remove(index);
            ((CustomCategory)this.editElement).getCategorizedElements().remove(removed);
            return removed;
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().remove(index);
    }

    public boolean remove(Object o) {
        if (!this.canRemove((ContentElement)o)) {
            return false;
        }
        if (this.mixed) {
            if (super.remove(o)) {
                ((CustomCategory)this.editElement).getCategorizedElements().remove(o);
                return true;
            }
            return false;
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().remove(o);
    }

    public boolean removeAll(Collection c) {
        if (this.mixed) {
            boolean modified = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                Object o = e.next();
                if (!c.contains(o) || !this.canRemove((ContentElement)o)) continue;
                e.remove();
                ((CustomCategory)this.editElement).getCategorizedElements().remove(o);
                modified = true;
            }
            return modified;
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().removeAll(c);
    }

    public void add(int index, Object element) {
        if (this.mixed) {
            super.add(index, element);
            ((CustomCategory)this.editElement).getCategorizedElements().add(element);
            this.changed = true;
        } else {
            ((CustomCategory)this.editElement).getCategorizedElements().add(index, element);
        }
    }

    public boolean add(Object o) {
        boolean b = ((CustomCategory)this.editElement).getCategorizedElements().add(o);
        if (this.mixed && (b = super.add(o))) {
            this.changed = true;
        }
        return b;
    }

    public boolean addAll(Collection c) {
        boolean b = ((CustomCategory)this.editElement).getCategorizedElements().addAll(c);
        if (this.mixed && (b = super.addAll(c))) {
            this.changed = true;
        }
        return b;
    }

    public boolean addAll(int index, Collection c) {
        if (this.mixed) {
            ((CustomCategory)this.editElement).getCategorizedElements().addAll(c);
            boolean b = super.addAll(index, c);
            if (b) {
                this.changed = true;
            }
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().addAll(c);
    }

    public Object set(int index, Object element) {
        if (this.mixed) {
            throw new UnsupportedOperationException();
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().set(index, element);
    }

    public void clear() {
        if (this.mixed) {
            throw new UnsupportedOperationException();
        }
        ((CustomCategory)this.editElement).getCategorizedElements().clear();
    }

    public void move(int index, Object object) {
        if (this.mixed) {
            super.move(index, object);
            this.changed = true;
        } else {
            ((EList)((CustomCategory)this.editElement).getCategorizedElements()).move(index, object);
        }
    }

    public Object move(int targetIndex, int sourceIndex) {
        if (this.mixed) {
            Object moved = super.move(targetIndex, sourceIndex);
            this.changed = true;
            return moved;
        }
        return ((EList)((CustomCategory)this.editElement).getCategorizedElements()).move(targetIndex, sourceIndex);
    }

    public Object get(int index) {
        if (this.mixed) {
            return super.get(index);
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().get(index);
    }

    public Iterator iterator() {
        if (this.mixed) {
            return super.iterator();
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().iterator();
    }

    public boolean contains(Object object) {
        if (this.mixed) {
            return super.contains(object);
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().contains(object);
    }

    public boolean containsAll(Collection collection) {
        if (this.mixed) {
            return super.containsAll(collection);
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().containsAll(collection);
    }

    public Object[] toArray() {
        if (this.mixed) {
            return super.toArray();
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().toArray();
    }

    public Object[] toArray(Object[] array) {
        if (this.mixed) {
            return super.toArray(array);
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().toArray(array);
    }

    public int indexOf(Object object) {
        if (this.mixed) {
            return super.indexOf(object);
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().indexOf(object);
    }

    public int lastIndexOf(Object object) {
        if (this.mixed) {
            return super.lastIndexOf(object);
        }
        return ((CustomCategory)this.editElement).getCategorizedElements().lastIndexOf(object);
    }

    public boolean isMixed() {
        return this.mixed;
    }
}

