/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CompositeRole;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.Deliverable;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessContribution;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkOrder;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import com.ibm.uma.provider.UmaEditPlugin;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.UmaUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.ui.ExposedAdapterFactoryContentProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.jface.viewers.Viewer;

public final class ProcessUtil {
    private static Collection OBSEclasses = null;
    private static Collection WBSEclasses = null;
    private static Collection PBSEclasses = null;
    private static Collection extendAndContributeVariabilityTypes = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static Collection getExtendAndContributeVariabilityTypes() {
        if (extendAndContributeVariabilityTypes == null) {
            extendAndContributeVariabilityTypes = new ArrayList();
            extendAndContributeVariabilityTypes.add(VariabilityType.EXTENDS_LITERAL);
            extendAndContributeVariabilityTypes.add(VariabilityType.CONTRIBUTES_LITERAL);
        }
        return extendAndContributeVariabilityTypes;
    }

    public static String checkBreakdownElementName(AdapterFactory adapterFactory, BreakdownElement e, String name, Suppression suppression) {
        return NameChecker.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), name, suppression);
    }

    public static String checkBreakdownElementName(AdapterFactory adapterFactory, BreakdownElement e, String name, Suppression suppression, boolean ignoreSuppressed) {
        return NameChecker.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), name, suppression, ignoreSuppressed);
    }

    public static String checkBreakdownElementPresentationName(AdapterFactory adapterFactory, BreakdownElement e, String name, Suppression suppression) {
        if ((name == null || name.length() == 0) && ProcessUtil.isExtendingOrContributing(e)) {
            BreakdownElement base = (BreakdownElement)((VariabilityElement)e).getVariabilityBasedOnElement();
            name = ProcessUtil.getPresentationName(base);
        }
        return NameChecker.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), name, suppression);
    }

    public static String checkBreakdownElementPresentationName(AdapterFactory adapterFactory, BreakdownElement e, String name, Suppression suppression, boolean ignoreSuppressed) {
        return NameChecker.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), name, suppression, ignoreSuppressed);
    }

    public static Object getRootProcess(AdapterFactory adapterFactory, ItemProviderAdapter adapter, Object obj) {
        Object parent = adapter.getParent(obj);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        adapter = (ItemProviderAdapter)adapterFactory.adapt(parent, (Object)clazz);
        if (parent == null) {
            return obj;
        }
        return ProcessUtil.getRootProcess(adapterFactory, adapter, parent);
    }

    public static Collection getWBSEclasses() {
        if (WBSEclasses == null) {
            WBSEclasses = new HashSet();
            WBSEclasses.add(UmaPackage.eINSTANCE.getTaskDescriptor());
            WBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            WBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
        }
        return WBSEclasses;
    }

    public static Collection getOBSEclasses() {
        if (OBSEclasses == null) {
            OBSEclasses = new HashSet();
            OBSEclasses.add(UmaPackage.eINSTANCE.getRoleDescriptor());
            OBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            OBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
            OBSEclasses.add(UmaPackage.eINSTANCE.getTeamProfile());
            OBSEclasses.add(UmaPackage.eINSTANCE.getCompositeRole());
        }
        return OBSEclasses;
    }

    public static Collection getPBSEclasses() {
        if (PBSEclasses == null) {
            PBSEclasses = new HashSet();
            PBSEclasses.add(UmaPackage.eINSTANCE.getWorkProductDescriptor());
            PBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            PBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
        }
        return PBSEclasses;
    }

    public static boolean isFirstElement(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        Object parent = itemProvider.getParent(obj);
        if (parent instanceof TeamProfile) {
            return true;
        }
        LinkedList siblings = ProcessUtil.getSiblings(adapterFactory, itemProvider, obj);
        if (siblings != null && !siblings.isEmpty()) {
            return siblings.getFirst() == obj;
        }
        return false;
    }

    public static LinkedList getSiblings(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        ITreeItemContentProvider parentItemProvider;
        Object parent = itemProvider.getParent(obj);
        if (parent == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parentItemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz)) != null) {
            return new LinkedList(parentItemProvider.getChildren(parent));
        }
        return null;
    }

    public static boolean isLastElement(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        Object parent = itemProvider.getParent(obj);
        if (parent instanceof TeamProfile) {
            return true;
        }
        LinkedList siblings = ProcessUtil.getSiblings(adapterFactory, itemProvider, obj);
        if (siblings != null && !siblings.isEmpty()) {
            return siblings.getLast() == obj;
        }
        return false;
    }

    public static List getAffectedElements(Notification notification, IFilter filter) {
        ArrayList<Object> affectedElements = new ArrayList<Object>();
        switch (notification.getEventType()) {
            case 3: {
                Object obj = notification.getNewValue();
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
                break;
            }
            case 5: {
                Iterator iter = ((Collection)notification.getNewValue()).iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (filter != null && !filter.accept(element)) continue;
                    affectedElements.add(element);
                }
                break;
            }
            case 4: {
                Object obj = notification.getOldValue();
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
                break;
            }
            case 6: {
                Iterator iter = ((Collection)notification.getOldValue()).iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (filter != null && !filter.accept(element)) continue;
                    affectedElements.add(element);
                }
                break;
            }
            case 7: {
                Object obj = notification.getNewValue();
                if (obj instanceof Collection) {
                    Iterator iter = ((Collection)obj).iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (filter != null && !filter.accept(element)) continue;
                        affectedElements.add(element);
                    }
                    break;
                }
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
            }
        }
        return affectedElements;
    }

    public static boolean isRefreshRequired(Notification notification, IFilter filter) {
        switch (notification.getEventType()) {
            case 3: {
                Object obj = notification.getNewValue();
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
            case 5: {
                Iterator iter = ((Collection)notification.getNewValue()).iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (filter != null && !filter.accept(element)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                Object obj = notification.getOldValue();
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
            case 6: {
                Iterator iter = ((Collection)notification.getOldValue()).iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (filter != null && !filter.accept(element)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                Object obj = notification.getNewValue();
                if (obj instanceof Collection) {
                    Iterator iter = ((Collection)obj).iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (filter != null && !filter.accept(element)) continue;
                        return true;
                    }
                    break;
                }
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
        }
        return false;
    }

    public static void addToContainer(BreakdownElement e, ItemProviderAdapter itemProvider) {
        ProcessUtil.addToContainer(e, itemProvider, true);
    }

    public static void addToContainer(BreakdownElement e, ItemProviderAdapter itemProvider, boolean move) {
        EObject container;
        ProcessPackage pkg = null;
        Object parent = itemProvider.getParent((Object)e);
        if (parent instanceof EObject && (container = ((EObject)parent).eContainer()) instanceof ProcessPackage) {
            pkg = (ProcessPackage)container;
        }
        if (pkg == null) {
            return;
        }
        if (e instanceof Activity) {
            ProcessPackage oldPkg;
            Activity act = (Activity)e;
            if (act.eContainer() == null) {
                ProcessPackage newPkg = UmaFactory.eINSTANCE.createProcessPackage();
                newPkg.setName(act.getName());
                pkg.getChildPackages().add(newPkg);
                newPkg.getProcessElements().add(e);
            } else if (move && (oldPkg = (ProcessPackage)act.eContainer()).eContainer() != pkg) {
                pkg.getChildPackages().add(oldPkg);
            }
        } else if (e.eContainer() == null) {
            pkg.getProcessElements().add(e);
        } else if (move && e.eContainer() != pkg) {
            pkg.getProcessElements().add(e);
        }
    }

    public static void setParent(Object child, Object parent, AdapterFactory adapterFactory) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = adapterFactory.adapt(child, (Object)clazz)) instanceof IBSItemProvider) {
            ((IBSItemProvider)adapter).setParent(parent);
        } else {
            System.out.println(String.valueOf(LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_setparent")) + child);
            System.out.println(String.valueOf(LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.childadapter")) + adapter);
        }
    }

    public static RoleDescriptor createRoleDescriptor(Role role) {
        RoleDescriptor roleDesc = UmaFactory.eINSTANCE.createRoleDescriptor();
        roleDesc.setRole(role);
        String presentationName = role.getPresentationName();
        roleDesc.setName(role.getName());
        roleDesc.setPresentationName(StrUtil.isBlank((String)presentationName) ? role.getName() : presentationName);
        return roleDesc;
    }

    public static WorkProductDescriptor createWorkProductDescriptor(WorkProduct wp) {
        WorkProductDescriptor wpDesc = UmaFactory.eINSTANCE.createWorkProductDescriptor();
        wpDesc.setWorkProduct(wp);
        wpDesc.setName(wp.getName());
        wpDesc.setPresentationName(StrUtil.isBlank((String)wp.getPresentationName()) ? wp.getName() : wp.getPresentationName());
        return wpDesc;
    }

    public static Viewer getViewer(AdapterFactory adapterFactory, Process proc) {
        if (adapterFactory instanceof ExposedAdapterFactory) {
            Iterator iter = Collections.unmodifiableList(((ExposedAdapterFactory)adapterFactory).getChangeListeners()).iterator();
            while (iter.hasNext()) {
                Viewer viewer;
                Object listener = iter.next();
                if (!(listener instanceof ExposedAdapterFactoryContentProvider) || !((viewer = ((ExposedAdapterFactoryContentProvider)((Object)listener)).getViewer()).getInput() instanceof ProcessComponent) || ((ProcessComponent)viewer.getInput()).getProcess() != proc) continue;
                return viewer;
            }
        }
        return null;
    }

    public static boolean refreshNeeded(AdapterFactory adapterFactory, BSActivityItemProvider itemProvider) {
        BSActivityItemProvider adapter;
        Object element;
        Process process = (Process)itemProvider.getTopItem();
        if (process == null) {
            return false;
        }
        Viewer viewer = ProcessUtil.getViewer(adapterFactory, process);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            return true;
        }
        Iterator iter = TngUtil.getContributors((VariabilityElement)process);
        while (iter.hasNext()) {
            element = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!ProcessUtil.refreshNeeded(adapterFactory, adapter = (BSActivityItemProvider)adapterFactory.adapt(element, (Object)clazz))) continue;
            return true;
        }
        iter = TngUtil.getGeneralizers((VariabilityElement)process, VariabilityType.EXTENDS_LITERAL);
        while (iter.hasNext()) {
            element = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!ProcessUtil.refreshNeeded(adapterFactory, adapter = (BSActivityItemProvider)adapterFactory.adapt(element, (Object)clazz))) continue;
            return true;
        }
        return false;
    }

    public static void refreshPredeccessorLists(AdapterFactory factory, Process proc) {
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(factory, (Object)proc);
        while (iter.hasNext()) {
            IBSItemProvider itemProvider;
            PredecessorList predList;
            Object adapter;
            Object obj = iter.next();
            Object element = TngUtil.unwrap(obj);
            if (!(element instanceof WorkBreakdownElement)) continue;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!((adapter = factory.adapt(obj, (Object)clazz)) instanceof IBSItemProvider) || (predList = (itemProvider = (IBSItemProvider)adapter).getPredecessors()) == null) continue;
            predList.refresh();
        }
    }

    public static void updateIDs(AdapterFactory factory, Process proc) {
        int id = 0;
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(factory, (Object)proc);
        while (iter.hasNext()) {
            IBSItemProvider itemProvider;
            Object adapter;
            Object obj = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!((adapter = factory.adapt(obj, (Object)clazz)) instanceof IBSItemProvider) || (itemProvider = (IBSItemProvider)adapter) == null || !(TngUtil.unwrap(obj) instanceof WorkBreakdownElement)) continue;
            itemProvider.setId(id++);
        }
    }

    public static void refreshViewer(AdapterFactory factory, Process proc) {
        Viewer viewer = ProcessUtil.getViewer(factory, proc);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }

    public static void refreshIDsInViewers(ExposedAdapterFactory adapterFactory) {
        Iterator iter = Collections.unmodifiableList(adapterFactory.getChangeListeners()).iterator();
        while (iter.hasNext()) {
            BSActivityItemProvider itemProvider;
            Viewer viewer;
            Object listener = iter.next();
            if (!(listener instanceof ExposedAdapterFactoryContentProvider) || (viewer = ((ExposedAdapterFactoryContentProvider)((Object)listener)).getViewer()) == null || viewer.getControl() == null || viewer.getControl().isDisposed() || !(viewer.getInput() instanceof ProcessComponent)) continue;
            Process proc = ((ProcessComponent)viewer.getInput()).getProcess();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!(itemProvider = (BSActivityItemProvider)adapterFactory.adapt((Notifier)proc, (Object)clazz)).isRefreshAllIDsRequired()) continue;
            ProcessUtil.updateIDs((AdapterFactory)adapterFactory, proc);
            viewer.refresh();
            itemProvider.setRefreshAllIDsRequired(false);
        }
    }

    public static void refreshAllViewers(ExposedAdapterFactory adapterFactory) {
        Iterator iter = Collections.unmodifiableList(adapterFactory.getChangeListeners()).iterator();
        while (iter.hasNext()) {
            Viewer viewer;
            Object listener = iter.next();
            if (!(listener instanceof ExposedAdapterFactoryContentProvider) || (viewer = ((ExposedAdapterFactoryContentProvider)((Object)listener)).getViewer()) == null || viewer.getControl() == null || viewer.getControl().isDisposed() || !(viewer.getInput() instanceof ProcessComponent)) continue;
            viewer.refresh();
        }
    }

    public static String checkPredecessorList(WorkBreakdownElement e, List predIdList, AdapterFactory adapterFactory, Object process, List predecessors) {
        ArrayList beList = new ArrayList();
        ArrayList allElements = new ArrayList();
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, process);
        while (iter.hasNext()) {
            Object obj = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBSItemProvider itemProvider = (IBSItemProvider)adapterFactory.adapt(obj, (Object)clazz);
            Integer id = new Integer(itemProvider.getId());
            obj = TngUtil.unwrap(obj);
            allElements.add(obj);
            if (!predIdList.contains(id)) continue;
            beList.add(obj);
        }
        int size = beList.size();
        int i = 0;
        while (i < size) {
            Object obj = beList.get(i);
            if (obj instanceof WorkBreakdownElement) {
                WorkBreakdownElement pred = (WorkBreakdownElement)obj;
                if (ProcessUtil.checkCircular(e, pred, allElements)) {
                    return LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_same_breakdown_element");
                }
                if (TngUtil.isSubelementOf(pred, e, adapterFactory)) {
                    return LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_same_sub_element");
                }
                if (TngUtil.isSuperElementOf(pred, e, adapterFactory)) {
                    return LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_child_element");
                }
            } else {
                return LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.err_wrong_element");
            }
            ++i;
        }
        if (predecessors != null) {
            predecessors.addAll(beList);
        }
        return null;
    }

    public static boolean checkCircular(WorkBreakdownElement successor, WorkBreakdownElement predecessor, List list) {
        return false;
    }

    public static void getAllPredecessorList(WorkBreakdownElement predecessor, List list, List predList) {
        if (!predList.contains(predecessor)) {
            predList.add(predecessor);
        }
        Iterator iter = predecessor.getLinkToPredecessor().iterator();
        while (iter.hasNext()) {
            WorkOrder element = (WorkOrder)iter.next();
            WorkBreakdownElement pred = element.getPred();
            if (pred == predecessor || !list.contains(pred) || predList.contains(pred)) continue;
            predList.add(pred);
            ProcessUtil.getAllPredecessorList(pred, list, predList);
        }
    }

    public static String checkPredecessorList(WorkBreakdownElement e, String predList, AdapterFactory adapterFactory, Object topAct, List predecessors) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        StringTokenizer tokens = new StringTokenizer(predList, ",");
        while (tokens.hasMoreTokens()) {
            Integer id;
            String token = tokens.nextToken().trim();
            try {
                id = new Integer(token);
            }
            catch (NumberFormatException numberFormatException) {
                return LibraryEditResources.getString("LibraryEdit.invalidPredecessorError.msg");
            }
            idList.add(id);
        }
        return ProcessUtil.checkPredecessorList(e, idList, adapterFactory, topAct, predecessors);
    }

    public static void addToDefaultConfiguration(Process proc, EObject e, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        if (e instanceof Task) {
            ProcessUtil.addTaskToDefaultConfiguration(proc, (Task)e, addedObjects, true);
        } else if (e instanceof WorkProduct) {
            WorkProduct wp = (WorkProduct)e;
            ProcessUtil.addWPToDefaultConfiguration(proc, wp, addedObjects);
            List tasks = ProcessUtil.getTasksForWorkProduct(wp, config);
            if (tasks != null) {
                Iterator iter = tasks.iterator();
                while (iter.hasNext()) {
                    ProcessUtil.addTaskToDefaultConfiguration(proc, (Task)iter.next(), addedObjects, false);
                }
            }
        } else if (e instanceof Role) {
            Role role = (Role)e;
            ProcessUtil.addRoleToDefaultConfiguration(proc, role, addedObjects);
        } else if (e instanceof Activity) {
            TngUtil.addToConfiguration(config, (EObject)UmaUtil.getProcessComponent((MethodElement)((Activity)e)), addedObjects);
        }
    }

    private static void addTaskToDefaultConfiguration(Process proc, Task task, Set addedObjects, boolean includeWorkProducts) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addToConfiguration(config, (EObject)task, addedObjects);
        ArrayList<Role> dependencies = new ArrayList<Role>();
        dependencies.addAll(task.getAdditionallyPerformedBy());
        dependencies.add(task.getPerformedBy());
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            TngUtil.addToConfiguration(config, (EObject)iter.next(), addedObjects);
        }
        if (includeWorkProducts) {
            dependencies.clear();
            dependencies.addAll(task.getOptionalInput());
            dependencies.addAll(task.getOutput());
            dependencies.addAll(task.getMandatoryInput());
            iter = dependencies.iterator();
            while (iter.hasNext()) {
                ProcessUtil.addWPToDefaultConfiguration(proc, (WorkProduct)iter.next(), addedObjects);
            }
        }
        iter = task.getSteps().iterator();
        while (iter.hasNext()) {
            VariabilityElement step = (VariabilityElement)iter.next();
            VariabilityElement base = step.getVariabilityBasedOnElement();
            if (base == null) continue;
            TngUtil.addToConfiguration(config, (EObject)base, addedObjects);
        }
    }

    private static void addRoleToDefaultConfiguration(Process proc, Role role, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addToConfiguration(config, (EObject)role, addedObjects);
        ArrayList dependencies = new ArrayList();
        dependencies.addAll(role.getModifies());
        dependencies.addAll(role.getResponsibleFor());
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            ProcessUtil.addWPToDefaultConfiguration(proc, (WorkProduct)iter.next(), addedObjects);
        }
    }

    private static void addWPToDefaultConfiguration(Process proc, WorkProduct wp, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addToConfiguration(config, (EObject)wp, addedObjects);
        if (wp instanceof Deliverable) {
            Iterator iter = ((Deliverable)wp).getDeliveredWorkProducts().iterator();
            while (iter.hasNext()) {
                TngUtil.addToConfiguration(config, (EObject)iter.next(), addedObjects);
            }
        }
    }

    public static void updateTaskDescriptorSteps(Activity activity, TaskDescriptor taskDesc) {
        if (taskDesc == null) {
            return;
        }
        Task task = taskDesc.getTask();
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        MethodConfiguration config = TngUtil.getOwningProcess((BreakdownElement)activity).getDefaultContext();
        List steps = (List)configApplicator.getReference((VariabilityElement)task, UmaPackage.eINSTANCE.getTask_Steps(), config);
        Iterator iter = steps.iterator();
        while (iter.hasNext()) {
            Object step = iter.next();
            if (taskDesc.getSelectedSteps().contains(step)) continue;
            taskDesc.getSelectedSteps().add(step);
        }
    }

    public static MethodElement getAssociatedElement(Descriptor descriptor) {
        if (descriptor instanceof RoleDescriptor) {
            return ((RoleDescriptor)descriptor).getRole();
        }
        if (descriptor instanceof TaskDescriptor) {
            return ((TaskDescriptor)descriptor).getTask();
        }
        if (descriptor instanceof WorkProductDescriptor) {
            return ((WorkProductDescriptor)descriptor).getWorkProduct();
        }
        return null;
    }

    public static Collection getAllChildren(ProcessContribution procContrib, Collection ownChildren, AdapterFactory adapterFactory) {
        Process baseProc = procContrib.getBaseProcess();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BSActivityItemProvider adapter = (BSActivityItemProvider)adapterFactory.adapt((Notifier)baseProc, (Object)clazz);
        adapter.setTopItem(baseProc);
        List allChildren = adapter.wrap((Activity)procContrib, adapter.getChildren(baseProc));
        Iterator iter = ownChildren.iterator();
        while (iter.hasNext()) {
            TngUtil.addTo(allChildren, (BreakdownElement)iter.next(), procContrib, adapterFactory);
        }
        return allChildren;
    }

    public static void disposeWrappers(Collection children) {
        if (children == null) {
            return;
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IWrapperItemProvider)) continue;
            ((IWrapperItemProvider)element).dispose();
        }
    }

    public static List getTasksForWorkProduct(WorkProduct wp, MethodConfiguration config) {
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        List tasks = (List)configApplicator.getReference((MethodElement)wp, AssociationHelper.WorkProduct_OutputFrom_Tasks, config);
        return tasks;
    }

    public static List getWorkProductsForRole(Role role, MethodConfiguration config) {
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        List wps = (List)configApplicator.getReference((VariabilityElement)role, UmaPackage.eINSTANCE.getRole_ResponsibleFor(), config);
        return wps;
    }

    public static List getAllWorkProducts(MethodPlugin plugin) {
        ContentPackage coreContentPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        AbstractTreeIterator iter = new AbstractTreeIterator(coreContentPkg, false){
            private static final long serialVersionUID = 3833752066324837937L;

            protected Iterator getChildren(Object object) {
                Object element;
                if (!(object instanceof ContentPackage)) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ContentPackage pkg = (ContentPackage)object;
                ArrayList children = new ArrayList();
                Iterator iterator = pkg.getChildPackages().iterator();
                while (iterator.hasNext()) {
                    element = iterator.next();
                    if (!(element instanceof ContentPackage)) continue;
                    children.add(element);
                }
                iterator = pkg.getContentElements().iterator();
                while (iterator.hasNext()) {
                    element = iterator.next();
                    if (!(element instanceof WorkProduct) || TngUtil.isContributor((VariabilityElement)element)) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
        ArrayList methodElements = new ArrayList();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof WorkProduct)) continue;
            methodElements.add(e);
        }
        return methodElements;
    }

    public static List getAllTasks(MethodPlugin plugin) {
        ContentPackage coreContentPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        AbstractTreeIterator iter = new AbstractTreeIterator(coreContentPkg, false){
            private static final long serialVersionUID = 3833752066324837937L;

            protected Iterator getChildren(Object object) {
                Object element;
                if (!(object instanceof ContentPackage)) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ContentPackage pkg = (ContentPackage)object;
                ArrayList children = new ArrayList();
                Iterator iterator = pkg.getChildPackages().iterator();
                while (iterator.hasNext()) {
                    element = iterator.next();
                    if (!(element instanceof ContentPackage)) continue;
                    children.add(element);
                }
                iterator = pkg.getContentElements().iterator();
                while (iterator.hasNext()) {
                    element = iterator.next();
                    if (!(element instanceof Task) || TngUtil.isContributor((VariabilityElement)element)) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
        ArrayList tasks = new ArrayList();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof Task)) continue;
            tasks.add(e);
        }
        return tasks;
    }

    public static boolean isExtendingOrContributing(BreakdownElement e) {
        return TngUtil.isGeneralizer(e, ProcessUtil.getExtendAndContributeVariabilityTypes());
    }

    public static String getPresentationName(BreakdownElement e) {
        if ((e.getPresentationName() == null || e.getPresentationName().length() == 0) && ProcessUtil.isExtendingOrContributing(e)) {
            BreakdownElement base = (BreakdownElement)((VariabilityElement)e).getVariabilityBasedOnElement();
            return ProcessUtil.getPresentationName(base);
        }
        return e.getPresentationName();
    }

    public static String getLabelWithPath(BreakdownElement e) {
        StringBuffer path = new StringBuffer(e.getName());
        Process proc = TngUtil.getOwningProcess(e);
        if (proc != null) {
            path.append(", ");
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)proc);
            if (plugin != null) {
                path.append(plugin.getName());
            }
            if (e != proc) {
                path.append('/').append(proc.getName());
            }
        }
        return path.toString();
    }

    public static void getModelInfo(BreakdownElement e, Object adapter, StringBuffer modelInfo) {
        if (e instanceof VariabilityElement) {
            VariabilityElement ve = (VariabilityElement)e;
            VariabilityElement base = ve.getVariabilityBasedOnElement();
            if (base != null) {
                VariabilityType type = ve.getVariabilityType();
                if (modelInfo.length() > 0) {
                    modelInfo.append("; ");
                }
                String pattern = null;
                if (type == VariabilityType.CONTRIBUTES_LITERAL) {
                    pattern = LibraryEditResources.getString("LibraryEdit.util.ProcessUtil.contributesto");
                } else if (type == VariabilityType.EXTENDS_LITERAL) {
                    pattern = LibraryEditResources.getString("LibraryEdit.process.extends");
                } else if (type == VariabilityType.REPLACES_LITERAL) {
                    pattern = LibraryEditResources.getString("LibraryEdit.process.replaces");
                }
                if (pattern != null) {
                    String path = ProcessUtil.getLabelWithPath((BreakdownElement)base);
                    modelInfo.append(MessageFormat.format(pattern, path));
                    ProcessUtil.getModelInfo((BreakdownElement)base, adapter, modelInfo);
                }
            }
        } else if (adapter instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)adapter;
            wrapper.getOwner();
            if (wrapper.getFeature() != null) {
                modelInfo.append(TngUtil.getFeatureText(wrapper.getFeature()));
            } else if (wrapper instanceof WorkProductDescriptorWrapperItemProvider) {
                ProcessUtil.getWPDModelInfo(modelInfo, wrapper, wrapper);
            }
        }
    }

    public static String getAttribute(Object object, String property, Object adapter) {
        WorkProductDescriptor wpd;
        BreakdownElement e = (BreakdownElement)TngUtil.unwrap(object);
        if (property == "id") {
            if (e instanceof WorkBreakdownElement && adapter instanceof IBSItemProvider) {
                return String.valueOf(((IBSItemProvider)adapter).getId());
            }
        } else if (property == "name") {
            if (adapter instanceof IItemLabelProvider) {
                return ((IItemLabelProvider)adapter).getText((Object)e);
            }
        } else {
            if (property == "presentation_name") {
                return ProcessUtil.getPresentationName(e);
            }
            if (property == "predecessors") {
                if (adapter instanceof IBSItemProvider) {
                    return ((IBSItemProvider)adapter).getPredecessors().toString();
                }
            } else if (property == "is_event_driven") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsEventDriven());
                }
            } else if (property == "is_ongoing") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsOngoing());
                }
            } else if (property == "is_repeatable") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsRepeatable());
                }
            } else {
                if (property == "prefix") {
                    return e.getPrefix();
                }
                if (property == "model_info") {
                    StringBuffer modelInfo = new StringBuffer();
                    ProcessUtil.getModelInfo(e, adapter, modelInfo);
                    return modelInfo.toString();
                }
                if (property == "type") {
                    WorkProduct wp;
                    String typeName = null;
                    if (e instanceof WorkProductDescriptor && (wp = ((WorkProductDescriptor)e).getWorkProduct()) != null) {
                        typeName = String.valueOf(wp.eClass().getName()) + "Descriptor";
                    }
                    if (typeName == null && e instanceof EObject) {
                        typeName = e.eClass().getName();
                    }
                    if (typeName != null) {
                        return UmaEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
                    }
                } else if (property == "teams") {
                    if (e instanceof TeamProfile) {
                        return TngUtil.getPresentationName(((TeamProfile)e).getSuperTeam());
                    }
                    if (e instanceof RoleDescriptor && adapter instanceof ITreeItemContentProvider) {
                        AdapterFactory adapterFactory = null;
                        if (adapter instanceof BreakdownElementWrapperItemProvider) {
                            adapterFactory = ((BreakdownElementWrapperItemProvider)adapter).getAdapterFactory();
                        } else if (adapter instanceof ItemProviderAdapter) {
                            adapterFactory = ((ItemProviderAdapter)adapter).getAdapterFactory();
                        }
                        return ProcessUtil.getTeamListString(ProcessUtil.getTeamProfiles(object, (ITreeItemContentProvider)adapter, adapterFactory));
                    }
                }
            }
        }
        if (property == "entry_state") {
            if (e instanceof WorkProductDescriptor) {
                wpd = (WorkProductDescriptor)e;
                return TngUtil.checkNull(wpd.getActivityEntryState());
            }
        } else if (property == "exit_state") {
            if (e instanceof WorkProductDescriptor) {
                wpd = (WorkProductDescriptor)e;
                return TngUtil.checkNull(wpd.getActivityExitState());
            }
        } else if (property == "deliverable") {
            if (e instanceof WorkProductDescriptor) {
                List deliverables = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)((WorkProductDescriptor)e));
                if (deliverables.isEmpty()) {
                    return "";
                }
                StringBuffer strBuf = new StringBuffer();
                int max = deliverables.size() - 1;
                int i = 0;
                while (i < max) {
                    strBuf.append(TngUtil.getPresentationName(deliverables.get(i))).append(',');
                    ++i;
                }
                strBuf.append(TngUtil.getPresentationName(deliverables.get(max)));
                return strBuf.toString();
            }
        } else {
            if (property == "is_optional") {
                return String.valueOf(e.getIsOptional());
            }
            if (property == "is_planned") {
                return String.valueOf(e.getIsPlanned());
            }
            if (property == "has_multiple_occurrences") {
                return String.valueOf(e.getHasMultipleOccurrences());
            }
        }
        return "";
    }

    private static String getTeams(RoleDescriptor roleDescriptor) {
        List teamProfiles = AssociationHelper.getTeamProfiles((RoleDescriptor)roleDescriptor);
        return ProcessUtil.getTeamListString(teamProfiles);
    }

    public static Object getParentActivityOfTeam(BreakdownElement brElement) {
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, (Object)clazz);
        Object parent = adapter.getParent((Object)brElement);
        while (!(parent instanceof Activity)) {
            brElement = (BreakdownElement)parent;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, (Object)clazz2);
            parent = adapter.getParent((Object)brElement);
        }
        return parent;
    }

    public static void getRoleDescriptor(AdapterFactory adapterFactory, Activity parent, List roleDescList, List roles) {
        ItemProviderAdapter adapter;
        Collection o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = (adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)parent, (Object)clazz)).getChildren((Object)parent)) instanceof List) {
            List children = (List)o;
            Iterator itor = children.iterator();
            while (itor.hasNext()) {
                RoleDescriptor roleDesc;
                Object obj = itor.next();
                if (obj instanceof Activity) {
                    ProcessUtil.getRoleDescriptor(adapterFactory, (Activity)obj, roleDescList, roles);
                }
                if (!(obj instanceof RoleDescriptor) || (roleDesc = (RoleDescriptor)obj).getRole() == null || !roles.contains(roleDesc.getRole())) continue;
                roleDescList.add(obj);
            }
        }
    }

    private static String getTeamListString(List teamProfiles) {
        if (teamProfiles.isEmpty()) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        int max = teamProfiles.size() - 1;
        int i = 0;
        while (i < max) {
            strBuf.append(TngUtil.getPresentationName(teamProfiles.get(i))).append(',');
            ++i;
        }
        strBuf.append(TngUtil.getPresentationName(teamProfiles.get(max)));
        return strBuf.toString();
    }

    public static void setAttribute(WorkBreakdownElement e, String prop, String txt) {
        if (prop == "name") {
            e.setName(txt);
        } else if (prop == "prefix") {
            e.setPrefix(txt);
        } else if (prop == "is_event_driven") {
            e.setIsEventDriven(Boolean.valueOf(txt));
        } else if (prop == "is_ongoing") {
            e.setIsOngoing(Boolean.valueOf(txt));
        } else if (prop == "is_repeatable") {
            e.setIsRepeatable(Boolean.valueOf(txt));
        }
    }

    public static void setAttribute(IActionManager actionMgr, BreakdownElement e, String prop, String txt) {
        if (prop == "name") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), txt, -1);
        } else if (prop == "prefix") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Prefix(), txt, -1);
        } else if (prop == "is_event_driven") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_ongoing") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_repeatable") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), Boolean.valueOf(txt), -1);
        } else if (prop == "presentation_name") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), txt, -1);
        } else if (prop == "is_optional") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_planned") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), Boolean.valueOf(txt), -1);
        } else if (prop == "has_multiple_occurrences") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), Boolean.valueOf(txt), -1);
        } else if (e instanceof WorkProductDescriptor) {
            if (prop == "entry_state") {
                actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState(), txt, -1);
            } else if (prop == "exit_state") {
                actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState(), txt, -1);
            }
        }
    }

    public static Activity generalize(Activity base, VariabilityType type) {
        Activity act = UmaFactory.eINSTANCE.createActivity();
        act.setName(base.getName());
        if (type == VariabilityType.REPLACES_LITERAL) {
            String presentationName = ProcessUtil.getPresentationName((BreakdownElement)base);
            act.setPresentationName(StrUtil.isBlank((String)presentationName) ? base.getName() : presentationName);
        }
        act.setVariabilityBasedOnElement((VariabilityElement)base);
        act.setVariabilityType(type);
        if (type == VariabilityType.EXTENDS_LITERAL) {
            Iterator iter = base.eClass().getEAllAttributes().iterator();
            while (iter.hasNext()) {
                EAttribute attribute = (EAttribute)iter.next();
                Class clazz = attribute.getEAttributeType().getInstanceClass();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2) continue;
                act.eSet((EStructuralFeature)attribute, base.eGet((EStructuralFeature)attribute));
            }
        }
        ArrayList<MethodElement> workOrders = new ArrayList<MethodElement>();
        Iterator iter = new ArrayList(base.getLinkToPredecessor()).iterator();
        while (iter.hasNext()) {
            workOrders.add(TngUtil.copy((MethodElement)((WorkOrder)iter.next())));
        }
        act.getLinkToPredecessor().addAll(workOrders);
        return act;
    }

    public static List getElementsInScope(AdapterFactory adapterFactory, BreakdownElement element, Class type, List items) {
        Object currentParent;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)element, (Object)clazz);
        if (element instanceof Activity) {
            List children = ((Activity)element).getBreakdownElements();
            Iterator itor = children.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (!type.isInstance(obj) || items.contains(obj)) continue;
                items.add(obj);
            }
        }
        if ((currentParent = itemProvider.getParent((Object)element)) != null) {
            ProcessUtil.getElementsInScope(adapterFactory, (BreakdownElement)currentParent, type, items);
        }
        return items;
    }

    public static List getRoles(List roleDescList) {
        ArrayList<Role> roleList = new ArrayList<Role>();
        if (roleDescList != null) {
            Iterator itor = roleDescList.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (!(obj instanceof RoleDescriptor)) continue;
                Role role = ((RoleDescriptor)obj).getRole();
                roleList.add(role);
            }
        }
        return roleList;
    }

    public static List getAssociatedElementList(List descriptorList) {
        ArrayList<MethodElement> elementList = new ArrayList<MethodElement>();
        if (descriptorList != null) {
            Iterator itor = descriptorList.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (!(obj instanceof Descriptor)) continue;
                MethodElement element = ProcessUtil.getAssociatedElement((Descriptor)obj);
                elementList.add(element);
            }
        }
        return elementList;
    }

    public static BreakdownElement getTopBreakdownElement(ProcessComponent pc) {
        Adapter adapter;
        Process be = pc.getProcess();
        if (be == null) {
            return null;
        }
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!((adapter = composedAdapterFactory.adapt((Notifier)be, (Object)clazz)) instanceof IBSItemProvider)) {
            return be;
        }
        IBSItemProvider itemProvider = (IBSItemProvider)adapter;
        if (itemProvider.getTopItem() == null) {
            itemProvider.setTopItem(be);
            ComposedAdapterFactory composedAdapterFactory2 = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            itemProvider = (IBSItemProvider)composedAdapterFactory2.adapt((Notifier)be, (Object)clazz2);
            itemProvider.setTopItem(be);
            ComposedAdapterFactory composedAdapterFactory3 = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            itemProvider = (IBSItemProvider)composedAdapterFactory3.adapt((Notifier)be, (Object)clazz3);
            itemProvider.setTopItem(be);
            ComposedAdapterFactory composedAdapterFactory4 = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            itemProvider = (IBSItemProvider)composedAdapterFactory4.adapt((Notifier)be, (Object)clazz4);
            itemProvider.setTopItem(be);
        }
        ProcessUtil.updateIDs((EObject)be, (Object)be);
        return be;
    }

    private static void updateIDs(EObject topAct, Object newObj) {
        AdapterFactoryTreeIterator iter;
        Process proc;
        boolean updateWholeProcess;
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ItemProviderAdapter adapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)topAct, (Object)clazz);
        AdapterFactory factory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        boolean bl = updateWholeProcess = topAct == newObj && topAct instanceof Process;
        if (updateWholeProcess) {
            proc = (Process)topAct;
            ProcessUtil.updateIDs(factory, proc);
            ProcessUtil.refreshViewer(factory, proc);
        } else {
            iter = new AdapterFactoryTreeIterator(factory, (Object)topAct);
            ProcessUtil.updateIDs(factory, iter, newObj);
        }
        ComposedAdapterFactory composedAdapterFactory2 = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        adapter = (ItemProviderAdapter)composedAdapterFactory2.adapt((Notifier)topAct, (Object)clazz2);
        factory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        if (updateWholeProcess) {
            proc = (Process)topAct;
            ProcessUtil.updateIDs(factory, proc);
            ProcessUtil.refreshViewer(factory, proc);
        } else {
            iter = new AdapterFactoryTreeIterator(factory, (Object)topAct);
            ProcessUtil.updateIDs(factory, iter, newObj);
        }
    }

    public static void updateIDs(AdapterFactory factory, AdapterFactoryTreeIterator iter, Object newObj) {
        Object obj;
        int id = 0;
        HashMap<Object, IBSItemProvider> changeMap = new HashMap<Object, IBSItemProvider>();
        while (iter.hasNext()) {
            obj = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBSItemProvider itemProvider = (IBSItemProvider)factory.adapt(obj, (Object)clazz);
            itemProvider.setId(id++);
            changeMap.put(obj, itemProvider);
        }
        Iterator iterator = changeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IChangeNotifier adapter = (IChangeNotifier)entry.getValue();
            obj = entry.getKey();
            adapter.fireNotifyChanged((Notification)new ViewerNotification((Notification)new NotificationImpl(1, obj, obj), obj, false, true));
        }
    }

    public static boolean checkDescriptorReferences(Descriptor descriptor, Descriptor obj) {
        Set<Descriptor> descriptors = descriptor != null ? Collections.singleton(descriptor) : Collections.EMPTY_SET;
        return ProcessUtil.checkDescriptorReferences(descriptors, obj);
    }

    public static boolean checkDescriptorReferences(Collection descriptors, Descriptor obj) {
        boolean referencesExists;
        block3: {
            block4: {
                referencesExists = false;
                if (!(obj instanceof RoleDescriptor)) break block4;
                RoleDescriptor refObject = (RoleDescriptor)obj;
                ArrayList list = new ArrayList();
                list.addAll(refObject.getAssistsIn());
                list.addAll(refObject.getResponsibleFor());
                list.addAll(refObject.getPerformsAdditionally());
                list.addAll(refObject.getPerformsAsOwner());
                list.addAll(AssociationHelper.getTeamProfiles((RoleDescriptor)refObject));
                Iterator refItor = list.iterator();
                while (refItor.hasNext()) {
                    Object refItorObject = refItor.next();
                    if ((!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) && !(refItorObject instanceof TeamProfile)) continue;
                    referencesExists = true;
                    break block3;
                }
                break block3;
            }
            if (obj instanceof WorkProductDescriptor) {
                return ProcessUtil.checkWorkProductDescriptorReferences(descriptors, (WorkProductDescriptor)obj, false, -1);
            }
            if (!(obj instanceof TaskDescriptor)) break block3;
            TaskDescriptor refObject = (TaskDescriptor)obj;
            ArrayList<RoleDescriptor> list = new ArrayList<RoleDescriptor>();
            list.addAll(refObject.getAdditionallyPerformedBy());
            list.addAll(refObject.getAssistedBy());
            list.addAll(refObject.getExternalInput());
            list.addAll(refObject.getMandatoryInput());
            list.addAll(refObject.getOptionalInput());
            list.addAll(refObject.getOutput());
            list.add(refObject.getPerformedPrimarilyBy());
            Iterator refItor = list.iterator();
            while (refItor.hasNext()) {
                Object refItorObject = refItor.next();
                if (!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) continue;
                referencesExists = true;
                break;
            }
        }
        return referencesExists;
    }

    public static boolean checkWorkProductDescriptorReferences(Collection descriptors, WorkProductDescriptor refObject, boolean removeRelation, int featureID) {
        ArrayList<WorkProductDescriptor> allObjects = new ArrayList<WorkProductDescriptor>();
        allObjects.add(refObject);
        Activity parentActivity = UmaUtil.getParentActivity((BreakdownElement)refObject);
        if (refObject.getWorkProduct() instanceof Artifact) {
            List containedArtifacts = ((Artifact)refObject.getWorkProduct()).getContainedArtifacts();
            List containedWpDescList = ProcessUtil.getWpDescForArtifacts(containedArtifacts, parentActivity);
            ArrayList<Artifact> containerArtifacts = new ArrayList<Artifact>();
            Artifact artifact = ((Artifact)refObject.getWorkProduct()).getContainerArtifact();
            while (artifact != null) {
                containerArtifacts.add(artifact);
                artifact = artifact.getContainerArtifact();
            }
            List containerWpDescList = ProcessUtil.getWpDescForArtifacts(containerArtifacts, parentActivity);
            allObjects.addAll(containedWpDescList);
            allObjects.addAll(containerWpDescList);
        }
        int i = 0;
        while (i < allObjects.size()) {
            WorkProductDescriptor wpObj = (WorkProductDescriptor)allObjects.get(i);
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(wpObj.getImpactedBy());
            list.addAll(wpObj.getImpacts());
            list.add(wpObj.getResponsibleRole());
            list.addAll(wpObj.getDeliverableParts());
            ArrayList inputList = new ArrayList();
            inputList.addAll(wpObj.getExternalInputTo());
            inputList.addAll(wpObj.getMandatoryInputTo());
            inputList.addAll(wpObj.getOptionalInputTo());
            List outputList = wpObj.getOutputFrom();
            if (removeRelation) {
                switch (featureID) {
                    case 26: 
                    case 27: 
                    case 28: {
                        if (!outputList.containsAll(descriptors)) break;
                        return true;
                    }
                    case 29: {
                        if (!inputList.containsAll(descriptors)) break;
                        return true;
                    }
                }
            }
            list.addAll(inputList);
            list.addAll(outputList);
            Iterator refItor = list.iterator();
            while (refItor.hasNext()) {
                Object refItorObject = refItor.next();
                if (!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List getWpDescForArtifacts(List artifacts, Activity parentActivity) {
        ArrayList<WorkProductDescriptor> wpDescList = new ArrayList<WorkProductDescriptor>();
        int i = 0;
        while (i < artifacts.size()) {
            Artifact artifact = (Artifact)artifacts.get(i);
            List brElements = parentActivity.getBreakdownElements();
            Iterator itor = brElements.iterator();
            while (itor.hasNext()) {
                WorkProductDescriptor wpDesc;
                Object brObj = itor.next();
                if (!(brObj instanceof WorkProductDescriptor) || !((wpDesc = (WorkProductDescriptor)brObj).getWorkProduct() instanceof Artifact) || !wpDesc.getWorkProduct().equals(artifact)) continue;
                wpDescList.add(wpDesc);
            }
            ++i;
        }
        return wpDescList;
    }

    public static CompositeRole createCompositeRole(CompositeRole obj) {
        CompositeRole compRole = UmaFactory.eINSTANCE.createCompositeRole();
        compRole.getAggregatedRoles().addAll(obj.getAggregatedRoles());
        String presentationName = obj.getPresentationName();
        compRole.setName(obj.getName());
        compRole.setPresentationName(StrUtil.isBlank((String)presentationName) ? obj.getName() : presentationName);
        return compRole;
    }

    public static void addTaskToActivity(Task task, Activity act) {
        WBSDropCommand cmd = new WBSDropCommand(act, Collections.singletonList(task));
        BSDropCommand.IExecutor executor = cmd.getExecutor();
        if (executor.preExecute()) {
            executor.doExcecute();
        }
    }

    public static boolean hasProcessNotOfType(ProcessPackage pkg, EClass processType) {
        Process proc;
        if (pkg instanceof ProcessComponent && (proc = ((ProcessComponent)pkg).getProcess()) != null && !processType.isInstance((Object)proc)) {
            return true;
        }
        Iterator iterator = pkg.getChildPackages().iterator();
        while (iterator.hasNext()) {
            Process proc2;
            Object childPkg = iterator.next();
            if (!(childPkg instanceof ProcessComponent ? (proc2 = ((ProcessComponent)childPkg).getProcess()) != null && !processType.isInstance((Object)proc2) : childPkg instanceof ProcessPackage && ProcessUtil.hasProcessNotOfType((ProcessPackage)childPkg, processType))) continue;
            return true;
        }
        return false;
    }

    public static Object findRoleDescriptor(TeamProfile team, RoleDescriptor roleDesc) {
        List teamRoles = team.getTeamRoles();
        Iterator itor = teamRoles.iterator();
        while (itor.hasNext()) {
            Role itorObjRole;
            Role objRole;
            List secondObjectAggRoles;
            List firstObjectAggRoles;
            Object itorObject = itor.next();
            if (!(roleDesc instanceof CompositeRole ? itorObject instanceof CompositeRole && (firstObjectAggRoles = ((CompositeRole)roleDesc).getAggregatedRoles()).equals(secondObjectAggRoles = ((CompositeRole)itorObject).getAggregatedRoles()) : roleDesc instanceof RoleDescriptor && itorObject instanceof RoleDescriptor && !(itorObject instanceof CompositeRole) && (objRole = roleDesc.getRole()).equals(itorObjRole = ((RoleDescriptor)itorObject).getRole()))) continue;
            return itorObject;
        }
        return null;
    }

    public static Map toColumnIndexToNameMap(String colNames) {
        HashMap<Integer, String> columnIndexToNameMap = new HashMap<Integer, String>();
        StringTokenizer tokens = new StringTokenizer(colNames, ",");
        int id = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            columnIndexToNameMap.put(new Integer(id), ProcessUtil.getColumnID(token));
            ++id;
        }
        return columnIndexToNameMap;
    }

    private static String getColumnID(String colName) {
        int i = 0;
        while (i < IBSItemProvider.COLUMNS.length) {
            String col = IBSItemProvider.COLUMNS[i];
            if (col.equals(colName)) {
                return col;
            }
            ++i;
        }
        return null;
    }

    public static void removePredecessors(AdapterFactory factory, Process proc, List removedElements) {
        HashSet elements = new HashSet(removedElements);
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(factory, (Object)proc);
        while (iter.hasNext()) {
            IBSItemProvider itemProvider;
            Object obj = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((itemProvider = (IBSItemProvider)factory.adapt(obj, (Object)clazz)) == null || !(TngUtil.unwrap(obj) instanceof WorkBreakdownElement)) continue;
            Iterator iterator = itemProvider.getPredecessors().iterator();
            while (iterator.hasNext()) {
                Object e = TngUtil.unwrap(iterator.next());
                if (e instanceof ItemProviderAdapter) {
                    e = ((ItemProviderAdapter)e).getTarget();
                }
                if (!elements.contains(e)) continue;
                iterator.remove();
            }
        }
    }

    public static Activity contributeToActivity(BreakdownElementWrapperItemProvider adapter, AdapterFactory adapterFactory) {
        return ProcessUtil.contributeToActivity(adapter, new ArrayList());
    }

    private static void addToActivity(Activity act, BreakdownElement be, Object[] prevAndNext) {
        int id;
        Object next = prevAndNext[1];
        boolean added = false;
        if (next != null && (id = act.getBreakdownElements().indexOf(next)) != -1) {
            act.getBreakdownElements().add(id, be);
            added = true;
        }
        if (!added) {
            Object prev = prevAndNext[0];
            if (prev != null) {
                int id2 = act.getBreakdownElements().indexOf(prev);
                if (id2 != -1) {
                    act.getBreakdownElements().add(id2 + 1, be);
                } else {
                    act.getBreakdownElements().add(be);
                }
            } else {
                act.getBreakdownElements().add(be);
            }
        }
    }

    public static Activity contributeToActivity(BreakdownElementWrapperItemProvider adapter, List createdActivities) {
        Object parent = adapter.getParent(null);
        Object[] prevAndNext = ProcessUtil.getPreviousAndNext(adapter);
        if (parent instanceof BreakdownElementWrapperItemProvider) {
            parent = ProcessUtil.contributeToActivity((BreakdownElementWrapperItemProvider)parent, createdActivities);
        }
        Activity act = ProcessUtil.generialize(adapter, VariabilityType.CONTRIBUTES_LITERAL, prevAndNext);
        Activity parentAct = (Activity)parent;
        ProcessUtil.addToActivity(parentAct, (BreakdownElement)act, prevAndNext);
        createdActivities.add(act);
        return act;
    }

    public static void replaceActivity(BreakdownElementWrapperItemProvider adapter, AdapterFactory adapterFactory) {
        ProcessUtil.replaceActivity(adapter, new ArrayList());
    }

    public static void replaceActivity(BreakdownElementWrapperItemProvider adapter, List createdActivities) {
        Object parent = adapter.getParent(null);
        Object[] prevAndNext = ProcessUtil.getPreviousAndNext(adapter);
        if (parent instanceof BreakdownElementWrapperItemProvider) {
            parent = ProcessUtil.contributeToActivity((BreakdownElementWrapperItemProvider)parent, createdActivities);
        }
        Activity act = ProcessUtil.generialize(adapter, VariabilityType.REPLACES_LITERAL, prevAndNext);
        Activity parentAct = (Activity)parent;
        ProcessUtil.addToActivity(parentAct, (BreakdownElement)act, prevAndNext);
        createdActivities.add(act);
    }

    static Object[] getPreviousAndNext(BreakdownElementWrapperItemProvider adapter) {
        Object parent = adapter.getParent(null);
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
        List children = (List)itemProvider.getChildren(parent);
        int id = children.indexOf(adapter) + 1;
        Object next = null;
        if (id < children.size()) {
            next = children.get(id);
        }
        Object prev = null;
        if ((id -= 2) > -1) {
            prev = children.get(id);
        }
        Object[] prevAndNext = new Object[]{prev, next};
        return prevAndNext;
    }

    static Activity generialize(BreakdownElementWrapperItemProvider adapter, VariabilityType type, Object[] prevAndNext) {
        Class<?> clazz;
        Object prev;
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        Activity act = ProcessUtil.generalize((Activity)adapter.getValue(), type);
        Object next = prevAndNext[1];
        if (next != null) {
            act.setPresentedAfter((BreakdownElement)TngUtil.unwrap(next));
        }
        if ((prev = prevAndNext[0]) != null) {
            act.setPresentedBefore((BreakdownElement)TngUtil.unwrap(prev));
            if (prev instanceof BreakdownElement) {
                ((BreakdownElement)prev).setPresentedAfter((BreakdownElement)act);
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider bsItemProvider = (IBSItemProvider)adapterFactory.adapt((Notifier)act, (Object)clazz);
        bsItemProvider.setExpanded(adapter.isExpanded());
        return act;
    }

    public static Process getImmediateBaseProcess(BreakdownElementWrapperItemProvider itemProvider) {
        Activity inheritor = ProcessUtil.getInheritor(itemProvider);
        if (inheritor != null) {
            return TngUtil.getOwningProcess((BreakdownElement)inheritor.getVariabilityBasedOnElement());
        }
        return null;
    }

    public static Activity getInheritor(BreakdownElementWrapperItemProvider itemProvider) {
        if (itemProvider.isReadOnly()) {
            Object parent = itemProvider.getParent(itemProvider);
            while (parent != null) {
                if (parent instanceof BreakdownElementWrapperItemProvider) {
                    parent = ((BreakdownElementWrapperItemProvider)parent).getParent(parent);
                    continue;
                }
                return (Activity)parent;
            }
        }
        return null;
    }

    public static List getParentList(Object from, BreakdownElementWrapperItemProvider wrapper) {
        ArrayList<MethodElement> parentList = new ArrayList<MethodElement>();
        AdapterFactory adapterFactory = wrapper.getAdapterFactory();
        Object parent = wrapper.getParent(wrapper);
        while (parent != from && parent != null) {
            ItemProviderAdapter adapter;
            MethodElement e;
            Object obj = TngUtil.unwrap(parent);
            if (obj instanceof MethodElement) {
                e = (MethodElement)obj;
                if (parent instanceof ITreeItemContentProvider) {
                    adapter = (ITreeItemContentProvider)parent;
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
                }
                parent = adapter.getParent(parent);
            } else {
                adapter = (ItemProviderAdapter)obj;
                e = (MethodElement)adapter.getTarget();
                parent = adapter.getParent(parent);
            }
            parentList.add(0, e);
        }
        return parentList;
    }

    /*
     * Unable to fully structure code
     */
    public static List getWrappers(BreakdownElementWrapperItemProvider wrapper, AdapterFactory[] adapterFactories) {
        block20: {
            block19: {
                rolledUpItemProviders = new ArrayList<IBSItemProvider>();
                try {
                    rootAdapterFactory = TngUtil.getBestAdapterFactory(wrapper.getAdapterFactory());
                    proc = wrapper.getTopItem();
                    objects = new ArrayList<Object>(ProcessUtil.getParentList(proc, wrapper));
                    wrappers = new ArrayList<Object>();
                    i = 0;
                    while (i < adapterFactories.length) {
                        adapterFactory = adapterFactories[i];
                        if (adapterFactory == rootAdapterFactory) {
                            wrappers.add(wrapper);
                        } else {
                            e = TngUtil.unwrap(wrapper);
                            objects.add(e);
                            object = proc;
                            iter1 = objects.iterator();
                            block5: while (iter1.hasNext()) {
                                element = iter1.next();
                                v0 = ProcessUtil.class$0;
                                if (v0 == null) {
                                    try {
                                        v0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                                    }
                                    catch (ClassNotFoundException v1) {
                                        throw new NoClassDefFoundError(v1.getMessage());
                                    }
                                }
                                adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)v0);
                                be = TngUtil.unwrap(object);
                                if (be instanceof Activity) {
                                    if (adapter instanceof BSActivityItemProvider) {
                                        itemProvider = (BSActivityItemProvider)adapter;
                                        if (itemProvider.isRolledUp()) {
                                            itemProvider.basicSetRolledUp(false);
                                            rolledUpItemProviders.add(itemProvider);
                                        }
                                    } else if (adapter instanceof IBSItemProvider && (itemProvider = (IBSItemProvider)adapter).isRolledUp()) {
                                        itemProvider.setRolledUp(false);
                                        rolledUpItemProviders.add(itemProvider);
                                    }
                                }
                                iterator = adapter.getChildren(object).iterator();
                                while (iterator.hasNext()) {
                                    child = iterator.next();
                                    if (element != TngUtil.unwrap(child)) continue;
                                    object = child;
                                    continue block5;
                                }
                            }
                            if (object instanceof BreakdownElementWrapperItemProvider) {
                                wrappers.add(object);
                            } else {
                                throw new RuntimeException("Could not find wrapper for " + e + " using adapter factory " + adapterFactory);
                            }
                        }
                        ++i;
                    }
                    var19_17 = wrappers;
                    var17_18 = null;
                    if (rolledUpItemProviders.isEmpty()) break block19;
                    iter = rolledUpItemProviders.iterator();
                    ** while (iter.hasNext())
                }
                catch (Throwable var18_22) {
                    var17_19 = null;
                    if (rolledUpItemProviders.isEmpty()) break block20;
                    iter = rolledUpItemProviders.iterator();
                    ** while (iter.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    ((BSActivityItemProvider)iter.next()).basicSetRolledUp(true);
                    continue;
                }
            }
            return var19_17;
lbl-1000:
            // 1 sources

            {
                ((BSActivityItemProvider)iter.next()).basicSetRolledUp(true);
                continue;
            }
        }
        throw var18_22;
    }

    public static void getWPDModelInfo(StringBuffer modelInfo, Object object, Object itemProvider) {
        Object element = TngUtil.unwrap(object);
        if (element instanceof WorkProductDescriptor) {
            WorkProductDescriptor wpd = (WorkProductDescriptor)element;
            if (itemProvider instanceof ITreeItemContentProvider) {
                AdapterFactory adapterFactory = null;
                if (itemProvider instanceof ItemProviderAdapter) {
                    adapterFactory = ((ItemProviderAdapter)itemProvider).getAdapterFactory();
                } else if (itemProvider instanceof BreakdownElementWrapperItemProvider) {
                    adapterFactory = ((BreakdownElementWrapperItemProvider)itemProvider).getAdapterFactory();
                }
                if (adapterFactory != null) {
                    Object parentDescriptor = null;
                    ITreeItemContentProvider adapter = (ITreeItemContentProvider)itemProvider;
                    Object parent = adapter.getParent(object);
                    while (parent != null) {
                        Object e = TngUtil.unwrap(parent);
                        if (e instanceof TaskDescriptor) {
                            parentDescriptor = e;
                            break;
                        }
                        if (e instanceof Activity) break;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
                        parent = adapter.getParent(parent);
                    }
                    if (parentDescriptor != null) {
                        ArrayList<EReference> features = new ArrayList<EReference>();
                        if (wpd.getMandatoryInputTo().contains(parentDescriptor)) {
                            features.add(UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput());
                        }
                        if (wpd.getOptionalInputTo().contains(parentDescriptor)) {
                            features.add(UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput());
                        }
                        if (wpd.getOutputFrom().contains(parentDescriptor)) {
                            features.add(UmaPackage.eINSTANCE.getTaskDescriptor_Output());
                        }
                        if (!features.isEmpty()) {
                            if (modelInfo.toString().length() > 0) {
                                modelInfo.append(",");
                            }
                            int i = 0;
                            while (i < features.size()) {
                                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                                modelInfo.append(TngUtil.getFeatureText(feature));
                                ++i;
                            }
                        }
                        return;
                    }
                }
            }
            ProcessUtil.getModelInfoForWorkProductDescriptor(modelInfo, wpd);
        }
    }

    private static void getModelInfoForWorkProductDescriptor(StringBuffer modelInfo, WorkProductDescriptor object) {
        String comma = ",";
        if (!object.getMandatoryInputTo().isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_mandatoryInput_feature"));
        }
        if (!object.getOptionalInputTo().isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_optionalInput_feature"));
        }
        if (!object.getOutputFrom().isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_output_feature"));
        }
    }

    public static Collection getDuplicateDescriptorsAfterReveal(Collection elementsToReveal) {
        ArrayList<Object> duplicates = new ArrayList<Object>();
        Iterator iter = elementsToReveal.iterator();
        while (iter.hasNext()) {
            Descriptor desc;
            MethodElement e;
            Object element = iter.next();
            if (!(element instanceof Descriptor) || (e = ProcessUtil.getAssociatedElement(desc = (Descriptor)element)) == null) continue;
            Activity act = UmaUtil.getParentActivity((BreakdownElement)desc);
            MethodConfiguration config = TngUtil.getOwningProcess((BreakdownElement)act).getDefaultContext();
            e = (MethodElement)Providers.getConfigurationApplicator().resolve(e, config);
            Object duplicate = ProcessCommandUtil.getDescriptor((Object)e, act, config);
            if (duplicate == null) continue;
            duplicates.add(duplicate);
        }
        return duplicates;
    }

    public static Collection getDuplicateDescriptorsAfterSuppress(Collection elementsToSuppress) {
        ArrayList<BreakdownElement> duplicates = new ArrayList<BreakdownElement>();
        Iterator iter = elementsToSuppress.iterator();
        while (iter.hasNext()) {
            Descriptor desc;
            MethodElement e;
            Object item = iter.next();
            if (!(item instanceof Descriptor) || (e = ProcessUtil.getAssociatedElement(desc = (Descriptor)item)) == null) continue;
            Activity act = UmaUtil.getParentActivity((BreakdownElement)desc);
            Iterator iterator = act.getBreakdownElements().iterator();
            while (iterator.hasNext()) {
                MethodElement linkedElement;
                BreakdownElement element = (BreakdownElement)iterator.next();
                if (element == e || !(element instanceof Descriptor) || !element.getSuppressed().booleanValue() || (linkedElement = ProcessUtil.getAssociatedElement((Descriptor)element)) != e) continue;
                duplicates.add(element);
            }
        }
        return duplicates;
    }

    public static boolean isInherited(Object object) {
        return object instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object).isInherited();
    }

    private static List getTeamProfiles(Object object, ITreeItemContentProvider adapter, AdapterFactory adapterFactory) {
        RoleDescriptor roleDesc = (RoleDescriptor)TngUtil.unwrap(object);
        ArrayList teams = new ArrayList(AssociationHelper.getTeamProfiles((RoleDescriptor)roleDesc));
        HashSet<Object> visibleTeams = new HashSet<Object>();
        Object parent = adapter.getParent(object);
        while (parent != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
            Iterator iter = adapter.getChildren(parent).iterator();
            while (iter.hasNext()) {
                Object e = TngUtil.unwrap(iter.next());
                if (!(e instanceof TeamProfile) || !((TeamProfile)e).getTeamRoles().contains(roleDesc)) continue;
                visibleTeams.add(e);
            }
            Object newParent = adapter.getParent(parent);
            if (newParent == null && parent instanceof Activity) {
                newParent = UmaUtil.getParentActivity((BreakdownElement)((Activity)parent));
            }
            parent = newParent;
        }
        Iterator iter = teams.iterator();
        while (iter.hasNext()) {
            Object team = iter.next();
            if (visibleTeams.contains(team)) continue;
            iter.remove();
        }
        return teams;
    }

    public static List getTeamProfiles(RoleDescriptorWrapperItemProvider roleDescWrapper) {
        return ProcessUtil.getTeamProfiles(roleDescWrapper, (ITreeItemContentProvider)roleDescWrapper, roleDescWrapper.getAdapterFactory());
    }

    public static List getTeamProfiles(RoleDescriptor roleDesc, AdapterFactory adapterFactory) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)roleDesc, (Object)clazz);
        return ProcessUtil.getTeamProfiles(roleDesc, adapter, adapterFactory);
    }

    public static void getChildElements(Activity act, Class type, Collection collection) {
        int i = act.getBreakdownElements().size() - 1;
        while (i > -1) {
            Object element = act.getBreakdownElements().get(i);
            if (type.isInstance(element)) {
                collection.add(element);
            } else if (element instanceof Activity) {
                ProcessUtil.getChildElements((Activity)element, type, collection);
            }
            --i;
        }
    }

    public static IFilter getFilter(AdapterFactory adapterFactory) {
        AdapterFactory rootAdapterFactory = TngUtil.getBestAdapterFactory(adapterFactory);
        if (rootAdapterFactory instanceof ConfigurableComposedAdapterFactory) {
            return ((ConfigurableComposedAdapterFactory)rootAdapterFactory).getFilter();
        }
        return null;
    }

    public static List getContainedArtifacts(Artifact artifact, AdapterFactory adapterFactory) {
        MethodConfiguration config = null;
        IFilter filter = ProcessUtil.getFilter(adapterFactory);
        if (filter instanceof IConfigurator) {
            config = ((IConfigurator)filter).getMethodConfiguration();
        }
        if (config == null) {
            return artifact.getContainedArtifacts();
        }
        return (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)artifact, UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), config);
    }

    public static List getContainedArtifactsDescriptors(WorkProductDescriptor artifactDesc, List artifactDescriptors) {
        if (artifactDescriptors.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Artifact artifact = (Artifact)artifactDesc.getWorkProduct();
        ArrayList<WorkProductDescriptor> containedDescriptors = new ArrayList<WorkProductDescriptor>();
        int i = artifactDescriptors.size() - 1;
        while (i > -1) {
            EObject container;
            WorkProductDescriptor wpd = (WorkProductDescriptor)artifactDescriptors.get(i);
            WorkProduct a = wpd.getWorkProduct();
            if (a != null && ((container = a.eContainer()) == artifact || container instanceof Artifact && TngUtil.isContributorOf(artifact, (VariabilityElement)((Artifact)container)))) {
                containedDescriptors.add(wpd);
            }
            --i;
        }
        return containedDescriptors;
    }

    public static boolean isContainedBy(WorkProductDescriptor parent, WorkProductDescriptor child, List artifactDescList) {
        return UmaUtil.isContainedBy((EObject)child.getWorkProduct(), (Object)parent.getWorkProduct());
    }

    public static List removeSubartifactsFromChildren(Collection children, boolean unwrap) {
        ArrayList<WorkProduct> artifactList = new ArrayList<WorkProduct>();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            WorkProduct wp;
            Object child = iter.next();
            if (unwrap) {
                child = TngUtil.unwrap(child);
            }
            if (!(child instanceof WorkProductDescriptor) || !((wp = ((WorkProductDescriptor)child).getWorkProduct()) instanceof Artifact)) continue;
            artifactList.add(wp);
        }
        HashSet<Artifact> topMostArtifacts = new HashSet<Artifact>();
        Artifact candidate = null;
        boolean found = false;
        while (!artifactList.isEmpty()) {
            if (!found) {
                candidate = (Artifact)artifactList.get(0);
                artifactList.remove(0);
            }
            Iterator iter2 = artifactList.iterator();
            while (iter2.hasNext()) {
                Artifact artifact = (Artifact)iter2.next();
                found = false;
                if (UmaUtil.isContainedBy((EObject)artifact, (Object)candidate)) {
                    iter2.remove();
                    continue;
                }
                if (!UmaUtil.isContainedBy((EObject)candidate, (Object)artifact)) continue;
                iter2.remove();
                candidate = artifact;
                found = true;
                break;
            }
            if (!found || artifactList.isEmpty()) {
                topMostArtifacts.add(candidate);
                continue;
            }
            if (!artifactList.isEmpty()) continue;
            topMostArtifacts.add(candidate);
        }
        ArrayList result = new ArrayList();
        Iterator ci = children.iterator();
        while (ci.hasNext()) {
            Object child = ci.next();
            Object e = unwrap ? TngUtil.unwrap(child) : child;
            boolean selected = false;
            if (e instanceof WorkProductDescriptor) {
                WorkProductDescriptor wpd = (WorkProductDescriptor)e;
                WorkProduct wp = wpd.getWorkProduct();
                if (!(wp instanceof Artifact)) {
                    selected = true;
                } else if (topMostArtifacts.contains(wp)) {
                    selected = true;
                }
            } else {
                selected = true;
            }
            if (!selected) continue;
            result.add(child);
        }
        return result;
    }

    public static List removeSubartifactsFromChildren(Collection children, boolean unwrap, AdapterFactory adapterFactory) {
        ArrayList artifactDescList = new ArrayList();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            WorkProduct wp;
            Object child = iter.next();
            if (unwrap) {
                child = TngUtil.unwrap(child);
            }
            if (!(child instanceof WorkProductDescriptor) || !((wp = ((WorkProductDescriptor)child).getWorkProduct()) instanceof Artifact)) continue;
            artifactDescList.add(child);
        }
        if (artifactDescList.isEmpty()) {
            if (children instanceof List) {
                return (List)children;
            }
            return new ArrayList(children);
        }
        HashSet<WorkProductDescriptor> topMostArtifactDescList = new HashSet<WorkProductDescriptor>();
        ArrayList artifactDescriptors = new ArrayList(artifactDescList);
        WorkProductDescriptor candidate = null;
        boolean found = false;
        while (!artifactDescList.isEmpty()) {
            if (!found) {
                candidate = (WorkProductDescriptor)artifactDescList.get(0);
                artifactDescList.remove(0);
            }
            Iterator iter2 = artifactDescList.iterator();
            while (iter2.hasNext()) {
                WorkProductDescriptor artifactDesc = (WorkProductDescriptor)iter2.next();
                found = false;
                if (ProcessUtil.isContainedBy(candidate, artifactDesc, artifactDescriptors)) {
                    iter2.remove();
                    continue;
                }
                if (!ProcessUtil.isContainedBy(artifactDesc, candidate, artifactDescriptors)) continue;
                iter2.remove();
                candidate = artifactDesc;
                found = true;
                break;
            }
            if (!found || artifactDescList.isEmpty()) {
                topMostArtifactDescList.add(candidate);
                continue;
            }
            if (!artifactDescList.isEmpty()) continue;
            topMostArtifactDescList.add(candidate);
        }
        ArrayList result = new ArrayList();
        Iterator ci = children.iterator();
        while (ci.hasNext()) {
            Object child = ci.next();
            Object e = unwrap ? TngUtil.unwrap(child) : child;
            boolean selected = false;
            if (e instanceof WorkProductDescriptor) {
                WorkProductDescriptor wpd = (WorkProductDescriptor)e;
                WorkProduct wp = wpd.getWorkProduct();
                if (!(wp instanceof Artifact)) {
                    selected = true;
                } else if (topMostArtifactDescList.contains(wpd)) {
                    selected = true;
                }
            } else {
                selected = true;
            }
            if (!selected) continue;
            result.add(child);
        }
        return result;
    }
}

