/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class DefaultEncodingSupport
implements IEncodingSupport {
    private Preferences.IPropertyChangeListener fPropertyChangeListener;
    private StatusTextEditor fTextEditor;

    public void initialize(StatusTextEditor textEditor) {
        this.fTextEditor = textEditor;
        this.fPropertyChangeListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent e) {
                if ("encoding".equals(e.getProperty())) {
                    DefaultEncodingSupport.this.setEncoding(null, false);
                }
            }
        };
        Preferences p = ResourcesPlugin.getPlugin().getPluginPreferences();
        p.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void dispose() {
        Preferences p = ResourcesPlugin.getPlugin().getPluginPreferences();
        p.removePropertyChangeListener(this.fPropertyChangeListener);
        this.fTextEditor = null;
    }

    public void reset() {
    }

    protected void setEncoding(String encoding, boolean overwrite) {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IEditorInput input = this.fTextEditor.getEditorInput();
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            String current = provider.getEncoding(input);
            if (!this.fTextEditor.isDirty()) {
                boolean apply;
                String internal = encoding == null ? "" : encoding;
                boolean bl = apply = (overwrite || current == null) && !internal.equals(current);
                if (apply) {
                    provider.setEncoding(input, encoding);
                    Runnable encodingSetter = new Runnable(){

                        public void run() {
                            DefaultEncodingSupport.this.fTextEditor.doRevertToSaved();
                        }
                    };
                    Display display = this.fTextEditor.getSite().getShell().getDisplay();
                    if (display != null && !display.isDisposed()) {
                        BusyIndicator.showWhile((Display)display, (Runnable)encodingSetter);
                    } else {
                        encodingSetter.run();
                    }
                }
            }
        }
    }

    public void setEncoding(String encoding) {
        this.setEncoding(encoding, true);
    }

    public String getEncoding() {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            return provider.getEncoding(this.fTextEditor.getEditorInput());
        }
        return null;
    }

    public String getDefaultEncoding() {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            return provider.getDefaultEncoding();
        }
        return null;
    }

    public String getStatusHeader(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException) {
            return TextEditorMessages.Editor_error_unreadable_encoding_header;
        }
        if (t instanceof UnsupportedEncodingException) {
            return TextEditorMessages.Editor_error_unsupported_encoding_header;
        }
        return null;
    }

    public String getStatusBanner(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException) {
            return TextEditorMessages.Editor_error_unreadable_encoding_banner;
        }
        if (t instanceof UnsupportedEncodingException) {
            return TextEditorMessages.Editor_error_unsupported_encoding_banner;
        }
        return null;
    }

    public String getStatusMessage(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException || t instanceof UnsupportedEncodingException) {
            String encoding = this.getEncoding();
            if (encoding == null) {
                encoding = this.getDefaultEncoding();
            }
            if (t instanceof CharConversionException) {
                if (encoding != null) {
                    return MessageFormat.format(TextEditorMessages.Editor_error_unreadable_encoding_message_arg, encoding);
                }
                return TextEditorMessages.Editor_error_unreadable_encoding_message;
            }
            if (t instanceof UnsupportedEncodingException) {
                if (encoding != null) {
                    return NLSUtility.format(TextEditorMessages.Editor_error_unsupported_encoding_message_arg, encoding);
                }
                return TextEditorMessages.Editor_error_unsupported_encoding_message;
            }
        }
        return null;
    }

    public boolean isEncodingError(IStatus status) {
        if (status == null || status.getSeverity() != 4) {
            return false;
        }
        Throwable t = status.getException();
        return t instanceof CharConversionException || t instanceof UnsupportedEncodingException;
    }

    public void createStatusEncodingChangeControl(Composite parent, IStatus status) {
        final IAction action = this.fTextEditor.getAction("ChangeEncoding");
        if (action instanceof TextEditorAction) {
            ((TextEditorAction)action).update();
        }
        if (action == null || !action.isEnabled()) {
            return;
        }
        Shell shell = parent.getShell();
        Display display = shell.getDisplay();
        Color bgColor = display.getSystemColor(25);
        Button button = new Button(parent, 0x800008);
        button.setText(action.getText());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(1808));
        filler.setBackground(bgColor);
    }
}

