/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.filebuffers.manipulation.RemoveTrailingWhitespaceOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.editors.text.FileBufferOperationHandler;
import org.eclipse.ui.internal.editors.text.SelectResourcesDialog;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class RemoveTrailingWhitespaceHandler
extends FileBufferOperationHandler {
    public RemoveTrailingWhitespaceHandler() {
        super((IFileBufferOperation)new RemoveTrailingWhitespaceOperation());
    }

    protected boolean isAcceptableLocation(IPath location) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        return manager.isTextFileLocation(location);
    }

    protected IFile[] collectFiles(IResource[] resources) {
        IFile[] files = super.collectFiles(resources);
        if (files != null && resources != null && files.length == resources.length) {
            return files;
        }
        SelectResourcesDialog dialog = new SelectResourcesDialog(this.getShell(), TextEditorMessages.RemoveTrailingWhitespaceHandler_dialog_title, TextEditorMessages.RemoveTrailingWhitespaceHandler_dialog_description);
        dialog.setInput(resources);
        int result = dialog.open();
        if (result == 0) {
            IResource[] selectedResources = dialog.getSelectedResources();
            return super.collectFiles(selectedResources);
        }
        return null;
    }
}

