/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.cheatsheets.CheatSheetHistory;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CheatSheetPlugin
extends AbstractUIPlugin {
    static CheatSheetPlugin plugin;
    private CheatSheetHistory history = null;
    private DocumentBuilder documentBuilder = null;
    private static final String DEFAULT_CHEATSHEET_STATE_FILENAME = "cheatsheet.xml";
    private static final String MEMENTO_TAG_CHEATSHEET = "cheatsheet";
    private static final String MEMENTO_TAG_VERSION = "version";
    private static final String[] VERSION_STRING;
    private static final String MEMENTO_TAG_CHEATSHEET_HISTORY = "cheatsheetHistory";
    public static final IPath ICONS_PATH;
    public static final String T_OBJ = "obj16/";
    public static final String T_ELCL = "elcl16/";

    static {
        VERSION_STRING = new String[]{"0.0", "3.0.0"};
        ICONS_PATH = new Path("$nl$/icons/");
    }

    public static CheatSheetPlugin getPlugin() {
        return plugin;
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        return image;
    }

    public CheatSheetHistory getCheatSheetHistory() {
        if (this.history == null) {
            this.history = new CheatSheetHistory(CheatSheetRegistryReader.getInstance());
            this.restoreCheatSheetHistory();
        }
        return this.history;
    }

    private File getCheatSheetStateFile() {
        IPath path = CheatSheetPlugin.getPlugin().getStateLocation();
        path = path.append(DEFAULT_CHEATSHEET_STATE_FILENAME);
        return path.toFile();
    }

    public DocumentBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            try {
                this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_CREATING_DOCUMENT_BUILDER, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return this.documentBuilder;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        IPath path = ICONS_PATH.append(T_OBJ).append("cheatsheet_obj.gif");
        ImageDescriptor imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_OBJ", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("skip_status.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_SKIP", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("complete_status.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_COMPLETE", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("linkto_help.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_HELP", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("start_cheatsheet.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_START", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("restart_cheatsheet.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_RESTART", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("start_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_START", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("skip_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_SKIP", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("complete_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_COMPLETE", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("restart_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_RESTART", imageDescriptor);
    }

    private void restoreCheatSheetHistory() {
        Platform.run((ISafeRunnable)new SafeRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                InputStreamReader reader = null;
                try {
                    try {
                        File stateFile = CheatSheetPlugin.this.getCheatSheetStateFile();
                        FileInputStream input = new FileInputStream(stateFile);
                        reader = new InputStreamReader((InputStream)input, "utf-8");
                        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                        IMemento childMem = memento.getChild(CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET_HISTORY);
                        if (childMem != null) {
                            CheatSheetPlugin.this.history.restoreState(childMem);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (Exception e) {
                        String message = Messages.ERROR_READING_STATE_FILE;
                        Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    try {
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        String message = Messages.ERROR_READING_STATE_FILE;
                        Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    }
                    throw throwable;
                }
                {
                    Object var6_11 = null;
                }
                try {}
                catch (IOException e) {
                    String message = Messages.ERROR_READING_STATE_FILE;
                    Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    return;
                }
                if (reader == null) return;
                reader.close();
            }

            public void handleException(Throwable e) {
                String message = Messages.ERROR_READING_STATE_FILE;
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        });
    }

    private void saveCheatSheetHistory() {
        Platform.run((ISafeRunnable)new SafeRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                XMLMemento memento = XMLMemento.createWriteRoot((String)CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET);
                memento.putString(CheatSheetPlugin.MEMENTO_TAG_VERSION, VERSION_STRING[1]);
                CheatSheetPlugin.this.getCheatSheetHistory().saveState(memento.createChild(CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET_HISTORY));
                File stateFile = CheatSheetPlugin.this.getCheatSheetStateFile();
                OutputStreamWriter writer = null;
                try {
                    try {
                        FileOutputStream stream = new FileOutputStream(stateFile);
                        writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
                        memento.save((Writer)writer);
                    }
                    catch (IOException e) {
                        stateFile.delete();
                        String message = Messages.ERROR_WRITING_STATE_FILE;
                        Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (writer == null) throw throwable;
                        writer.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        String message = Messages.ERROR_WRITING_STATE_FILE;
                        Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    }
                    throw throwable;
                }
                {
                    Object var7_10 = null;
                }
                try {}
                catch (IOException e) {
                    String message = Messages.ERROR_WRITING_STATE_FILE;
                    Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    return;
                }
                if (writer == null) return;
                writer.close();
            }

            public void handleException(Throwable e) {
                String message = Messages.ERROR_WRITING_STATE_FILE;
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        });
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.history != null) {
            this.saveCheatSheetHistory();
        }
        CheatSheetRegistryReader.getInstance().stop();
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path) {
        URL url = Platform.find((Bundle)bundle, (IPath)path);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }
}

