/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.richtext.dialogs.AddLinkDialog;
import org.eclipse.swt.widgets.Display;

public class AddLinkAction
extends RichTextAction {
    public AddLinkAction() {
        this.setImage(RichTextImages.IMG_ADD_LINK);
        this.setDisabledImage(RichTextImages.DISABLED_IMG_ADD_LINK);
        this.setToolTipText(RichTextResources.getString("RichText.addLinkAction.toolTipText"));
        this.setEnabled(true);
    }

    public void execute(IRichText richText) {
        if (richText != null) {
            String linkURL;
            AddLinkDialog dialog = new AddLinkDialog(Display.getCurrent().getActiveShell(), richText.getBasePath());
            dialog.open();
            if (dialog.getReturnCode() == 0 && (linkURL = dialog.getLink().getURL()).length() > 0) {
                richText.executeCommand("addLink", linkURL);
            }
        }
    }
}

