/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class PasteAction
extends RichTextAction {
    private static final String SOURCE_URL = "SourceURL:";
    private static final String HTM_EXT = ".htm";
    private static final String HTML_EXT = ".html";
    private static final Pattern HREF_REFERENCES = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    private static final Pattern SRC_REFERENCES = Pattern.compile("src\\s*=\\s*\"(.*?)\"", 34);

    public PasteAction() {
        this.setImage(RichTextImages.IMG_PASTE);
        this.setDisabledImage(RichTextImages.DISABLED_IMG_PASTE);
        this.setToolTipText(RichTextResources.getString("RichText.pasteAction.toolTipText"));
        this.setEnabled(true);
    }

    public void execute(IRichText richText) {
        if (richText != null) {
            this.copyLinkResources(richText);
            richText.executeCommand("paste");
        }
    }

    protected void copyLinkResources(IRichText richText) {
        try {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            String html = (String)clipboard.getContents((Transfer)HTMLTransfer.getInstance());
            if (html != null && html.length() > 0) {
                File tgtFile;
                String scheme;
                String basePath = richText.getBasePath();
                String sourceURL = this.getSourceURL(html);
                if (sourceURL == null || sourceURL.length() == 0) {
                    sourceURL = basePath;
                }
                URI sourceURI = new URI(NetUtil.encodeFileURL((String)sourceURL));
                Matcher matcher = HREF_REFERENCES.matcher(html);
                while (matcher.find()) {
                    URI hrefURI;
                    String href = matcher.group(1);
                    if (!href.toLowerCase().endsWith(HTM_EXT) && !href.toLowerCase().endsWith(HTML_EXT) || (scheme = (hrefURI = sourceURI.resolve(href)).getScheme()) == null || !scheme.equalsIgnoreCase("file")) continue;
                    String url = hrefURI.toString();
                    File srcFile = new File(url);
                    tgtFile = new File(String.valueOf(basePath) + "resources");
                    tgtFile.mkdirs();
                    FileUtil.copyFile((File)srcFile, (File)tgtFile);
                }
                matcher = SRC_REFERENCES.matcher(html);
                while (matcher.find()) {
                    String src = matcher.group(1);
                    URI srcURI = sourceURI.resolve(src);
                    scheme = srcURI.getScheme();
                    if (scheme == null || !scheme.equalsIgnoreCase("file")) continue;
                    File srcFile = null;
                    String authority = srcURI.getAuthority();
                    srcFile = authority != null ? new File(String.valueOf(authority) + srcURI.getPath()) : new File(srcURI.getPath());
                    tgtFile = new File(String.valueOf(basePath) + "resources");
                    tgtFile.mkdirs();
                    FileUtil.copyFile((File)srcFile, (File)tgtFile);
                }
            }
        }
        catch (Exception exception) {}
    }

    protected String getSourceURL(String htmlContent) {
        String sourceURL = null;
        int sourceURLIndex = htmlContent.indexOf(SOURCE_URL);
        if (sourceURLIndex > 0) {
            sourceURL = htmlContent.substring(sourceURLIndex + SOURCE_URL.length());
            if ((sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.LINE_SEP))).toLowerCase().endsWith(HTM_EXT) || sourceURL.toLowerCase().endsWith(HTML_EXT)) {
                sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.getFileName((String)sourceURL)) - 1);
                sourceURL = sourceURL.replace('\\', '/');
            }
            sourceURL = FileUtil.appendSeparator((String)sourceURL, (String)"/");
        }
        return sourceURL;
    }
}

