/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.dialogs;

import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.epf.richtext.html.Table;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddTableDialog
extends BaseDialog {
    private static final int DEFAULT_ROWS = 2;
    private static final int DEFAULT_COLUMNS = 2;
    private static final int DEFAULT_WIDTH = 180;
    private static final String[] TABLE_STYLE_LABELS = new String[]{RichTextResources.getString("RichText.tableHeaderNone.text"), RichTextResources.getString("RichText.tableHeaderCols.text"), RichTextResources.getString("RichText.tableHeaderRows.text"), RichTextResources.getString("RichText.tableHeaderBoth.text")};
    private Table table = new Table();
    private Text rowsText;
    private Text colsText;
    private Text widthText;
    private Combo tableTypeCombo;
    private Text summaryText;
    private Text captionText;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (AddTableDialog.this.okButton != null) {
                try {
                    int rows = Integer.parseInt(AddTableDialog.this.rowsText.getText().trim());
                    int cols = Integer.parseInt(AddTableDialog.this.colsText.getText().trim());
                    int width = Integer.parseInt(AddTableDialog.this.widthText.getText().trim());
                    AddTableDialog.this.okButton.setEnabled(rows > 0 && cols > 0 && width > 0);
                }
                catch (Exception exception) {
                    AddTableDialog.this.okButton.setEnabled(false);
                }
            }
        }
    };

    public AddTableDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label rowsLabel = new Label(composite, 0);
        rowsLabel.setText(RichTextResources.getString("RichText.rowsLabel.text"));
        this.rowsText = new Text(composite, 2048);
        this.rowsText.setTextLimit(2);
        this.rowsText.setText("2");
        GridData gridData = new GridData(768);
        this.rowsText.setLayoutData((Object)gridData);
        this.rowsText.addModifyListener(this.modifyListener);
        Label colsLabel = new Label(composite, 0);
        colsLabel.setText(RichTextResources.getString("RichText.columnsLabel.text"));
        this.colsText = new Text(composite, 2048);
        this.colsText.setTextLimit(2);
        this.colsText.setText("2");
        GridData gridData2 = new GridData(768);
        this.colsText.setLayoutData((Object)gridData2);
        this.colsText.addModifyListener(this.modifyListener);
        Label widthLabel = new Label(composite, 0);
        widthLabel.setText(RichTextResources.getString("RichText.widthLabel.text"));
        this.widthText = new Text(composite, 2048);
        this.widthText.setText("180");
        GridData gridData3 = new GridData(768);
        this.widthText.setLayoutData((Object)gridData3);
        this.widthText.addModifyListener(this.modifyListener);
        Label headerTypeLabel = new Label(composite, 0);
        headerTypeLabel.setText(RichTextResources.getString("RichText.tableStyleLabel.text"));
        this.tableTypeCombo = new Combo(composite, 2056);
        this.tableTypeCombo.setLayoutData((Object)new GridData(768));
        this.tableTypeCombo.setItems(TABLE_STYLE_LABELS);
        this.tableTypeCombo.setText(TABLE_STYLE_LABELS[0]);
        Label summaryLabel = new Label(composite, 0);
        summaryLabel.setText(RichTextResources.getString("RichText.summaryLabel.text"));
        this.summaryText = new Text(composite, 2048);
        GridData gridData4 = new GridData(768);
        this.summaryText.setLayoutData((Object)gridData4);
        Label captionLabel = new Label(composite, 0);
        captionLabel.setText(RichTextResources.getString("RichText.captionLabel.text"));
        this.captionText = new Text(composite, 2048);
        GridData gridData5 = new GridData(768);
        this.captionText.setLayoutData((Object)gridData5);
        super.getShell().setText(RichTextResources.getString("RichText.addTableDialog.title"));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        String widthValue;
        String colsValue;
        String rowsValue = this.rowsText.getText();
        if (rowsValue != null && rowsValue.length() > 0) {
            try {
                int rows = Integer.parseInt(rowsValue);
                this.table.setRows(rows);
            }
            catch (Exception exception) {
                this.table.setRows(2);
            }
        }
        if ((colsValue = this.colsText.getText()) != null && colsValue.length() > 0) {
            try {
                int cols = Integer.parseInt(colsValue);
                this.table.setColumns(cols);
            }
            catch (Exception exception) {
                this.table.setColumns(2);
            }
        }
        if ((widthValue = this.widthText.getText()) != null && widthValue.length() > 0) {
            try {
                int width = Integer.parseInt(widthValue);
                this.table.setWidth(width);
            }
            catch (Exception exception) {
                this.table.setWidth(180);
            }
        }
        this.table.setSummary(this.summaryText.getText().trim());
        this.table.setCaption(this.captionText.getText().trim());
        this.table.setTableHeaders(this.tableTypeCombo.getSelectionIndex());
        super.okPressed();
    }

    public Table getTable() {
        return this.table;
    }
}

