/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;

public abstract class AbstractHandler
implements IHandler {
    private List handlerListeners;

    public void addHandlerListener(IHandlerListener handlerListener) {
        if (handlerListener == null) {
            throw new NullPointerException();
        }
        if (this.handlerListeners == null) {
            this.handlerListeners = new ArrayList();
        }
        if (!this.handlerListeners.contains(handlerListener)) {
            this.handlerListeners.add(handlerListener);
        }
    }

    public void dispose() {
    }

    protected void fireHandlerChanged(HandlerEvent handlerEvent) {
        if (handlerEvent == null) {
            throw new NullPointerException();
        }
        if (this.handlerListeners != null) {
            int i = 0;
            while (i < this.handlerListeners.size()) {
                ((IHandlerListener)this.handlerListeners.get(i)).handlerChanged(handlerEvent);
                ++i;
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    protected boolean hasListeners() {
        return this.handlerListeners != null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        if (handlerListener == null) {
            throw new NullPointerException();
        }
        if (this.handlerListeners == null) {
            return;
        }
        if (this.handlerListeners != null) {
            this.handlerListeners.remove(handlerListener);
        }
        if (this.handlerListeners.isEmpty()) {
            this.handlerListeners = null;
        }
    }
}

