/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.swt;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.swt.SharedStyleManager;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.osgi.framework.Bundle;

public class PageStyleManager
extends SharedStyleManager {
    private AbstractIntroPage page;
    private Hashtable altStyleProperties = new Hashtable();
    private IntroModelRoot root;

    public PageStyleManager(AbstractIntroPage page, Properties sharedProperties) {
        Hashtable altStyles;
        this.page = page;
        this.bundle = page.getBundle();
        this.properties = page.injectSharedStyle() ? new Properties(sharedProperties) : new Properties();
        String altStyle = page.getAltStyle();
        if (altStyle != null) {
            this.load(this.properties, altStyle);
        }
        if ((altStyles = page.getAltStyles()) != null) {
            Enumeration styles = altStyles.keys();
            while (styles.hasMoreElements()) {
                String style = (String)styles.nextElement();
                Properties inheritedProperties = new Properties();
                Bundle bundle = (Bundle)altStyles.get(style);
                this.load(inheritedProperties, style);
                this.altStyleProperties.put(inheritedProperties, bundle);
            }
        }
        this.root = (IntroModelRoot)page.getParentPage().getParent();
    }

    public String getProperty(String key) {
        return this.getProperty(key, true);
    }

    private String getProperty(String key, boolean useImplicitKey) {
        Properties aProperties = this.findPropertyOwner(key);
        String value = super.doGetProperty(aProperties, key);
        if (useImplicitKey && value == null && this.page.getId() != null && key.startsWith(this.page.getId())) {
            String relativeKey = key.substring(this.page.getId().length());
            return this.getProperty(relativeKey);
        }
        return value;
    }

    private Properties findPropertyOwner(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties;
        }
        Enumeration inheritedPageProperties = this.altStyleProperties.keys();
        while (inheritedPageProperties.hasMoreElements()) {
            Properties aProperties = (Properties)inheritedPageProperties.nextElement();
            if (!aProperties.containsKey(key)) continue;
            return aProperties;
        }
        return this.properties;
    }

    protected Bundle getAssociatedBundle(String key) {
        Properties aProperties = this.findPropertyOwner(key);
        Bundle bundle = (Bundle)this.altStyleProperties.get(aProperties);
        if (bundle != null) {
            return bundle;
        }
        return super.getAssociatedBundle(key);
    }

    public int getPageNumberOfColumns() {
        return this.getIntProperty(this.page, ".layout.ncolumns", 0);
    }

    public int getNumberOfColumns(IntroGroup group) {
        return this.getIntProperty(group, ".layout.ncolumns", 0);
    }

    public int getPageVerticalSpacing() {
        return this.getIntProperty(this.page, ".layout.vspacing", 5);
    }

    public int getVerticalSpacing(IntroGroup group) {
        return this.getIntProperty(group, ".layout.vspacing", 5);
    }

    public int getPageHorizantalSpacing() {
        return this.getIntProperty(this.page, ".layout.hspacing", 5);
    }

    public int getHorizantalSpacing(IntroGroup group) {
        return this.getIntProperty(group, ".layout.hspacing", 5);
    }

    public int getColSpan(AbstractBaseIntroElement element) {
        return this.getIntProperty(element, ".layout.colspan", 1);
    }

    public int getRowSpan(AbstractBaseIntroElement element) {
        return this.getIntProperty(element, ".layout.rowspan", 1);
    }

    private int getIntProperty(AbstractBaseIntroElement element, String qualifier, int defaultValue) {
        StringBuffer buff = ModelLoaderUtil.createPathToElementKey(element);
        if (buff == null) {
            return defaultValue;
        }
        String key = buff.append(qualifier).toString();
        return this.getIntProperty(key, defaultValue);
    }

    private int getIntProperty(String key, int defaulValue) {
        int intValue = defaulValue;
        String value = this.getProperty(key);
        if (value == null) {
            return intValue;
        }
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Log.error("Failed to parse key: " + key + " as an integer.", e);
        }
        return intValue;
    }

    public String getDescription(IntroGroup group) {
        StringBuffer buff = ModelLoaderUtil.createPathToElementKey(group);
        if (buff == null) {
            return null;
        }
        String key = buff.append(".description-id").toString();
        return this.doGetDescription(group, key);
    }

    public String getPageDescription() {
        if (this.page.getId() == null) {
            return null;
        }
        String key = String.valueOf(this.page.getId()) + ".description-id";
        return this.doGetDescription(this.page, key);
    }

    private String doGetDescription(AbstractIntroContainer parent, String key) {
        String path = this.getProperty(key);
        String description = null;
        if (path != null) {
            description = this.findTextFromPath(parent, path);
        }
        if (description != null) {
            return description;
        }
        return this.findTextFromStyleId(parent, this.getDescriptionStyleId());
    }

    private String getDescriptionStyleId() {
        String key = "description-style-id";
        return this.getProperty(key);
    }

    public String getPageSubTitle() {
        String key = String.valueOf(this.page.getId()) + ".subtitle-id";
        String path = this.getProperty(key);
        String description = null;
        if (path != null) {
            description = this.findTextFromPath(this.page, path);
        }
        if (description != null) {
            return description;
        }
        return this.findTextFromStyleId(this.page, this.getPageSubTitleStyleId());
    }

    private String getPageSubTitleStyleId() {
        String key = "subtitle-style-id";
        return this.getProperty(key);
    }

    private String findTextFromPath(AbstractIntroContainer parent, String path) {
        AbstractIntroElement child = parent.findTarget(this.root, path);
        if (child != null && child.isOfType(512)) {
            this.makeFiltered(child);
            return ((IntroText)child).getText();
        }
        return null;
    }

    private String findTextFromStyleId(AbstractIntroContainer parent, String styleId) {
        IntroText[] allText = (IntroText[])parent.getChildrenOfType(512);
        int i = 0;
        while (i < allText.length) {
            if (allText[i].getStyleId() != null && allText[i].getStyleId().equals(styleId)) {
                this.makeFiltered(allText[i]);
                return allText[i].getText();
            }
            ++i;
        }
        return null;
    }

    private AbstractIntroElement makeFiltered(AbstractIntroElement element) {
        if (element.isOfType(21245)) {
            ((AbstractBaseIntroElement)element).setFilterState(true);
        }
        return element;
    }

    public boolean getShowLinkDescription() {
        String key = String.valueOf(this.page.getId()) + ".show-link-description";
        String value = this.getProperty(key);
        if (value == null) {
            key = ".show-link-description";
            value = this.getProperty(key);
        }
        if (value == null) {
            value = "true";
        }
        return value.toLowerCase().equals("true");
    }

    public boolean showHomePageNavigation() {
        String key = String.valueOf(this.page.getId()) + ".show-home-page-navigation";
        String value = this.getProperty(key);
        if (value == null) {
            key = ".show-home-page-navigation";
            value = this.getProperty(key);
        }
        if (value == null) {
            value = "true";
        }
        return value.equalsIgnoreCase("true");
    }

    public Color getColor(FormToolkit toolkit, AbstractBaseIntroElement element) {
        StringBuffer buff = ModelLoaderUtil.createPathToElementKey(element);
        if (buff == null) {
            return null;
        }
        String key = buff.append(".font.fg").toString();
        return this.getColor(toolkit, key);
    }

    public boolean isBold(IntroText text) {
        String key;
        String value = null;
        StringBuffer buff = ModelLoaderUtil.createPathToElementKey(text);
        if (buff != null && (value = this.getProperty(key = buff.append(".font.bold").toString())) != null) {
            return value.toLowerCase().equals("true");
        }
        if (value == null && (value = this.getProperty("bold-style-id")) != null && text.getStyleId() != null) {
            return text.getStyleId().equals(value);
        }
        return false;
    }

    public static Font getBannerFont() {
        return JFaceResources.getBannerFont();
    }

    public static Font getHeaderFont() {
        return JFaceResources.getHeaderFont();
    }

    public Image getImage(IntroLink link, String qualifier, String defaultKey) {
        String key = this.createImageKey(this.page, link, qualifier);
        String value = this.getProperty(key, false);
        if (value == null && this.page.getId() != null && key.startsWith(this.page.getId())) {
            key = key.substring(this.page.getId().length());
        }
        String pageKey = this.createImageKey(this.page, null, qualifier);
        return this.getImage(key, pageKey, defaultKey);
    }

    private String createImageKey(AbstractIntroPage page, IntroLink link, String qualifier) {
        StringBuffer buff = null;
        if (link != null) {
            buff = ModelLoaderUtil.createPathToElementKey(link);
            if (buff == null) {
                return "";
            }
        } else {
            buff = new StringBuffer();
            buff.append(page.getId());
        }
        buff.append(".");
        buff.append(qualifier);
        return buff.toString();
    }

    public Image getImage(IntroImage introImage) {
        String imageLocation = introImage.getSrcAsIs();
        String key = ModelLoaderUtil.createPathToElementKey(introImage).toString();
        if (ImageUtil.hasImage(key)) {
            return ImageUtil.getImage(key);
        }
        ImageUtil.registerImage(key, this.bundle, imageLocation);
        Image image = ImageUtil.getImage(key);
        return image;
    }
}

