/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkContentProvider;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkLabelProvider;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkSorter;
import org.eclipse.ui.views.bookmarkexplorer.CopyBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.EditBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.OpenBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.PasteBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.RemoveBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.SelectAllAction;
import org.eclipse.ui.views.navigator.ShowInNavigatorAction;

public class BookmarkNavigator
extends ViewPart {
    private Table table;
    private TableViewer viewer;
    private OpenBookmarkAction openAction;
    private CopyBookmarkAction copyAction;
    private PasteBookmarkAction pasteAction;
    private RemoveBookmarkAction removeAction;
    private EditBookmarkAction editAction;
    private SelectAllAction selectAllAction;
    private ShowInNavigatorAction showInNavigatorAction;
    private SortByAction sortByDescriptionAction;
    private SortByAction sortByResourceAction;
    private SortByAction sortByFolderAction;
    private SortByAction sortByLineAction;
    private SortByAction sortByCreationTime;
    private ChangeSortDirectionAction sortAscendingAction;
    private ChangeSortDirectionAction sortDescendingAction;
    private IMemento memento;
    private BookmarkSorter sorter;
    private Clipboard clipboard;
    private final String[] columnHeaders = new String[]{BookmarkMessages.ColumnIcon_header, BookmarkMessages.ColumnDescription_header, BookmarkMessages.ColumnResource_header, BookmarkMessages.ColumnFolder_header, BookmarkMessages.ColumnLocation_header};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(16, false, true), new ColumnWeightData(200), new ColumnWeightData(75), new ColumnWeightData(150), new ColumnWeightData(60)};
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ID = "id";
    private static final String TAG_MARKER = "marker";
    private static final String TAG_RESOURCE = "resource";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    void addContributions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.openAction = new OpenBookmarkAction(this);
        this.openAction.setImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/gotoobj_tsk.gif"));
        this.copyAction = new CopyBookmarkAction(this);
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.pasteAction = new PasteBookmarkAction(this);
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.removeAction = new RemoveBookmarkAction(this);
        this.removeAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.removeAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.editAction = new EditBookmarkAction(this);
        this.selectAllAction = new SelectAllAction(this);
        this.showInNavigatorAction = new ShowInNavigatorAction(this.getViewSite().getPage(), (ISelectionProvider)this.viewer);
        this.handleSelectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                BookmarkNavigator.this.fillContextMenu(mgr);
            }
        });
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mgr, (ISelectionProvider)this.viewer);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.removeAction);
        tbm.add((IAction)this.openAction);
        tbm.update(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeAction);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                BookmarkNavigator.this.openAction.run();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BookmarkNavigator.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                BookmarkNavigator.this.handleKeyPressed(e);
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.clipboard = new Clipboard(parent.getDisplay());
        this.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.createColumns();
        this.sorter = new BookmarkSorter();
        this.viewer.setContentProvider((IContentProvider)new BookmarkContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new BookmarkLabelProvider(this));
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.setSorter((ViewerSorter)this.sorter);
        IDialogSettings workbenchSettings = BookmarkNavigator.getPlugin().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection("BookmarkSortState");
        this.sorter.restoreState(settings);
        this.addContributions();
        this.initDragAndDrop();
        this.createSortActions();
        this.fillActionBars();
        this.updateSortState();
        this.updatePasteEnablement();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.ui.bookmark_view_context");
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.copyAction);
        this.updatePasteEnablement();
        manager.add((IAction)this.pasteAction);
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IAction)this.showInNavigatorAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.editAction);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(null, BookmarkNavigator.this.getViewer().getSelection());
                }
            };
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(adapter);
    }

    static AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
    }

    Shell getShell() {
        return this.getViewSite().getShell();
    }

    StructuredViewer getViewer() {
        return this.viewer;
    }

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.removeAction.isEnabled()) {
            this.removeAction.run();
        }
    }

    void handleSelectionChanged(IStructuredSelection selection) {
        this.openAction.selectionChanged(selection);
        this.removeAction.selectionChanged(selection);
        this.editAction.selectionChanged(selection);
        this.selectAllAction.selectionChanged(selection);
        this.showInNavigatorAction.selectionChanged(selection);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected void initDragAndDrop() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                BookmarkNavigator.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)listener);
    }

    void performDragSetData(DragSourceEvent event) {
        if (MarkerTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = ((IStructuredSelection)this.viewer.getSelection()).toArray();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            Object[] markers = ((IStructuredSelection)this.viewer.getSelection()).toArray();
            if (markers != null) {
                StringBuffer buffer = new StringBuffer();
                ILabelProvider provider = (ILabelProvider)this.getViewer().getLabelProvider();
                int i = 0;
                while (i < markers.length) {
                    String text;
                    if (i > 0) {
                        buffer.append(System.getProperty("line.separator"));
                    }
                    if ((text = provider.getText(markers[i])) != null) {
                        buffer.append(text);
                    }
                    ++i;
                }
                event.data = buffer.toString();
            }
            return;
        }
    }

    void restoreState(IMemento memento) {
        Scrollable scrollable;
        ScrollBar bar;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMemento selectionMem = memento.getChild(TAG_SELECTION);
        if (selectionMem != null) {
            ArrayList<IMarker> selectionList = new ArrayList<IMarker>();
            IMemento[] markerMems = selectionMem.getChildren(TAG_MARKER);
            int i = 0;
            while (i < markerMems.length) {
                try {
                    IMarker marker;
                    long id = new Long(markerMems[i].getString(TAG_ID));
                    IResource resource = root.findMember(markerMems[i].getString(TAG_RESOURCE));
                    if (resource != null && (marker = resource.findMarker(id)) != null) {
                        selectionList.add(marker);
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
        if ((bar = (scrollable = (Scrollable)this.viewer.getControl()).getVerticalBar()) != null) {
            try {
                String posStr = memento.getString(TAG_VERTICAL_POSITION);
                int position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((bar = scrollable.getHorizontalBar()) != null) {
            try {
                String posStr = memento.getString(TAG_HORIZONTAL_POSITION);
                int position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.updateSortState();
        this.viewer.refresh();
    }

    public void saveState(IMemento memento) {
        ScrollBar bar;
        if (this.viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        Object[] markers = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        if (markers.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            int i = 0;
            while (i < markers.length) {
                IMemento elementMem = selectionMem.createChild(TAG_MARKER);
                IMarker marker = (IMarker)markers[i];
                elementMem.putString(TAG_RESOURCE, marker.getResource().getFullPath().toString());
                elementMem.putString(TAG_ID, String.valueOf(marker.getId()));
                ++i;
            }
        }
        int position = (bar = scrollable.getVerticalBar()) != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = scrollable.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    void createColumns() {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = BookmarkNavigator.this.table.indexOf((TableColumn)e.widget) - 1;
                if (column == BookmarkNavigator.this.sorter.getTopPriority()) {
                    BookmarkNavigator.this.sorter.reverseTopPriority();
                } else {
                    BookmarkNavigator.this.sorter.setTopPriority(column);
                }
                BookmarkNavigator.this.updateSortState();
                BookmarkNavigator.this.viewer.refresh();
                IDialogSettings workbenchSettings = BookmarkNavigator.getPlugin().getDialogSettings();
                IDialogSettings settings = workbenchSettings.getSection("BookmarkSortState");
                if (settings == null) {
                    settings = workbenchSettings.addNewSection("BookmarkSortState");
                }
                BookmarkNavigator.this.sorter.saveState(settings);
            }
        };
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            if (i > 0) {
                tc.addSelectionListener((SelectionListener)headerListener);
            }
            ++i;
        }
    }

    void createTable(Composite parent) {
        this.table = new Table(parent, 66306);
        this.table.setLinesVisible(true);
    }

    void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager menu = actionBars.getMenuManager();
        MenuManager submenu = new MenuManager(BookmarkMessages.SortMenuGroup_text);
        menu.add((IContributionItem)submenu);
        submenu.add((IAction)this.sortByDescriptionAction);
        submenu.add((IAction)this.sortByResourceAction);
        submenu.add((IAction)this.sortByFolderAction);
        submenu.add((IAction)this.sortByLineAction);
        submenu.add((IAction)this.sortByCreationTime);
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.sortAscendingAction);
        submenu.add((IAction)this.sortDescendingAction);
    }

    void createSortActions() {
        this.sortByDescriptionAction = new SortByAction(0);
        this.sortByDescriptionAction.setText(BookmarkMessages.ColumnDescription_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByDescriptionAction, "org.eclipse.ui.bookmark_sort_description_action_context");
        this.sortByResourceAction = new SortByAction(1);
        this.sortByResourceAction.setText(BookmarkMessages.ColumnResource_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByResourceAction, "org.eclipse.ui.bookmark_sort_resource_action_context");
        this.sortByFolderAction = new SortByAction(2);
        this.sortByFolderAction.setText(BookmarkMessages.ColumnFolder_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByFolderAction, "org.eclipse.ui.bookmark_sort_folder_action_context");
        this.sortByLineAction = new SortByAction(3);
        this.sortByLineAction.setText(BookmarkMessages.ColumnLocation_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByLineAction, "org.eclipse.ui.bookmark_sort_location_action_context");
        this.sortByCreationTime = new SortByAction(4);
        this.sortByCreationTime.setText(BookmarkMessages.ColumnCreationTime_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByCreationTime, "org.eclipse.ui.bookmark_sort_creation_time_action_context");
        this.sortAscendingAction = new ChangeSortDirectionAction(1);
        this.sortAscendingAction.setText(BookmarkMessages.SortDirectionAscending_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortAscendingAction, "org.eclipse.ui.bookmark_sort_ascending_action_context");
        this.sortDescendingAction = new ChangeSortDirectionAction(-1);
        this.sortDescendingAction.setText(BookmarkMessages.SortDirectionDescending_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortDescendingAction, "org.eclipse.ui.bookmark_sort_descending_action_context");
    }

    void updateSortState() {
        int column = this.sorter.getTopPriority();
        this.sortByDescriptionAction.setChecked(column == 0);
        this.sortByResourceAction.setChecked(column == 1);
        this.sortByFolderAction.setChecked(column == 2);
        this.sortByLineAction.setChecked(column == 3);
        this.sortByCreationTime.setChecked(column == 4);
        int direction = this.sorter.getTopPriorityDirection();
        this.sortAscendingAction.setChecked(direction == 1);
        this.sortDescendingAction.setChecked(direction == -1);
    }

    void updatePasteEnablement() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.getClipboard().getContents((Transfer)transfer);
        boolean canPaste = false;
        if (markerData != null) {
            int i = 0;
            while (i < markerData.length) {
                try {
                    if (markerData[i].getType().equals("org.eclipse.core.resources.bookmark")) {
                        canPaste = true;
                        break;
                    }
                }
                catch (CoreException coreException) {
                    canPaste = false;
                }
                ++i;
            }
        }
        this.pasteAction.setEnabled(canPaste);
    }

    Clipboard getClipboard() {
        return this.clipboard;
    }

    class SortByAction
    extends Action {
        private int column;

        public SortByAction(int column) {
            this.column = column;
        }

        public void run() {
            BookmarkNavigator.this.sorter.setTopPriority(this.column);
            BookmarkNavigator.this.updateSortState();
            BookmarkNavigator.this.viewer.refresh();
            IDialogSettings workbenchSettings = BookmarkNavigator.getPlugin().getDialogSettings();
            IDialogSettings settings = workbenchSettings.getSection("BookmarkSortState");
            if (settings == null) {
                settings = workbenchSettings.addNewSection("BookmarkSortState");
            }
            BookmarkNavigator.this.sorter.saveState(settings);
        }
    }

    class ChangeSortDirectionAction
    extends Action {
        private int direction;

        public ChangeSortDirectionAction(int direction) {
            this.direction = direction;
        }

        public void run() {
            BookmarkNavigator.this.sorter.setTopPriorityDirection(this.direction);
            BookmarkNavigator.this.updateSortState();
            BookmarkNavigator.this.viewer.refresh();
            IDialogSettings workbenchSettings = BookmarkNavigator.getPlugin().getDialogSettings();
            IDialogSettings settings = workbenchSettings.getSection("BookmarkSortState");
            if (settings == null) {
                settings = workbenchSettings.addNewSection("BookmarkSortState");
            }
            BookmarkNavigator.this.sorter.saveState(settings);
        }
    }
}

