/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.PublishingPlugin;

public class PublishingUtil {
    public static void jarFiles(File jarDir, File jarFile) throws IOException {
        File[] files = jarDir.listFiles();
        if (jarFile.exists()) {
            jarFile.delete();
        }
        BufferedOutputStream bStream = new BufferedOutputStream(new FileOutputStream(jarFile));
        ZipOutputStream zipperStream = new ZipOutputStream(bStream);
        byte[] bytes = new byte[4096];
        int i = 0;
        while (i < files.length) {
            File currentFile = files[i];
            if (!currentFile.isDirectory()) {
                ZipEntry currEntry = new ZipEntry(currentFile.getName());
                zipperStream.putNextEntry(currEntry);
                BufferedInputStream biStream = new BufferedInputStream(new FileInputStream(currentFile));
                while (biStream.available() > 0) {
                    int num = biStream.read(bytes);
                    zipperStream.write(bytes, 0, num);
                }
                biStream.close();
                zipperStream.closeEntry();
            }
            ++i;
        }
        zipperStream.close();
        bStream.close();
    }

    public static String getHtml(XmlElement xmlElement, String xslPath) {
        try {
            URL url = new URL(PublishingPlugin.getDefault().getInstallURL(), xslPath);
            if (url == null) {
                System.out.println("Unable to get xsl template " + xslPath);
                return null;
            }
            String xsl_uri = Platform.resolve((URL)url).getPath();
            StringBuffer xml = new StringBuffer();
            xml.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
            Properties xslParams = PublishingPlugin.getDefault().getProperties("/xsl/resources.properties");
            StringWriter sw = new StringWriter();
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)sw);
            sw.flush();
            return ResourceHelper.decodeUrlsInContent((String)sw.getBuffer().toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

