/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.util.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.util.http.HttpResponse;
import org.eclipse.epf.publishing.util.http.HttpTimeoutHandler;

public class HttpUtil {
    private static final boolean DEBUG = false;
    private static Map handlerMap = new HashMap();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static HttpResponse doGet(Socket sock, String url, Properties headers) throws Exception {
        respHeaders = new Properties();
        respCookies = new Vector<HttpResponse.Cookie>();
        resp = null;
        out = null;
        in = null;
        try {
            block23: {
                host = sock.getInetAddress().getHostName();
                port = sock.getPort();
                out = new DataOutputStream(sock.getOutputStream());
                in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
                out.writeBytes("GET " + url + " HTTP/1.1\r\n");
                out.writeBytes("Host: " + host + ":" + port + "\r\n");
                out.writeBytes("User-Agent: Mozilla/4.0\r\n");
                out.writeBytes("Content-Length: 0\r\n");
                if (headers != null && headers.size() > 0) {
                    names = headers.keys();
                    while (names.hasMoreElements()) {
                        name = (String)names.nextElement();
                        if (name.equalsIgnoreCase("Host") || name.equalsIgnoreCase("User-Agent") || name.equalsIgnoreCase("Content-Length")) continue;
                        out.writeBytes(String.valueOf(name) + ": " + headers.getProperty(name) + "\r\n");
                    }
                }
                out.writeBytes("\r\n");
                out.flush();
                endFound = false;
                contentLen = -1;
                "content-length: ".length();
                httpResp = "";
                line = in.readLine();
                if (line == null) {
                    throw new Exception(PublishingResources.getString("Publishing.serverError.msg"));
                }
                httpResp = String.valueOf(httpResp) + line + "\n";
                tokens = new StringTokenizer(line);
                try {
                    tokens.nextToken();
                    respStatus = Integer.parseInt(tokens.nextToken());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception(PublishingResources.formatString("Publishing.invalidHttpResponseError.msg", new Object[]{host, Integer.toString(port), line}));
                }
                while ((line = in.readLine()) != null) {
                    httpResp = String.valueOf(httpResp) + line + "\n";
                    if (line.length() == 0) {
                        endFound = true;
                        break;
                    }
                    id = line.indexOf(": ");
                    if (id <= 0) continue;
                    header = line.substring(0, id).toLowerCase();
                    value = "";
                    if (line.length() > id + 2) {
                        value = line.substring(id + 2);
                    }
                    if (header.equalsIgnoreCase("set-cookie")) {
                        cookie = HttpUtil.parseCookie(value);
                        if (cookie == null) continue;
                        respCookies.addElement(cookie);
                        continue;
                    }
                    respHeaders.put(header, value);
                }
                contentLenStr = respHeaders.getProperty("content-length");
                contentLen = contentLenStr == null ? -1 : Integer.parseInt(contentLenStr);
                if (!endFound) {
                    throw new Exception(PublishingResources.formatString("Publishing.invalidHttpResponseError.msg", new Object[]{host, Integer.toString(port), httpResp}));
                }
                if (contentLen <= 0) break block23;
                bos = new ByteArrayOutputStream();
                buff = new byte[Math.min(2048, contentLen)];
                while ((num = in.read(buff)) != -1) {
                    n = contentLen - bos.size();
                    if (n <= num) {
                        bos.write(buff, 0, n);
                        break;
                    }
                    bos.write(buff, 0, num);
                }
                resp = bos.toString();
                ** GOTO lbl-1000
            }
            if (contentLen >= 0) ** GOTO lbl-1000
            bos = new ByteArrayOutputStream();
            buff = new byte[2048];
            while (true) {
                block24: {
                    if ((num = in.read(buff)) != -1) break block24;
                    resp = bos.toString();
                    break;
                }
                bos.write(buff, 0, num);
            }
        }
        catch (Throwable var22_26) {
            var21_27 = null;
            try {
                in.close();
            }
            catch (Exception v0) {}
            try {
                out.close();
                throw var22_26;
            }
            catch (Exception v1) {}
            throw var22_26;
        }
lbl-1000:
        // 3 sources

        {
            var21_28 = null;
        }
        try {}
        catch (Exception v2) {}
        in.close();
        try {}
        catch (Exception v3) {}
        out.close();
        return new HttpResponse(respStatus, respHeaders, respCookies, resp);
        return new HttpResponse(respStatus, respHeaders, respCookies, resp);
    }

    public static HttpResponse doGet(String host, int port, String url, int timeout, Properties headers) throws Exception {
        HttpResponse httpResponse;
        Socket sock = null;
        try {
            sock = new Socket(host, port);
            sock.setSoTimeout(timeout);
            httpResponse = HttpUtil.doGet(sock, url, headers);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                sock.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            sock.close();
        }
        catch (Exception exception) {}
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URLStreamHandler getHandler(int timeout) {
        Integer key = new Integer(timeout);
        URLStreamHandler handler = (URLStreamHandler)handlerMap.get(key);
        if (handler == null) {
            Map map = handlerMap;
            synchronized (map) {
                handler = (URLStreamHandler)handlerMap.get(key);
                if (handler == null) {
                    handler = new HttpTimeoutHandler(timeout);
                    handlerMap.put(key, handler);
                }
            }
        }
        return handler;
    }

    public static HttpResponse doGet(String url, Properties headers, int timeout) throws Exception {
        return HttpUtil.doGet(new URL(null, url, HttpUtil.getHandler(timeout)), headers);
    }

    static HttpResponse doGet(URL url, Properties headers) throws Exception {
        String name;
        Properties respHeaders = new Properties();
        Vector<HttpResponse.Cookie> respCookies = new Vector<HttpResponse.Cookie>();
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setUseCaches(false);
        if (headers != null && headers.size() > 0) {
            Enumeration<Object> names = headers.keys();
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                if (name.equalsIgnoreCase("Host") || name.equalsIgnoreCase("User-Agent") || name.equalsIgnoreCase("Content-Length")) continue;
                conn.setRequestProperty(name, headers.getProperty(name));
            }
        }
        int respStatus = conn.getResponseCode();
        int i = 1;
        while ((name = conn.getHeaderFieldKey(i)) != null) {
            String value = conn.getHeaderField(name);
            if (name.equalsIgnoreCase("set-cookie")) {
                HttpResponse.Cookie cookie = HttpUtil.parseCookie(value);
                if (cookie != null) {
                    respCookies.addElement(cookie);
                }
            } else {
                respHeaders.put(name.toLowerCase(), value);
            }
            ++i;
        }
        int contentLen = conn.getContentLength();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String resp = null;
        if (contentLen > 0) {
            int num;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[Math.min(2048, contentLen)];
            while ((num = in.read(buff)) != -1) {
                int n = contentLen - bos.size();
                if (n <= num) {
                    bos.write(buff, 0, n);
                    break;
                }
                bos.write(buff, 0, num);
            }
            resp = bos.toString();
        } else if (contentLen < 0) {
            int num;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[2048];
            while ((num = in.read(buff)) != -1) {
                bos.write(buff, 0, num);
            }
            resp = bos.toString();
        }
        return new HttpResponse(respStatus, respHeaders, respCookies, resp);
    }

    static HttpResponse doPost(String url, Properties headers, Properties data, int timeout) throws Exception {
        return HttpUtil.doPost(new URL(null, url, HttpUtil.getHandler(timeout)), headers, data);
    }

    static HttpResponse doPost(URL url, Properties headers, Properties data) throws Exception {
        String name;
        Properties respHeaders = new Properties();
        Vector<HttpResponse.Cookie> respCookies = new Vector<HttpResponse.Cookie>();
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        if (headers != null && headers.size() > 0) {
            Enumeration<Object> names = headers.keys();
            while (names.hasMoreElements()) {
                String name2 = (String)names.nextElement();
                if (name2.equalsIgnoreCase("Host") || name2.equalsIgnoreCase("User-Agent") || name2.equalsIgnoreCase("Content-Length")) continue;
                conn.setRequestProperty(name2, headers.getProperty(name2));
            }
        }
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        String content = "";
        Enumeration<?> enumeration = data.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name3 = (String)enumeration.nextElement();
            content = String.valueOf(content) + name3 + "=" + URLEncoder.encode(data.getProperty(name3));
            if (!enumeration.hasMoreElements()) continue;
            content = String.valueOf(content) + "&";
        }
        if (content.length() > 0) {
            out.writeBytes(content);
        }
        int respStatus = conn.getResponseCode();
        int i = 1;
        while ((name = conn.getHeaderFieldKey(i)) != null) {
            String value = conn.getHeaderField(name);
            if (name.equalsIgnoreCase("set-cookie")) {
                HttpResponse.Cookie cookie = HttpUtil.parseCookie(value);
                if (cookie != null) {
                    respCookies.addElement(cookie);
                }
            } else {
                respHeaders.put(name.toLowerCase(), value);
            }
            ++i;
        }
        int contentLen = conn.getContentLength();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String resp = null;
        if (contentLen > 0) {
            int num;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[Math.min(2048, contentLen)];
            while ((num = in.read(buff)) != -1) {
                int n = contentLen - bos.size();
                if (n <= num) {
                    bos.write(buff, 0, n);
                    break;
                }
                bos.write(buff, 0, num);
            }
            resp = bos.toString();
        } else if (contentLen < 0) {
            int num;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[2048];
            while ((num = in.read(buff)) != -1) {
                bos.write(buff, 0, num);
            }
            resp = bos.toString();
        }
        return new HttpResponse(respStatus, respHeaders, respCookies, resp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static HttpResponse doPost(Socket sock, String url, Properties headers, Properties data) throws Exception {
        respHeaders = new Properties();
        respCookies = new Vector<HttpResponse.Cookie>();
        resp = null;
        out = null;
        in = null;
        try {
            block25: {
                block23: {
                    host = sock.getInetAddress().getHostName();
                    port = sock.getPort();
                    out = new DataOutputStream(sock.getOutputStream());
                    in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
                    content = "";
                    enum = data.propertyNames();
                    while (true) {
                        if (!enum.hasMoreElements()) {
                            out.writeBytes("POST " + url + " HTTP/1.1\r\n");
                            out.writeBytes("Host: " + host + ":" + port + "\r\n");
                            out.writeBytes("User-Agent: Mozilla/4.0\r\n");
                            out.writeBytes("Content-Type: application/x-www-form-urlencoded\r\n");
                            out.writeBytes("Content-Length: " + content.length() + "\r\n");
                            if (headers != null && headers.size() > 0) {
                                names = headers.keys();
                                break;
                            }
                            break block23;
                        }
                        name = (String)enum.nextElement();
                        content = String.valueOf(content) + name + "=" + URLEncoder.encode(data.getProperty(name));
                        if (!enum.hasMoreElements()) continue;
                        content = String.valueOf(content) + "&";
                    }
                    while (names.hasMoreElements()) {
                        name = (String)names.nextElement();
                        if (name.equalsIgnoreCase("Host") || name.equalsIgnoreCase("User-Agent") || name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Content-Type")) continue;
                        out.writeBytes(String.valueOf(name) + ": " + headers.getProperty(name) + "\r\n");
                    }
                }
                out.writeBytes("\r\n");
                if (content.length() > 0) {
                    out.writeBytes(content);
                }
                out.flush();
                endFound = false;
                contentLen = -1;
                "content-length: ".length();
                httpResp = "";
                line = in.readLine();
                if (line == null) {
                    throw new Exception(PublishingResources.getString("Publishing.serverError.msg"));
                }
                httpResp = String.valueOf(httpResp) + line + "\n";
                tokens = new StringTokenizer(line);
                try {
                    tokens.nextToken();
                    respStatus = Integer.parseInt(tokens.nextToken());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception(PublishingResources.formatString("Publishing.invalidHttpResponseError.msg", new Object[]{host, Integer.toString(port), line}));
                }
                while ((line = in.readLine()) != null) {
                    httpResp = String.valueOf(httpResp) + line + "\n";
                    if (line.length() == 0) {
                        endFound = true;
                        break;
                    }
                    id = line.indexOf(": ");
                    if (id <= 0) continue;
                    header = line.substring(0, id).toLowerCase();
                    value = "";
                    if (line.length() > id + 2) {
                        value = line.substring(id + 2);
                    }
                    if (header.equals("set-cookie")) {
                        cookie = HttpUtil.parseCookie(value);
                        if (cookie == null) continue;
                        respCookies.addElement(cookie);
                        continue;
                    }
                    respHeaders.put(header, value);
                }
                contentLenStr = respHeaders.getProperty("content-length");
                contentLen = contentLenStr == null ? 0 : Integer.parseInt(contentLenStr);
                if (!endFound || contentLen == -1) {
                    throw new Exception(PublishingResources.formatString("Publishing.invalidHttpResponseError.msg", new Object[]{host, Integer.toString(port), httpResp}));
                }
                if (contentLen <= 0) break block25;
                buff = new byte[contentLen];
                in.readFully(buff);
                resp = new String(buff);
                ** GOTO lbl-1000
            }
            if (contentLenStr != null) ** GOTO lbl-1000
            bos = new ByteArrayOutputStream();
            buff = new byte[2048];
            while (true) {
                block26: {
                    if ((num = in.read(buff)) != -1) break block26;
                    resp = bos.toString();
                    break;
                }
                bos.write(buff, 0, num);
            }
        }
        catch (Throwable var24_27) {
            var23_28 = null;
            try {
                in.close();
            }
            catch (Exception v0) {}
            try {
                out.close();
                throw var24_27;
            }
            catch (Exception v1) {}
            throw var24_27;
        }
lbl-1000:
        // 3 sources

        {
            var23_29 = null;
        }
        try {}
        catch (Exception v2) {}
        in.close();
        try {}
        catch (Exception v3) {}
        out.close();
        return new HttpResponse(respStatus, respHeaders, respCookies, resp);
        return new HttpResponse(respStatus, respHeaders, respCookies, resp);
    }

    public static HttpResponse doPost(String host, int port, String url, int timeout, Properties headers, Properties data) throws Exception {
        HttpResponse httpResponse;
        Socket sock = null;
        try {
            sock = new Socket(host, port);
            sock.setSoTimeout(timeout);
            httpResponse = HttpUtil.doPost(sock, url, headers, data);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                sock.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            sock.close();
        }
        catch (Exception exception) {}
        return httpResponse;
    }

    public static Map parseQueryString(String str) throws Exception {
        StringTokenizer tokens = new StringTokenizer(str, "&");
        HashMap<String, String> map = new HashMap<String, String>();
        int maxId = str.length() - 1;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int id = token.indexOf(61);
            if (id == -1) continue;
            if (id == 0 || id == maxId) {
                map.put(token, null);
                continue;
            }
            map.put(token.substring(0, id), HttpUtil.urlDecode(token.substring(id + 1)));
        }
        return map;
    }

    public static HttpResponse.Cookie parseCookie(String str) {
        String value;
        int id = str.indexOf(61);
        if (id <= 0) {
            return null;
        }
        String name = str.substring(0, id);
        int fromId = name.length() + 1;
        int toId = str.indexOf(";");
        String theRest = null;
        if (toId == -1) {
            value = str.substring(fromId);
        } else {
            value = str.substring(fromId, toId);
            if (toId < str.length() - 1) {
                theRest = str.substring(toId + 1);
            }
        }
        HttpResponse.Cookie cookie = new HttpResponse.Cookie(name, value);
        if (theRest != null) {
            StringTokenizer tokens = new StringTokenizer(theRest, ";");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                id = token.indexOf(61);
                if (id <= 0) continue;
                name = token.substring(0, id);
                value = id == token.length() - 1 ? "" : token.substring(id + 1);
                if (name.equalsIgnoreCase("domain")) {
                    cookie.setDomain(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("path")) continue;
                cookie.setPath(value);
            }
        }
        return cookie;
    }

    public static Enumeration parseCookies(String str) {
        StringTokenizer tokens = new StringTokenizer(str, ";");
        Vector<HttpResponse.Cookie> cookies = new Vector<HttpResponse.Cookie>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            int id = token.indexOf(61);
            if (id == -1) continue;
            String name = token.substring(0, id);
            String value = "";
            if (id < token.length() - 1) {
                value = token.substring(id + 1);
            }
            cookies.addElement(new HttpResponse.Cookie(name, value));
        }
        return cookies.elements();
    }

    public static String toCookieString(Enumeration cookies) {
        StringBuffer strBuf = new StringBuffer();
        while (cookies.hasMoreElements()) {
            HttpResponse.Cookie cookie = (HttpResponse.Cookie)cookies.nextElement();
            strBuf.append(cookie.getName()).append('=').append(cookie.getValue()).append("; ");
        }
        return strBuf.toString();
    }

    public static String urlDecode(String s) throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    break;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        String result = sb.toString();
        byte[] inputBytes = result.getBytes("8859_1");
        return new String(inputBytes);
    }

    public static void main(String[] args) throws Exception {
        String url = args[0];
        String uid = args[1];
        String email = args[2];
        Properties data = new Properties();
        data.put("uid", uid);
        data.put("email", email);
        System.out.println(HttpUtil.doPost(url, null, data, 0));
    }
}

