/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.preferences;

import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class LibraryUIPreferences {
    public static final String PROMPT_FOR_LIBRARY_AT_STARTUP = "promptForLibraryAtStartup";
    public static final String SAVED_LIBRARY_PATH = "savedLibraryPath";
    public static final String PUBLISH_UNOPEN_ACTIVITY_DD = "publishUnopenActivityDetailDiagram";
    public static final String PREF_SWITCH_CONFIG = "switchConfigurationOnProcessActivate";

    static {
        IPreferenceStore store = LibraryUIPlugin.getDefault().getPreferenceStore();
        store.setDefault(PROMPT_FOR_LIBRARY_AT_STARTUP, true);
        store.setDefault(SAVED_LIBRARY_PATH, "");
        store.setDefault(PREF_SWITCH_CONFIG, "prompt");
    }

    public static boolean getPromptForMethodLibraryAtStartup() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getBoolean(PROMPT_FOR_LIBRARY_AT_STARTUP);
    }

    public static void setPromptForMethodLibraryAtStartup(boolean enabled) {
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(PROMPT_FOR_LIBRARY_AT_STARTUP, enabled);
    }

    public static void setPublishUnopenActivitydd(boolean enabled) {
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(PUBLISH_UNOPEN_ACTIVITY_DD, enabled);
    }

    public static boolean getPublishUnopenActivitydd() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getBoolean(PUBLISH_UNOPEN_ACTIVITY_DD);
    }

    public static String getSwitchConfig() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getString(PREF_SWITCH_CONFIG);
    }

    public static void setSwitchConfig(String value) {
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(PREF_SWITCH_CONFIG, value);
    }

    public static String getSavedLibraryPath() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getString(SAVED_LIBRARY_PATH);
    }

    public static void setSavedLibraryPath(String libPath) {
        String path = libPath;
        if (path.endsWith("library.xmi")) {
            path = FileUtil.getParentDirectory((String)path);
        }
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(SAVED_LIBRARY_PATH, path);
    }

    public static String getDefaultLibraryPath() {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        String libraryPath = LibraryUIPlugin.getDefault().getString("libraryPath");
        if (libraryPath == null || libraryPath.length() == 0 || libraryPath.startsWith("[")) {
            libraryPath = String.valueOf(userHome) + "/Method Libraries/Library";
        } else if (libraryPath.startsWith("<user.home>")) {
            libraryPath = String.valueOf(userHome) + libraryPath.substring(11);
        }
        if (System.getProperty("file.separator").equals("\\")) {
            libraryPath = libraryPath.replace('/', '\\');
        }
        return libraryPath;
    }
}

