/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.filebuffers.IPersistableAnnotationModel;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.internal.filebuffers.DocumentReader;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.NLSUtility;
import org.eclipse.core.internal.filebuffers.Progress;
import org.eclipse.core.internal.filebuffers.ResourceFileBuffer;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;

public class ResourceTextFileBuffer
extends ResourceFileBuffer
implements ITextFileBuffer {
    private static final int READER_CHUNK_SIZE = 2048;
    private static final int BUFFER_SIZE = 16384;
    private static final QualifiedName ENCODING_KEY = new QualifiedName("org.eclipse.core.filebuffers", "encoding");
    private static final IStatus STATUS_OK = new Status(0, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.FileBuffer_status_ok, null);
    private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.core.filebuffers", 1, FileBuffersMessages.FileBuffer_status_error, null);
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final QualifiedName[] NO_PROPERTIES = new QualifiedName[0];
    protected IDocument fDocument;
    protected String fEncoding;
    protected IDocumentListener fDocumentListener = new DocumentListener();
    protected IAnnotationModel fAnnotationModel;
    private String fExplicitEncoding;
    private boolean fHasBOM;

    public ResourceTextFileBuffer(TextFileBufferManager manager) {
        super(manager);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.fAnnotationModel;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
        this.fExplicitEncoding = encoding;
        this.fHasBOM = false;
        try {
            this.fFile.setCharset(encoding, null);
            if (encoding == null) {
                this.fEncoding = this.fFile.getCharset();
            }
            this.setHasBOM();
        }
        catch (CoreException x) {
            this.handleCoreException(x);
        }
    }

    public IStatus getStatus() {
        if (!this.isDisconnected()) {
            if (this.fStatus != null) {
                return this.fStatus;
            }
            return this.fDocument == null ? STATUS_ERROR : STATUS_OK;
        }
        return STATUS_ERROR;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IContentType getContentType() throws CoreException {
        try {
            IContentDescription desc;
            if (this.isDirty()) {
                DocumentReader reader;
                block11: {
                    IContentType iContentType;
                    reader = null;
                    try {
                        reader = new DocumentReader(this.getDocument());
                        IContentDescription desc2 = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFile.getName(), NO_PROPERTIES);
                        if (desc2 == null || desc2.getContentType() == null) break block11;
                        iContentType = desc2.getContentType();
                        Object var3_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_6 = null;
                        try {
                            if (reader == null) throw throwable;
                            ((Reader)reader).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    if (reader == null) return iContentType;
                    ((Reader)reader).close();
                    return iContentType;
                }
                Object var3_7 = null;
                try {}
                catch (IOException iOException) {}
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            if ((desc = this.fFile.getContentDescription()) == null) return null;
            if (desc.getContentType() == null) return null;
            return desc.getContentType();
        }
        catch (IOException x) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, NLSUtility.format(FileBuffersMessages.FileBuffer_error_queryContentDescription, this.fFile.getFullPath().toOSString()), (Throwable)x));
        }
    }

    protected void addFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
    }

    protected void removeFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
    }

    protected void initializeFileBufferContent(IProgressMonitor monitor) throws CoreException {
        try {
            this.fEncoding = null;
            this.fExplicitEncoding = null;
            try {
                this.fEncoding = this.fFile.getPersistentProperty(ENCODING_KEY);
            }
            catch (CoreException coreException) {}
            if (this.fEncoding != null) {
                try {
                    this.fExplicitEncoding = this.fEncoding;
                    this.fFile.setCharset(this.fEncoding, monitor);
                    this.fFile.setPersistentProperty(ENCODING_KEY, null);
                }
                catch (CoreException ex) {
                    this.handleCoreException(ex);
                }
                this.setHasBOM();
            } else {
                this.cacheEncodingState();
            }
            this.fDocument = this.fManager.createEmptyDocument(this.getLocation());
            this.setDocumentContent(this.fDocument, this.fFile, this.fEncoding);
            this.fAnnotationModel = this.fManager.createAnnotationModel(this.getLocation());
        }
        catch (CoreException x) {
            this.fDocument = this.fManager.createEmptyDocument(this.getLocation());
            this.fStatus = x.getStatus();
        }
    }

    protected void setHasBOM() throws CoreException {
        this.fHasBOM = false;
        IContentDescription description = this.fFile.getContentDescription();
        this.fHasBOM = description != null && description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
    }

    protected void connected() {
        super.connected();
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.connect(this.fDocument);
        }
    }

    protected void dispose() {
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.disconnect(this.fDocument);
        }
        this.fDocument = null;
        super.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitFileBufferContent(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        String encoding = this.computeEncoding();
        try {
            byte[] bytes = this.fDocument.get().getBytes(encoding);
            if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                int bomLength = IContentDescription.BOM_UTF_8.length;
                byte[] bytesWithBOM = new byte[bytes.length + bomLength];
                System.arraycopy(IContentDescription.BOM_UTF_8, 0, bytesWithBOM, 0, bomLength);
                System.arraycopy(bytes, 0, bytesWithBOM, bomLength, bytes.length);
                bytes = bytesWithBOM;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            if (this.fFile.exists()) {
                if (!overwrite) {
                    this.checkSynchronizationState();
                }
                this.fFile.setContents((InputStream)stream, overwrite, true, monitor);
                if (this.fDocument instanceof IDocumentExtension4) {
                    this.fSynchronizationStamp = ((IDocumentExtension4)this.fDocument).getModificationStamp();
                    this.fFile.revertModificationStamp(this.fSynchronizationStamp);
                } else {
                    this.fSynchronizationStamp = this.fFile.getModificationStamp();
                }
                if (!(this.fAnnotationModel instanceof IPersistableAnnotationModel)) return;
                IPersistableAnnotationModel persistableModel = (IPersistableAnnotationModel)this.fAnnotationModel;
                persistableModel.commit(this.fDocument);
                return;
            }
            monitor = Progress.getMonitor(monitor);
            try {
                monitor.beginTask(FileBuffersMessages.ResourceTextFileBuffer_task_saving, 2);
                ContainerCreator creator = new ContainerCreator(this.fFile.getWorkspace(), this.fFile.getParent().getFullPath());
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                creator.createContainer((IProgressMonitor)subMonitor);
                subMonitor.done();
                subMonitor = new SubProgressMonitor(monitor, 1);
                this.fFile.create((InputStream)stream, false, (IProgressMonitor)subMonitor);
                subMonitor.done();
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var8_14 = null;
            }
            monitor.done();
            this.fSynchronizationStamp = this.fFile.getModificationStamp();
            return;
        }
        catch (UnsupportedEncodingException x) {
            String message = NLSUtility.format(FileBuffersMessages.ResourceTextFileBuffer_error_unsupported_encoding_message_arg, encoding);
            Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)x);
            throw new CoreException((IStatus)s);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String computeEncoding() {
        DocumentReader reader;
        block14: {
            String string;
            if (this.fExplicitEncoding != null) {
                return this.fExplicitEncoding;
            }
            reader = new DocumentReader(this.fDocument);
            try {
                try {
                    String encoding;
                    QualifiedName[] options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                    IContentDescription description = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFile.getName(), options);
                    if (description == null || (encoding = description.getCharset()) == null) break block14;
                    string = encoding;
                    Object var5_6 = null;
                }
                catch (IOException iOException) {
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (reader == null) throw throwable;
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (reader == null) return string;
            ((Reader)reader).close();
            return string;
        }
        Object var5_8 = null;
        try {}
        catch (IOException iOException) {}
        if (reader != null) {
            ((Reader)reader).close();
        }
        if (this.fHasBOM) {
            return this.fEncoding;
        }
        try {
            return this.fFile.getParent().getDefaultCharset();
        }
        catch (CoreException coreException) {
            return this.fManager.getDefaultEncoding();
        }
    }

    protected void cacheEncodingState() throws CoreException {
        this.fExplicitEncoding = this.fFile.getCharset(false);
        this.fEncoding = this.fExplicitEncoding != null ? this.fExplicitEncoding : this.fFile.getCharset();
        this.setHasBOM();
    }

    protected void handleFileContentChanged(boolean revert) throws CoreException {
        boolean replaceContent;
        IDocument document = this.fManager.createEmptyDocument(this.fFile.getLocation());
        IStatus status = null;
        try {
            this.cacheEncodingState();
            this.setDocumentContent(document, this.fFile, this.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        String newContent = document.get();
        boolean bl = replaceContent = !newContent.equals(this.fDocument.get());
        if (replaceContent) {
            this.fManager.fireBufferContentAboutToBeReplaced(this);
        }
        this.removeFileBufferContentListeners();
        this.fSynchronizationStamp = this.fFile.getModificationStamp();
        if (replaceContent) {
            if (this.fDocument instanceof IDocumentExtension4) {
                ((IDocumentExtension4)this.fDocument).set(newContent, this.fSynchronizationStamp);
            } else {
                this.fDocument.set(newContent);
            }
        }
        this.fCanBeSaved = false;
        this.fStatus = status;
        this.addFileBufferContentListeners();
        if (replaceContent) {
            this.fManager.fireBufferContentReplaced(this);
        }
        if (this.fAnnotationModel instanceof IPersistableAnnotationModel) {
            IPersistableAnnotationModel persistableModel = (IPersistableAnnotationModel)this.fAnnotationModel;
            try {
                if (revert) {
                    persistableModel.revert(this.fDocument);
                } else {
                    persistableModel.reinitialize(this.fDocument);
                }
            }
            catch (CoreException x) {
                this.fStatus = x.getStatus();
            }
        }
        this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDocumentContent(IDocument document, IFile file, String encoding) throws CoreException {
        InputStream contentStream = file.getContents();
        Reader in = null;
        try {
            block15: {
                try {
                    if (encoding == null) {
                        encoding = this.fManager.getDefaultEncoding();
                    }
                    if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                        int bytes;
                        int n = 0;
                        do {
                            if ((bytes = contentStream.read(new byte[IContentDescription.BOM_UTF_8.length])) != -1) continue;
                            throw new IOException();
                        } while ((n += bytes) < IContentDescription.BOM_UTF_8.length);
                    }
                    in = new BufferedReader(new InputStreamReader(contentStream, encoding), 16384);
                    StringBuffer buffer = new StringBuffer(16384);
                    char[] readBuffer = new char[2048];
                    int n = in.read(readBuffer);
                    while (true) {
                        if (n <= 0) {
                            if (!(document instanceof IDocumentExtension4)) break;
                            ((IDocumentExtension4)document).set(buffer.toString(), this.fFile.getModificationStamp());
                            break block15;
                        }
                        buffer.append(readBuffer, 0, n);
                        n = in.read(readBuffer);
                    }
                    document.set(buffer.toString());
                }
                catch (IOException x) {
                    String message = x.getMessage() != null ? x.getMessage() : "";
                    Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)x);
                    throw new CoreException((IStatus)s);
                }
            }
            Object var9_16 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            try {
                if (in != null) {
                    in.close();
                    throw throwable;
                }
                contentStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (in != null) {
            in.close();
            return;
        }
        contentStream.close();
    }

    private void checkSynchronizationState() throws CoreException {
        if (!this.fFile.isSynchronized(0)) {
            Status status = new Status(4, "org.eclipse.core.filebuffers", 274, FileBuffersMessages.FileBuffer_error_outOfSync, null);
            throw new CoreException((IStatus)status);
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (ResourceTextFileBuffer.this.fCanBeSaved && ResourceTextFileBuffer.this.fSynchronizationStamp == event.getModificationStamp()) {
                ResourceTextFileBuffer.this.fCanBeSaved = false;
                ResourceTextFileBuffer.this.fManager.fireDirtyStateChanged(ResourceTextFileBuffer.this, ResourceTextFileBuffer.this.fCanBeSaved);
            } else if (!ResourceTextFileBuffer.this.fCanBeSaved) {
                ResourceTextFileBuffer.this.fCanBeSaved = true;
                ResourceTextFileBuffer.this.fManager.fireDirtyStateChanged(ResourceTextFileBuffer.this, ResourceTextFileBuffer.this.fCanBeSaved);
            }
        }
    }
}

