/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.CustomCategory;
import com.ibm.uma.DiagramElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.provider.UmaItemProviderAdapterFactory;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;

public class LibraryImportManager {
    private LibraryDiffManager diffMgr;
    private ElementDiffTree rootTree;
    protected AdapterFactoryEditingDomain editingDomain = null;
    protected AdapterFactoryContentProvider afcp = null;
    private MethodLibrary baseLibrary = null;
    private MethodLibrary importingLibrary = null;
    private Map replacedElementMap = new HashMap();
    private List newElements = new ArrayList();
    private boolean debug = ImportPlugin.getDefault().isDebugging();
    private List processedNewElements = new ArrayList();

    public LibraryImportManager(LibraryDiffManager diffMgr, List checkedList) {
        this.diffMgr = diffMgr;
        this.rootTree = diffMgr.getDiffTree();
        this.init();
        this.baseLibrary = (MethodLibrary)this.rootTree.getBaseElement();
        this.importingLibrary = (MethodLibrary)this.rootTree.getImportElement();
    }

    private void init() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new UmaItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        this.afcp = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void doMerge(boolean replaceExisting) throws Exception {
        if (this.debug) {
            System.out.println("Merging configuration ...");
        }
        File srcDir = LibraryUtil.getLibraryRootPath((MethodLibrary)this.importingLibrary);
        File destDir = LibraryUtil.getLibraryRootPath((MethodLibrary)this.baseLibrary);
        if (this.debug) {
            System.out.println("loading library ...");
        }
        LibraryUtil.loadAll((MethodLibrary)this.baseLibrary);
        LibraryUtil.loadAll((MethodLibrary)this.importingLibrary);
        LibraryUtil.detachFromResource((MethodLibrary)this.importingLibrary);
        this.importingLibrary.setName("ImportingLib: " + this.importingLibrary.getName());
        if (this.debug) {
            System.out.println("Process configuration diff tree ...");
        }
        this.processDiffTree(this.rootTree, replaceExisting);
        if (this.debug) {
            System.out.println("perform integrity checking ...");
        }
        this.doIntegrityCheck();
        if (this.debug) {
            System.out.println("saving library ...");
        }
        LibraryUtil.saveAll((MethodLibrary)this.baseLibrary);
        if (this.debug) {
            System.out.println("copying resource files ...");
        }
        String includes = "resources/**, **/resources/**";
        LayoutResources.copyDir((File)srcDir, (File)destDir, (String)includes, null);
        if (this.debug) {
            System.out.println("Merging configuration done...");
        }
    }

    private void processDiffTree(ElementDiffTree diffTree, boolean replaceExisting) {
        List children;
        if (diffTree == null) {
            return;
        }
        int state = diffTree.getDiffState();
        MethodElement base = diffTree.getBaseElement();
        MethodElement imp = diffTree.getImportElement();
        if (replaceExisting && state == 4) {
            if (base instanceof MethodConfiguration) {
                this.doReplaceConfiguration((MethodConfiguration)base, (MethodConfiguration)imp);
            } else if (base instanceof MethodPlugin) {
                this.doReplacePlugin((MethodPlugin)base, (MethodPlugin)imp);
            } else if (base instanceof MethodPackage) {
                this.doReplacePackage((MethodPackage)base, (MethodPackage)imp);
            } else if (this.debug) {
                System.out.println("What is this: " + LibraryUtil.getTypeName((MethodElement)base));
            }
        } else if (state == 1) {
            this.doAdd((EObject)diffTree.getBaseParentElement(), diffTree.getImportElement());
        }
        if (state != 1 && (children = diffTree.getChildren()) != null && children.size() > 0) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.processDiffTree((ElementDiffTree)it.next(), replaceExisting);
            }
        }
    }

    private void doReplaceConfiguration(MethodConfiguration oldObj, MethodConfiguration newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        List properties = oldObj.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object newValue = newObj.eGet(feature);
                this.setFeatureValue((MethodElement)oldObj, feature, newValue, false);
                ++i;
            }
        }
    }

    private void doReplacePlugin(MethodPlugin oldObj, MethodPlugin newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        List properties = oldObj.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue((MethodElement)oldObj, feature, newValue, true);
                } else {
                    ContentPackage oldPkg = UmaUtil.findContentPackage((MethodPlugin)oldObj, (String[])ModelStructure.DEFAULT_CUSTOM_CATEGORY_PATH);
                    this.setReplaced((MethodElement)oldPkg);
                    CustomCategory oldCC = TngUtil.getRootCustomCategory((MethodPlugin)oldObj);
                    CustomCategory newCC = TngUtil.getRootCustomCategory((MethodPlugin)newObj);
                    oldPkg = (MethodPackage)oldCC.eContainer();
                    this.setReplaced((MethodElement)oldPkg);
                    this.doReplaceElement((MethodElement)oldCC, (MethodElement)newCC);
                }
                ++i;
            }
        }
    }

    private void doReplacePackage(MethodPackage oldObj, MethodPackage newObj) {
        List properties;
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        if (this.debug) {
            System.out.println("Replacing package " + LibraryUtil.getTypeName((MethodElement)oldObj));
        }
        if ((properties = oldObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue((MethodElement)oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    private void doReplaceElement(MethodElement oldObj, MethodElement newObj) {
        List properties;
        if (this.isReplaced(oldObj)) {
            return;
        }
        if (this.diffMgr.selectable(oldObj)) {
            return;
        }
        this.setReplaced(oldObj);
        if (this.debug) {
            System.out.println("Replacing element " + LibraryUtil.getTypeName((MethodElement)oldObj));
        }
        if ((properties = oldObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages() && feature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue(oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFeatureValue(MethodElement element, EStructuralFeature feature, Object newValue, boolean doDelete) {
        if (this.canIgnore(feature)) {
            return;
        }
        oldNotify = element.eDeliver();
        try {
            try {
                block21: {
                    block23: {
                        block22: {
                            block20: {
                                block19: {
                                    element.eSetDeliver(false);
                                    if (!this.canReset(feature)) break block19;
                                    element.eSet(feature, newValue);
                                    ** GOTO lbl-1000
                                }
                                if (!feature.isMany() || !(newValue instanceof List)) break block20;
                                oldValue = (List)element.eGet(feature);
                                diff = new ElementListDiff(oldValue, (List)newValue);
                                if (doDelete && diff.deletedItems.size() > 0) {
                                    oldValue.removeAll(diff.deletedItems);
                                    if (this.debug) {
                                        System.out.println("  Deleting feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", values: " + diff.deletedItems);
                                    }
                                }
                                if (diff.newItems.size() > 0) {
                                    itn = diff.newItems.iterator();
                                    while (true) {
                                        if (!itn.hasNext()) {
                                            if (!this.debug) break;
                                            System.out.println("  Adding feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", values: " + diff.newItems);
                                            break;
                                        }
                                        newObj = (MethodElement)itn.next();
                                        oldObj = this.diffMgr.getExistingElement(newObj.getGuid());
                                        if (oldObj == null) {
                                            oldValue.add(newObj);
                                            this.logNewElement(newObj);
                                            continue;
                                        }
                                        oldValue.add(oldObj);
                                        this.doReplaceElement(oldObj, newObj);
                                    }
                                }
                                if (diff.oldNewMap.size() > 0) {
                                    it = diff.oldNewMap.entrySet().iterator();
                                    while (it.hasNext()) {
                                        entry = it.next();
                                        oldObj = (MethodElement)entry.getKey();
                                        newObj = (MethodElement)entry.getValue();
                                        if (this.canReset(oldObj)) {
                                            if (this.debug) {
                                                System.out.println("  Resetting feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", value: " + LibraryUtil.getTypeName((MethodElement)oldObj));
                                            }
                                            EcoreUtil.replace((EObject)element, (EStructuralFeature)feature, (Object)oldObj, (Object)newObj);
                                            this.logResetElement(newObj);
                                            continue;
                                        }
                                        this.doReplaceElement(oldObj, newObj);
                                    }
                                }
                                ** GOTO lbl-1000
                            }
                            if (!(newValue instanceof MethodElement)) break block21;
                            o = (MethodElement)element.eGet(feature);
                            n = (MethodElement)newValue;
                            if (this.debug) {
                                System.out.println("  Replacinging feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", value: " + LibraryUtil.getTypeName((MethodElement)o));
                            }
                            if (!(newValue instanceof ContentDescription)) break block22;
                            this.doReplaceElement(o, n);
                            ** GOTO lbl-1000
                        }
                        if (!this.canReset(n)) break block23;
                        element.eSet(feature, newValue);
                        this.logNewElement(n);
                        ** GOTO lbl-1000
                    }
                    if (o != null && n != null && o.getGuid().equals(n.getGuid())) {
                        this.doReplaceElement(o, n);
                    } else {
                        element.eSet(feature, newValue);
                        this.logNewElement(n);
                    }
                    ** GOTO lbl-1000
                }
                element.eSet(feature, newValue);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable var13_15) {
            var12_16 = null;
            element.eSetDeliver(oldNotify);
            throw var13_15;
        }
lbl-1000:
        // 8 sources

        {
            var12_17 = null;
        }
        element.eSetDeliver(oldNotify);
    }

    private void doAdd(EObject owner, MethodElement newObj) {
        if (this.debug) {
            System.out.println("Adding element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if (owner != null) {
            if (owner instanceof MethodLibrary && newObj instanceof MethodPlugin) {
                LibraryProcessor.getInstance().addMethodPlugin((MethodPlugin)newObj);
            } else {
                if (owner instanceof MethodPackage && owner.eContainer() == null && this.debug) {
                    System.out.println("Error invalid owner");
                }
                if (owner != null) {
                    ImportPlugin.getDefault().getLogger().logError("Add Element: " + newObj);
                    Command cmd = AddCommand.create((EditingDomain)this.editingDomain, (Object)owner, null, (Object)newObj);
                    cmd.execute();
                } else {
                    ImportPlugin.getDefault().getLogger().logError("Unable to find owner for " + newObj);
                }
            }
            this.logNewElement(newObj);
        }
    }

    private void doIntegrityCheck() {
        while (this.newElements.size() > 0) {
            MethodElement newObj = (MethodElement)this.newElements.remove(0);
            try {
                if (newObj instanceof DiagramElement) {
                    this.fixDiagram((DiagramElement)newObj);
                    continue;
                }
                this.fixNewElementReferences(newObj);
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println("Exception while fixing new element " + LibraryUtil.getTypeName((MethodElement)newObj));
                }
                e.printStackTrace();
            }
        }
        List configs = this.baseLibrary.getPredefinedConfigurations();
        Iterator it = configs.iterator();
        while (it.hasNext()) {
            MethodConfiguration config = (MethodConfiguration)it.next();
            LibraryUtil.validateMethodConfiguration((MethodConfiguration)config);
        }
    }

    private void fixNewElementReferences(MethodElement newObj) {
        List properties;
        if (this.processedNewElements.contains(newObj)) {
            return;
        }
        this.processedNewElements.add(newObj);
        if (this.debug) {
            System.out.println("Fixing element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if ((properties = newObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof List) {
                    Iterator it = new ArrayList((List)value).iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        this.fixNewElementFeatureValue(newObj, feature, o);
                    }
                } else {
                    this.fixNewElementFeatureValue(newObj, feature, value);
                }
                ++i;
            }
        }
    }

    private void fixDiagram(DiagramElement newObj) {
        List properties;
        if (this.processedNewElements.contains(newObj)) {
            return;
        }
        this.processedNewElements.add(newObj);
        if (this.debug) {
            System.out.println("Fixing diagram element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if ((properties = newObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof List) {
                    Iterator it = new ArrayList((List)value).iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof MethodElement)) continue;
                        if (feature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                            this.fixNewElementFeatureValue((MethodElement)newObj, feature, o);
                            continue;
                        }
                        if (!(o instanceof DiagramElement)) continue;
                        this.fixDiagram((DiagramElement)o);
                    }
                } else if (value instanceof MethodElement) {
                    if (feature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                        this.fixNewElementFeatureValue((MethodElement)newObj, feature, value);
                    } else if (value instanceof DiagramElement) {
                        this.fixDiagram((DiagramElement)value);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixNewElementFeatureValue(MethodElement element, EStructuralFeature feature, Object obj) {
        if (!(obj instanceof MethodElement)) {
            return;
        }
        if (this.debug) {
            System.out.println("fixing element feature value " + LibraryUtil.getTypeName((MethodElement)element) + ", feature=" + feature.getName());
        }
        boolean oldNotify = element.eDeliver();
        try {
            block12: {
                try {
                    element.eSetDeliver(false);
                    MethodElement newObj = (MethodElement)obj;
                    MethodElement oldObj = this.getReplaced(newObj.getGuid());
                    if (oldObj == null) {
                        oldObj = this.diffMgr.getExistingElement(newObj.getGuid());
                    }
                    if (oldObj == null) {
                        this.fixNewElementReferences(newObj);
                        break block12;
                    }
                    try {
                        EcoreUtil.replace((EObject)element, (EStructuralFeature)feature, (Object)newObj, (Object)oldObj);
                    }
                    catch (Exception exception) {
                        EcoreUtil.remove((EObject)element, (EStructuralFeature)feature, (Object)newObj);
                        if (this.debug) {
                            System.out.println("Replaceing feature value failed for element [" + LibraryUtil.getTypeName((MethodElement)element) + "], feature [" + feature.getName() + "], value=" + newObj + ". The feature value is removed. ");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            element.eSetDeliver(oldNotify);
            throw throwable;
        }
        element.eSetDeliver(oldNotify);
    }

    private boolean canReset(MethodElement e) {
        boolean reset = false;
        if (e == null || e instanceof DiagramElement) {
            reset = true;
        }
        return reset;
    }

    private boolean canReset(EStructuralFeature feature) {
        return false;
    }

    private boolean canIgnore(EStructuralFeature feature) {
        return feature == UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable();
    }

    private boolean isReplaced(MethodElement oldObj) {
        return this.replacedElementMap.containsKey(oldObj.getGuid());
    }

    private void setReplaced(MethodElement oldObj) {
        String guid = oldObj.getGuid();
        if (!this.replacedElementMap.containsKey(guid)) {
            this.replacedElementMap.put(guid, oldObj);
        }
    }

    private MethodElement getReplaced(String guid) {
        return (MethodElement)this.replacedElementMap.get(guid);
    }

    private void logNewElement(MethodElement newObj) {
        if (!this.newElements.contains(newObj) && this.diffMgr.getExistingElement(newObj.getGuid()) == null) {
            this.newElements.add(newObj);
        }
    }

    private void logResetElement(MethodElement newObj) {
        if (!this.newElements.contains(newObj)) {
            this.newElements.add(newObj);
        }
    }

    public class ElementListDiff {
        List newItems = new ArrayList();
        List deletedItems = new ArrayList();
        Map oldNewMap = new LinkedHashMap();

        public ElementListDiff(List oldList, List newList) {
            Map newListGuidMap = this.getGuidMap(newList);
            this.newItems.addAll(newList);
            Iterator it = oldList.iterator();
            while (it.hasNext()) {
                MethodElement oldObj = (MethodElement)it.next();
                String guid = oldObj.getGuid();
                Object newObj = newListGuidMap.get(guid);
                if (newObj != null) {
                    this.oldNewMap.put(oldObj, newObj);
                    this.newItems.remove(newObj);
                    continue;
                }
                this.deletedItems.add(oldObj);
            }
        }

        private Map getGuidMap(List items) {
            HashMap<String, MethodElement> m = new HashMap<String, MethodElement>();
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement e = (MethodElement)it.next();
                m.put(e.getGuid(), e);
            }
            return m;
        }
    }
}

