/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.wizards.SelectConfigSpecsToImportPage;
import org.eclipse.epf.importing.wizards.SelectConfigsToImport;
import org.eclipse.epf.importing.wizards.SelectImportConfigurationSource;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportConfigurationWizard
extends Wizard
implements IImportWizard {
    private static final String WIZARD_TITLE = ImportResources.getString("Import.importConfigWizard.title");
    public boolean okToComplete = false;
    protected SelectImportConfigurationSource page1;
    protected SelectConfigsToImport configPage;
    protected SelectConfigSpecsToImportPage specsPage;
    protected ConfigurationImportData data = new ConfigurationImportData();
    protected ConfigurationImportService service = new ConfigurationImportService(this.data);

    public ImportConfigurationWizard() {
        this.setWindowTitle(WIZARD_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (LibraryProcessor.getInstance().isReadOnly()) {
            ImportPlugin.getDefault().getMsgDialog().displayError(WIZARD_TITLE, ImportResources.getString("Import.ImportConfigurationWizard.readonly"));
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportLibraryConfiguration.gif"));
        this.page1 = new SelectImportConfigurationSource(this.data, this.service);
        this.addPage((IWizardPage)this.page1);
        this.configPage = new SelectConfigsToImport(this.service);
        this.addPage((IWizardPage)this.configPage);
        this.specsPage = new SelectConfigSpecsToImportPage(this.data);
        this.addPage((IWizardPage)this.specsPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(LibraryUIImages.IMG_METHOD_CONFIGURATON);
    }

    public boolean canFinish() {
        return this.okToComplete;
    }

    public boolean performFinish() {
        LibraryBackupUtil.promptBackupLibrary(null, (File)LibraryProcessor.getInstance().getLibraryRootPath());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(ImportResources.getString("Import.ImportConfigurationWizard.MSG1"), -1);
                        ImportConfigurationWizard.this.service.performImport(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.getString("Import.ImportConfigurationWizard.error"), realException.getMessage());
            return false;
        }
        return true;
    }
}

