/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uma.edit.domain;

import com.ibm.uma.MethodElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;

public class TraceableAdapterFactoryEditingDomain
extends AdapterFactoryEditingDomain {
    private HashMap copyToOriginalMap = null;
    private Map originalToClipboardMap = null;

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack) {
        super(adapterFactory, commandStack);
    }

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, Map resourceToReadOnlyMap) {
        super(adapterFactory, commandStack, resourceToReadOnlyMap);
    }

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, ResourceSet resourceSet) {
        super(adapterFactory, commandStack, resourceSet);
    }

    public Map getCopyToOriginalMap() {
        if (this.copyToOriginalMap == null) {
            this.copyToOriginalMap = new HashMap();
        }
        return this.copyToOriginalMap;
    }

    public void addCopyInfo(Collection c, CopyCommand.Helper copyHelper) {
        if (this.isNewCopy(c, copyHelper)) {
            this.addNewCopy(c, copyHelper);
            return;
        }
        this.chainCopy(c, copyHelper);
    }

    private void addNewCopy(Collection c, CopyCommand.Helper copyHelper) {
        if (this.originalToClipboardMap == null) {
            this.originalToClipboardMap = new HashMap();
        }
        Iterator iter = copyHelper.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = copyHelper.get(key);
            this.originalToClipboardMap.put(key, value);
        }
    }

    private void chainCopy(Collection c, CopyCommand.Helper copyHelper) {
        if (this.originalToClipboardMap != null) {
            if (this.copyToOriginalMap == null) {
                this.copyToOriginalMap = new HashMap();
            }
            Iterator iter = this.originalToClipboardMap.keySet().iterator();
            while (iter.hasNext()) {
                Object o2CKey = iter.next();
                Object o2CValue = this.originalToClipboardMap.get(o2CKey);
                Object copyValue = copyHelper.get(o2CValue);
                if (copyValue == null || !(o2CKey instanceof MethodElement)) continue;
                this.copyToOriginalMap.put(copyValue, o2CKey);
            }
        }
    }

    private boolean isNewCopy(Collection c, CopyCommand.Helper copyHelper) {
        if (this.originalToClipboardMap == null) {
            return true;
        }
        Iterator iter = copyHelper.keySet().iterator();
        while (iter.hasNext()) {
            Object clipKey = iter.next();
            if (this.originalToClipboardMap.containsValue(clipKey)) continue;
            return true;
        }
        return false;
    }

    public void resetCopyMaps() {
        if (this.originalToClipboardMap != null) {
            this.originalToClipboardMap.clear();
            this.originalToClipboardMap = null;
        }
        if (this.copyToOriginalMap != null) {
            this.copyToOriginalMap.clear();
            this.copyToOriginalMap = null;
        }
    }
}

