/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import com.ibm.uma.MethodElement;
import com.ibm.uma.Role;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;

public class WorkProductLayout
extends AbstractElementLayout {
    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = super.getXmlElement(includeReferences);
        if (includeReferences) {
            MethodElement role;
            Role responsibleRole = (Role)ConfigurationHelper.calc01FeatureValue(this.element, AssociationHelper.WorkProduct_ResponsibleRole, this.layoutManager.getConfiguration());
            if (responsibleRole != null && (role = ConfigurationHelper.getCalculatedElement((MethodElement)responsibleRole, this.layoutManager.getConfiguration())) != null) {
                String roleName = ((Role)role).getPresentationName();
                if (roleName == null || roleName.length() == 0) {
                    roleName = role.getName();
                }
                elementXml.setAttribute("responsibleRoleName", roleName);
                this.addReference(elementXml, "responsibleRole", role);
            }
            List modifyRoles = AssociationHelper.getModifiedBy((WorkProduct)((WorkProduct)this.element));
            modifyRoles = ConfigurationHelper.getCalculatedElements(modifyRoles, this.layoutManager.getConfiguration());
            this.addReferences(elementXml, "modifyRoles", modifyRoles);
            MethodElement domain = ConfigurationHelper.calc01FeatureValue(this.element, AssociationHelper.WorkProduct_Domain, this.layoutManager.getConfiguration());
            this.addReference(elementXml, "domain", domain);
            ArrayList workProductTypes = new ArrayList();
            ConfigurationHelper.calculateOppositeFeature(this.element, AssociationHelper.WorkProduct_WorkProductTypes, this.layoutManager.getConfiguration(), workProductTypes);
            this.addReferences(elementXml, "workProductTypes", workProductTypes);
            ArrayList mandatoryInputToTasks = new ArrayList();
            ConfigurationHelper.calculateOppositeFeature(this.element, AssociationHelper.WorkProduct_MandatoryInputTo_Tasks, this.layoutManager.getConfiguration(), mandatoryInputToTasks);
            this.addReferences(elementXml, "mandatoryInputToTasks", mandatoryInputToTasks);
            ArrayList optionalInputToTasks = new ArrayList();
            ConfigurationHelper.calculateOppositeFeature(this.element, AssociationHelper.WorkProduct_OptionalInputTo_Tasks, this.layoutManager.getConfiguration(), optionalInputToTasks);
            this.addReferences(elementXml, "optionalInputToTasks", optionalInputToTasks);
            ArrayList outputFromTasks = new ArrayList();
            ConfigurationHelper.calculateOppositeFeature(this.element, AssociationHelper.WorkProduct_OutputFrom_Tasks, this.layoutManager.getConfiguration(), outputFromTasks);
            this.addReferences(elementXml, "outputFromTasks", outputFromTasks);
        }
        return elementXml;
    }
}

