/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import com.ibm.uma.ContentDescription;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.GuidanceDescription;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.ImportExportUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.library.util.SAXParserXMI;

public class CopyAttachmentsToNewLocation
extends MethodElementAddCommand.BasicResourceManager {
    private Collection modifiedResourceSet;
    private boolean debug = LibraryPlugin.getDefault().isDebugging();
    private Map elementToOldPluginMap;
    private MethodPlugin lastOldPlugin = null;

    public Collection copyReferencedContents(Collection elements, Map elementToOldPluginMap) {
        this.lastOldPlugin = null;
        this.modifiedResourceSet = new HashSet();
        if (elementToOldPluginMap == null) {
            return this.modifiedResourceSet;
        }
        this.elementToOldPluginMap = elementToOldPluginMap;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Resource) {
                Resource r = (Resource)o;
                Iterator resourceIter = r.getContents().iterator();
                while (resourceIter.hasNext()) {
                    EObject e = (EObject)resourceIter.next();
                    this.HandleAttachmentsPlugin(e);
                }
                continue;
            }
            if (!(o instanceof EObject)) continue;
            EObject e = (EObject)o;
            this.HandleAttachmentsPlugin(e);
        }
        return this.modifiedResourceSet;
    }

    private void HandleAttachmentsPlugin(EObject e) {
        ContentDescription elementToProcess = null;
        if (this.elementToOldPluginMap != null && (MethodPlugin)this.elementToOldPluginMap.get(e) != null) {
            this.lastOldPlugin = (MethodPlugin)this.elementToOldPluginMap.get(e);
        }
        if (this.lastOldPlugin != null) {
            if (e instanceof DescribableElement) {
                DescribableElement de = (DescribableElement)e;
                try {
                    java.net.URI nodeIconUri;
                    File libDirFile = LibraryProcessor.getInstance().getLibraryRootPath();
                    java.net.URI shapeIconUri = de.getShapeicon();
                    if (shapeIconUri != null) {
                        java.net.URI srcShapeUri = TngUtil.getFullPathURI((EObject)de, (java.net.URI)shapeIconUri);
                        File srcFile = new File(srcShapeUri);
                        File tgtFile = new File(srcFile.getAbsolutePath().replaceFirst("\\" + File.separator + this.lastOldPlugin.getName() + "\\" + File.separator, "\\" + File.separator + UmaUtil.getMethodPlugin((EObject)de).getName() + "\\" + File.separator));
                        if (!tgtFile.exists()) {
                            FileUtil.copyfile((File)srcFile, (File)tgtFile);
                        }
                        java.net.URI newShapeIconUri = new java.net.URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)tgtFile, (File)libDirFile)));
                        de.setShapeicon(newShapeIconUri);
                        this.modifiedResourceSet.add(de.eResource());
                    }
                    if ((nodeIconUri = de.getNodeicon()) != null) {
                        java.net.URI srcNodeUri = TngUtil.getFullPathURI((EObject)de, (java.net.URI)nodeIconUri);
                        File srcFile = new File(srcNodeUri);
                        File tgtFile = new File(srcFile.getAbsolutePath().replaceFirst("\\" + File.separator + this.lastOldPlugin.getName() + "\\" + File.separator, "\\" + File.separator + UmaUtil.getMethodPlugin((EObject)de).getName() + "\\" + File.separator));
                        if (!tgtFile.exists()) {
                            FileUtil.copyfile((File)srcFile, (File)tgtFile);
                        }
                        java.net.URI newNodeIconUri = new java.net.URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)tgtFile, (File)libDirFile)));
                        de.setNodeicon(newNodeIconUri);
                        this.modifiedResourceSet.add(de.eResource());
                    }
                }
                catch (Exception ex) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
                }
                elementToProcess = de.getPresentation();
            } else if (e instanceof ContentDescription) {
                elementToProcess = (ContentDescription)e;
            } else if (e instanceof MethodElement) {
                elementToProcess = (MethodElement)e;
            } else if (this.debug) {
                System.out.println("CopyAttachmentsToNewLocation.HandleAttachmentsPlugin: unknown type " + e);
            }
            if (elementToProcess != null && elementToProcess.eResource() != null) {
                URI elementURI = LibraryProcessor.getInstance().getRelativeURI((MethodElement)elementToProcess);
                if (elementURI.segmentCount() < 1) {
                    return;
                }
                String targetPluginDir = String.valueOf(LibraryProcessor.getInstance().getLibraryRootPath().getAbsolutePath()) + File.separator + NetUtil.decodedFileUrl((String)elementURI.segment(0));
                ContentResourceScanner scanner = new ContentResourceScanner(new File(targetPluginDir));
                scanner.setTargetRootPath(new File(targetPluginDir));
                String contentPath = ResourceHelper.getElementPath((MethodElement)elementToProcess);
                if (contentPath.length() == 0) {
                    LibraryPlugin.getDefault().getLogger().logWarning(LibraryResources.formatString("Library.CopyAttachmentsToNewLocation.log.noContentPath", new Object[]{elementToProcess.getName()}));
                    return;
                }
                String oldContentPath = contentPath.replaceFirst(UmaUtil.getMethodPlugin((EObject)elementToProcess).getName(), this.lastOldPlugin.getName());
                Iterator iter = elementToProcess.eClass().getEAllAttributes().iterator();
                while (iter.hasNext()) {
                    String newContent;
                    String content;
                    EAttribute attrib = (EAttribute)iter.next();
                    Object o = elementToProcess.eGet((EStructuralFeature)attrib);
                    if (!(o instanceof String) || (content = (String)o).length() <= 0 || (newContent = scanner.resolveResourcesPlugin(content, contentPath, oldContentPath)) == null || newContent.trim().length() == 0 || content.equals(newContent)) continue;
                    elementToProcess.eSet((EStructuralFeature)attrib, (Object)newContent);
                    this.modifiedResourceSet.add(elementToProcess.eResource());
                }
                if (elementToProcess instanceof GuidanceDescription) {
                    String attachmentString = ((GuidanceDescription)elementToProcess).getAttachments();
                    List attachmentList = TngUtil.convertTemplateAttachmentsToList((String)attachmentString);
                    iter = attachmentList.iterator();
                    while (iter.hasNext()) {
                        String attachment = (String)iter.next();
                        if (attachment == null || attachment.trim().length() <= 0) continue;
                        try {
                            File srcContentPath = new File(LibraryProcessor.getInstance().getLibraryRootPath().getAbsolutePath(), oldContentPath);
                            File srcFile = new File(srcContentPath, attachment);
                            File tgtContentPath = new File(LibraryProcessor.getInstance().getLibraryRootPath().getAbsolutePath(), contentPath);
                            File tgtFile = new File(tgtContentPath, attachment);
                            if (tgtFile.exists()) continue;
                            FileUtil.copyfile((File)srcFile, (File)tgtFile);
                        }
                        catch (IOException ex) {
                            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
                        }
                    }
                }
            }
        }
        TreeIterator iter = e.eAllContents();
        while (iter.hasNext()) {
            EObject child = (EObject)iter.next();
            this.HandleAttachmentsPlugin(child);
        }
    }

    public static void copyAttachmentsLibrary(String oldLibDir, String newLibDir, List xmiList, IProgressMonitor monitor) {
        if (xmiList == null) {
            xmiList = ImportExportUtil.fileList(new File(newLibDir), "xmi");
        }
        if (monitor != null) {
            monitor.subTask(LibraryResources.getString("Library.copyingAttachmentsTask.name"));
        }
        Iterator iter = xmiList.iterator();
        while (iter.hasNext()) {
            File xmiFile;
            if (monitor != null) {
                monitor.worked(1);
            }
            if (!(xmiFile = (File)iter.next()).exists()) continue;
            SAXParserXMI parser = new SAXParserXMI(null);
            parser.parse(xmiFile.getAbsolutePath());
            ContentResourceScanner scanner = new ContentResourceScanner(new File(oldLibDir));
            scanner.setTargetRootPath(new File(newLibDir));
            CopyAttachmentsToNewLocation.HandleAttachments(parser.xmiMap, scanner, xmiFile.getParent().substring(newLibDir.length()));
        }
    }

    private static void HandleAttachments(HashMap eMap, ContentResourceScanner scanner, String contentPath) {
        String content = SAXParserXMI.getElementContent(eMap);
        if (content != null) {
            scanner.resolveResources(content, contentPath);
        }
        Iterator iter = ((ArrayList)eMap.get("children")).iterator();
        while (iter.hasNext()) {
            HashMap childMap = (HashMap)iter.next();
            CopyAttachmentsToNewLocation.HandleAttachments(childMap, scanner, contentPath);
        }
    }
}

