/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import com.ibm.uma.BreakdownElement;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.MethodUnit;
import com.ibm.uma.NamedElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.SupportingMaterial;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;

public class LibraryUtil {
    public static String checkPluginName(MethodPlugin plugin, String newName) {
        MethodLibrary lib = LibraryProcessor.getInstance().getLibrary();
        return IValidatorFactory.INSTANCE.createNameValidator((Object)lib, (NamedElement)plugin).isValid(newName);
    }

    public static boolean selectable(EObject element) {
        return element instanceof MethodLibrary || element instanceof MethodPlugin || element instanceof MethodPackage;
    }

    public static EObject getSelectable(EObject element) {
        if (element instanceof BreakdownElement) {
            ProcessPackage pkg = (ProcessPackage)element.eContainer();
            if (pkg instanceof ProcessComponent) {
                return pkg;
            }
            if (pkg != null) {
                return pkg.eContainer();
            }
            return null;
        }
        EObject parent = element;
        while (parent != null && !LibraryUtil.selectable(parent)) {
            parent = parent.eContainer();
        }
        return parent;
    }

    public static MethodPlugin getMethodPlugin(EObject element) {
        return UmaUtil.getMethodPlugin((EObject)element);
    }

    public static String getName(Object element) {
        if (element == null) {
            return LibraryResources.getString("Library.unknown.text");
        }
        if (element instanceof MethodElement) {
            return LibraryUtil.getFullName((MethodElement)element);
        }
        return element.toString();
    }

    public static String getFullName(MethodElement element) {
        if (LibraryUtil.selectable((EObject)element)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[").append(element.getName()).append("]");
            MethodElement parent = element;
            while ((parent = (MethodElement)parent.eContainer()) != null) {
                if (parent instanceof MethodLibrary) break;
                buffer.insert(0, "[" + parent.getName() + "].");
            }
            return buffer.toString();
        }
        return element.getName();
    }

    public static String getTypeName(MethodElement element) {
        return element == null ? "" : String.valueOf(element.getType().getName()) + ":" + element.getName();
    }

    public static List getMethodPlugins(MethodLibrary library) {
        ArrayList<EObject> items = new ArrayList<EObject>();
        EList elements = library.eContents();
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                EObject element = (EObject)it.next();
                if (!(element instanceof MethodPlugin)) continue;
                items.add(element);
            }
        }
        return items;
    }

    public static List getMethodPluginGuids(MethodLibrary library) {
        ArrayList<String> items = new ArrayList<String>();
        List elements = library.getMethodPlugins();
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                MethodPlugin element = (MethodPlugin)it.next();
                items.add(element.getGuid());
            }
        }
        return items;
    }

    public static MethodPlugin getMethodPlugin(MethodLibrary library, String pluginGuid) {
        if (pluginGuid == null) {
            return null;
        }
        List elements = library.getMethodPlugins();
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                MethodPlugin element = (MethodPlugin)it.next();
                if (!pluginGuid.equals(element.getGuid())) continue;
                return element;
            }
        }
        return null;
    }

    public static List getMethodPackages(MethodElement element) {
        ArrayList<EObject> items = new ArrayList<EObject>();
        TreeIterator it = element.eAllContents();
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            if (!(e instanceof MethodPackage)) continue;
            items.add(e);
        }
        return items;
    }

    public static Object unwrap(Object obj) {
        return TngUtil.unwrap((Object)obj);
    }

    public static Command unwrap(Command cmd) {
        return TngUtil.unwrap((Command)cmd);
    }

    public static void detachFromResource(MethodLibrary importLibraty) {
        ResourceSet resSet = null;
        Resource res = importLibraty.eResource();
        if (res != null) {
            resSet = res.getResourceSet();
        }
        if (resSet != null) {
            TreeIterator it = resSet.getAllContents();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof MultiResourceEObject)) continue;
                ((MultiResourceEObject)obj).eSetResource(null);
            }
        }
    }

    public static void loadAll(MethodLibrary lib) {
        TreeIterator iter = lib.eAllContents();
        while (iter.hasNext()) {
            try {
                EObject element = (EObject)iter.next();
                Iterator iterator = element.eCrossReferences().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            catch (Exception e) {
                LibraryEditPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public static void saveAll(MethodLibrary lib) {
        try {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)lib.eResource().getResourceSet();
            resourceSet.save(LibraryProcessor.getInstance().getSaveOptions(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MethodLibrary loadLibrary(String libraryPath) throws Exception {
        MultiFileResourceSetImpl resourceSet = new MultiFileResourceSetImpl();
        return resourceSet.loadLibrary(libraryPath);
    }

    public static File getLibraryRootPath(MethodLibrary lib) {
        Resource res = lib.eResource();
        if (res == null) {
            return null;
        }
        URI uri = res.getURI();
        String path = uri.toFileString();
        File f = new File(path);
        return f.getParentFile();
    }

    public static List getAllPackages(MethodPlugin plugin) {
        ArrayList allPkgs = new ArrayList();
        List pkgs = plugin.getMethodPackages();
        allPkgs.addAll(pkgs);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)it.next(), allPkgs);
        }
        return allPkgs;
    }

    public static void getAllChildPackages(MethodPackage pkg, List result) {
        List pkgs = pkg.getChildPackages();
        result.addAll(pkgs);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)it.next(), result);
        }
    }

    public static List getAssociatedConfigurations(MethodPlugin plugin) {
        ArrayList<MethodConfiguration> allConfigs = new ArrayList<MethodConfiguration>();
        List configs = (List)((MultiResourceEObject)plugin).getOppositeFeatureValue(AssociationHelper.MethodPlugin_MethodConfigurations);
        LibraryUtil.addUniqueItems(configs, allConfigs);
        List pkgs = LibraryUtil.getAllPackages(plugin);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            MultiResourceEObject o = (MultiResourceEObject)it.next();
            configs = (List)o.getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations);
            LibraryUtil.addUniqueItems(configs, allConfigs);
        }
        List procs = TngUtil.getAllProcesses((MethodPlugin)plugin);
        Iterator it2 = procs.iterator();
        while (it2.hasNext()) {
            Process p = (Process)it2.next();
            MethodConfiguration c = p.getDefaultContext();
            if (c != null && !allConfigs.contains(c)) {
                allConfigs.add(c);
            }
            LibraryUtil.addUniqueItems(p.getValidContext(), allConfigs);
        }
        return allConfigs;
    }

    private static void addUniqueItems(List from, List to) {
        if (from == null || to == null || from.size() == 0) {
            return;
        }
        Iterator it = from.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (to.contains(o)) continue;
            to.add(o);
        }
    }

    public static void validateMethodConfiguration(MethodConfiguration config) {
        List plugins = config.getMethodPluginSelection();
        List pkgSels = config.getMethodPackageSelection();
        Iterator itp = plugins.iterator();
        while (itp.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)itp.next();
            List pkgs = TngUtil.getAllSystemPackages((MethodPlugin)plugin);
            Iterator it = pkgs.iterator();
            while (it.hasNext()) {
                Object pkg = it.next();
                if (pkgSels.contains(pkg)) continue;
                pkgSels.add(pkg);
            }
        }
    }

    public static SupportingMaterial getCopyright(MethodElement element) {
        MethodPlugin p;
        SupportingMaterial sm = null;
        if (element instanceof MethodUnit) {
            sm = ((MethodUnit)element).getCopyrightStatement();
        } else if (element instanceof DescribableElement) {
            sm = ((DescribableElement)element).getPresentation().getCopyrightStatement();
        }
        if (sm == null && (p = LibraryUtil.getMethodPlugin((EObject)element)) != null) {
            sm = p.getCopyrightStatement();
        }
        return sm;
    }

    public static Collection getContainedElements(Object container, Collection elements) {
        if (container instanceof TransientGroupItemProvider) {
            container = ((TransientGroupItemProvider)container).getTarget();
        }
        ArrayList contained = new ArrayList();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof EObject) || !UmaUtil.isContainedBy((EObject)((EObject)element), (Object)container)) continue;
            contained.add(element);
        }
        return contained;
    }
}

