/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.category;

import com.ibm.uma.ContentCategory;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.RoleSet;
import com.ibm.uma.RoleSetGrouping;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.epf.library.edit.category.InheritedCategoryPackageListener;
import org.eclipse.epf.library.edit.util.TngUtil;

public class InheritedRoleSetPackageListener
extends InheritedCategoryPackageListener {
    public InheritedRoleSetPackageListener(ContentPackage pkg) {
        super(pkg);
    }

    public boolean isEmpty(ContentCategory element) {
        if (element instanceof RoleSetGrouping) {
            Iterator iter = ((RoleSetGrouping)element).getRoleSets().iterator();
            while (iter.hasNext()) {
                RoleSet category = (RoleSet)iter.next();
                if (category.getVariabilityBasedOnElement() != null && category.getRoles().isEmpty()) continue;
                return false;
            }
            return true;
        }
        if (element instanceof RoleSet) {
            return ((RoleSet)element).getRoles().isEmpty();
        }
        return false;
    }

    public boolean accept(Object obj) {
        return (obj instanceof RoleSetGrouping || obj instanceof RoleSet) && ((ContentCategory)obj).getVariabilityBasedOnElement() == null;
    }

    protected ContentCategory createCategory(ContentCategory targetCategory) {
        if (targetCategory instanceof RoleSetGrouping) {
            return UmaFactory.eINSTANCE.createRoleSetGrouping();
        }
        if (targetCategory instanceof RoleSet) {
            return UmaFactory.eINSTANCE.createRoleSet();
        }
        return null;
    }

    protected void prepareInherited(Collection inheritedList) {
        ArrayList categories = new ArrayList(inheritedList);
        categories.addAll(this.categoryPackage.getContentElements());
        Iterator iter = inheritedList.iterator();
        while (iter.hasNext()) {
            RoleSet element;
            Iterator iterator;
            ContentCategory category = (ContentCategory)iter.next();
            VariabilityElement baseCategory = category.getVariabilityBasedOnElement();
            if (baseCategory instanceof RoleSetGrouping) {
                RoleSetGrouping grouping = (RoleSetGrouping)category;
                iterator = ((RoleSetGrouping)baseCategory).getRoleSets().iterator();
                while (iterator.hasNext()) {
                    element = (RoleSet)iterator.next();
                    grouping.getRoleSets().add(TngUtil.findInherited(categories, (ContentCategory)element));
                }
                continue;
            }
            if (!(baseCategory instanceof RoleSet)) continue;
            RoleSet e = (RoleSet)category;
            iterator = AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)baseCategory)).iterator();
            while (iterator.hasNext()) {
                element = (RoleSetGrouping)iterator.next();
                RoleSetGrouping inherited = (RoleSetGrouping)TngUtil.findInherited(categories, (ContentCategory)element);
                if (inherited == null) continue;
                inherited.getRoleSets().add(e);
            }
        }
    }

    protected void prepareRemove(ContentCategory element) {
        if (element instanceof RoleSet) {
            AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)element)).clear();
        }
    }
}

