/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.ContentCategory;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.CustomCategory;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.util.UmaUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

public class AddToCategoryCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private ContentCategory category;
    private EStructuralFeature feature;
    private MethodElement element;
    private String[] categoryPkgPath;
    private boolean checkForExistingContributor;
    private ContentCategory usedCategory = null;
    private boolean createNewContributor = false;
    private ContentPackage categoryPkg;
    private Collection modifiedResources;
    private Object oldOppositeFeatureValue;

    public AddToCategoryCommand(ContentCategory category, MethodElement element, EStructuralFeature feature, String[] categoryPkgPath, boolean checkForExistingContributor) {
        this.category = category;
        this.feature = feature;
        this.element = element;
        this.categoryPkgPath = categoryPkgPath;
        this.checkForExistingContributor = checkForExistingContributor;
    }

    protected boolean prepare() {
        return UserInteractionHelper.checkModifyOpposite((MethodElement)this.category, this.feature, this.element);
    }

    public String getLabel() {
        return "Add To Category";
    }

    public void execute() {
        MethodPlugin elementPlugin = UmaUtil.getMethodPlugin((EObject)this.element);
        MethodPlugin categoryPlugin = UmaUtil.getMethodPlugin((EObject)this.category);
        if (categoryPlugin != elementPlugin && Misc.isBaseOf(categoryPlugin, elementPlugin)) {
            if (this.category.getVariabilityBasedOnElement() != null) {
                throw new IllegalArgumentException("Could not add element to an extended category that is in a different plug-in: " + this.category);
            }
            if (!this.feature.isMany()) {
                throw new UnsupportedOperationException();
            }
            this.categoryPkg = UmaUtil.findContentPackage((MethodPlugin)elementPlugin, (String[])this.categoryPkgPath);
            ContentCategory contrib = null;
            if (this.checkForExistingContributor) {
                contrib = TngUtil.findContributor(this.categoryPkg, this.category);
            }
            if (contrib == null) {
                this.createNewContributor = true;
            } else {
                this.usedCategory = contrib;
            }
        } else {
            this.usedCategory = this.category;
        }
        this.modifiedResources = new HashSet();
        this.redo();
    }

    public void redo() {
        if (this.createNewContributor) {
            ContentCategory contrib = (ContentCategory)UmaFactory.eINSTANCE.create(this.category.eClass());
            contrib.setName(this.category.getName());
            contrib.setVariabilityBasedOnElement((VariabilityElement)this.category);
            contrib.setVariabilityType(VariabilityType.CONTRIBUTES_LITERAL);
            this.categoryPkg.getContentElements().add(contrib);
            this.usedCategory = contrib;
            if (this.usedCategory instanceof CustomCategory) {
                CustomCategory root = TngUtil.getRootCustomCategory(UmaUtil.getMethodPlugin((EObject)this.usedCategory));
                List list = root.getCategorizedElements();
                list.add(this.usedCategory);
            }
        }
        OppositeFeature oppositeFeature = MultiResourceEObject.getOppositeFeature((EStructuralFeature)this.feature);
        MultiResourceEObject mrEObj = (MultiResourceEObject)this.element;
        this.oldOppositeFeatureValue = mrEObj.getOppositeFeatureMap().get(oppositeFeature);
        if (this.feature.isMany()) {
            Collection collection = (Collection)this.usedCategory.eGet(this.feature);
            if (this.oldOppositeFeatureValue != null && !oppositeFeature.isMany() && this.oldOppositeFeatureValue != this.usedCategory) {
                EObject oldOppVal = (EObject)this.oldOppositeFeatureValue;
                ((Collection)oldOppVal.eGet(this.feature)).remove(this.element);
                if (oldOppVal.eResource() != null) {
                    this.modifiedResources.add(oldOppVal.eResource());
                }
                collection.add(this.element);
            }
            if (!collection.contains(this.element)) {
                collection.add(this.element);
            }
        } else {
            if (this.oldOppositeFeatureValue != null && !oppositeFeature.isMany() && this.oldOppositeFeatureValue != this.usedCategory) {
                EObject oldOppVal = (EObject)this.oldOppositeFeatureValue;
                oldOppVal.eSet(this.feature, null);
                if (oldOppVal.eResource() != null) {
                    this.modifiedResources.add(oldOppVal.eResource());
                }
            }
            if (this.usedCategory != this.oldOppositeFeatureValue) {
                this.usedCategory.eSet(this.feature, (Object)this.element);
            }
        }
        if (this.usedCategory.eResource() != null) {
            this.modifiedResources.add(this.usedCategory.eResource());
        }
    }

    public void undo() {
        OppositeFeature oppositeFeature = MultiResourceEObject.getOppositeFeature((EStructuralFeature)this.feature);
        if (this.feature.isMany()) {
            Collection collection = (Collection)this.usedCategory.eGet(this.feature);
            collection.remove(this.element);
        } else {
            this.usedCategory.eSet(this.feature, null);
        }
        if (!oppositeFeature.isMany() && this.oldOppositeFeatureValue != null && this.oldOppositeFeatureValue != this.usedCategory) {
            EObject oldOppVal = (EObject)this.oldOppositeFeatureValue;
            if (this.feature.isMany()) {
                ((Collection)oldOppVal.eGet(this.feature)).add(this.element);
            } else {
                oldOppVal.eSet(this.feature, (Object)this.element);
            }
        }
        if (this.createNewContributor && TngUtil.isEmpty(this.usedCategory)) {
            EcoreUtil.remove((EObject)this.usedCategory);
            this.usedCategory = null;
        }
    }

    public Collection getAffectedObjects() {
        return Collections.singletonList(this.usedCategory);
    }

    public Collection getModifiedResources() {
        if (this.modifiedResources == null) {
            return Collections.EMPTY_LIST;
        }
        return this.modifiedResources;
    }
}

