/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.Descriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BatchCommand
extends AbstractCommand {
    private Map objectToOldFeatureValuesMap;
    private Map objectToNewFeatureValuesMap;
    private boolean clear;

    public BatchCommand(boolean clear) {
        this.clear = clear;
    }

    public boolean canExecute() {
        return this.objectToNewFeatureValuesMap != null && !this.objectToNewFeatureValuesMap.isEmpty();
    }

    public void execute() {
        if (this.objectToNewFeatureValuesMap == null || this.objectToNewFeatureValuesMap.isEmpty()) {
            return;
        }
        if (this.objectToOldFeatureValuesMap == null) {
            this.objectToOldFeatureValuesMap = new HashMap();
        }
        Iterator iter = this.objectToNewFeatureValuesMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Descriptor desc = (Descriptor)entry.getKey();
            Map featureMap = (Map)entry.getValue();
            Iterator iterator = featureMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                EStructuralFeature feature = (EStructuralFeature)entry.getKey();
                if (feature.isMany()) {
                    if (this.clear) {
                        desc.eSet(feature, entry.getValue());
                        continue;
                    }
                    ((List)desc.eGet(feature)).addAll((Collection)entry.getValue());
                    continue;
                }
                Object oldValue = desc.eGet(feature);
                if (oldValue == entry.getValue()) continue;
                this.saveOldFeatureValue(desc, feature);
                desc.eSet(feature, entry.getValue());
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        EStructuralFeature feature;
        Iterator iterator;
        Map featureMap;
        Descriptor desc;
        Map.Entry entry;
        Iterator iter;
        if (this.objectToNewFeatureValuesMap != null && !this.objectToNewFeatureValuesMap.isEmpty()) {
            iter = this.objectToNewFeatureValuesMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                desc = (Descriptor)entry.getKey();
                featureMap = (Map)entry.getValue();
                iterator = featureMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    feature = (EStructuralFeature)entry.getKey();
                    if (!feature.isMany()) continue;
                    ((List)desc.eGet(feature)).removeAll((Collection)entry.getValue());
                }
            }
        }
        if (this.objectToOldFeatureValuesMap != null && !this.objectToOldFeatureValuesMap.isEmpty()) {
            iter = this.objectToOldFeatureValuesMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                desc = (Descriptor)entry.getKey();
                featureMap = (Map)entry.getValue();
                iterator = featureMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    feature = (EStructuralFeature)entry.getKey();
                    desc.eSet(feature, entry.getValue());
                }
            }
            this.objectToOldFeatureValuesMap.clear();
        }
    }

    public Map getObjectToNewFeatureValuesMap() {
        if (this.objectToNewFeatureValuesMap == null) {
            this.objectToNewFeatureValuesMap = new HashMap();
        }
        return this.objectToNewFeatureValuesMap;
    }

    protected void saveOldFeatureValue(Descriptor desc, EStructuralFeature feature) {
        HashMap featureMap;
        ArrayList value = desc.eGet(feature);
        if (feature.isMany()) {
            value = new ArrayList(value);
        }
        if ((featureMap = (HashMap)this.objectToOldFeatureValuesMap.get(desc)) == null) {
            featureMap = new HashMap();
            this.objectToOldFeatureValuesMap.put(desc, featureMap);
        }
        featureMap.put(feature, value);
    }

    public void dispose() {
        if (this.objectToNewFeatureValuesMap != null) {
            this.objectToNewFeatureValuesMap.clear();
            this.objectToNewFeatureValuesMap = null;
        }
        if (this.objectToOldFeatureValuesMap != null) {
            this.objectToOldFeatureValuesMap.clear();
            this.objectToOldFeatureValuesMap = null;
        }
    }
}

