/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.ContentElement;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.util.UmaUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;

public class MoveInSectionListCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private ContentElement contentElement;
    private SectionList sectionList;
    private List elementsList;
    private ContentElement usedContentElement = null;
    private Collection modifiedResources;
    private static int UP = 1;
    private static int Down = 0;
    private int direction = -1;
    private boolean moved;

    public MoveInSectionListCommand() {
    }

    public MoveInSectionListCommand(ContentElement contentElement, List elementsList, SectionList sectionList, int direction) {
        this.contentElement = contentElement;
        this.sectionList = sectionList;
        this.elementsList = elementsList;
        this.direction = direction;
        this.modifiedResources = new HashSet();
    }

    protected boolean prepare() {
        return true;
    }

    public MoveInSectionListCommand(String label) {
        super(label);
    }

    public MoveInSectionListCommand(String label, String description) {
        super(label, description);
    }

    public Collection getModifiedResources() {
        if (this.contentElement.getPresentation().eResource() != null) {
            this.modifiedResources.add(this.contentElement.getPresentation().eResource());
        }
        return this.modifiedResources;
    }

    public void execute() {
        MethodPlugin elementPlugin;
        MethodPlugin taskPlugin = UmaUtil.getMethodPlugin((EObject)this.contentElement);
        if (taskPlugin != (elementPlugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)this.elementsList.get(0)))) && Misc.isBaseOf(taskPlugin, elementPlugin)) {
            Iterator iter = TngUtil.getContributors((VariabilityElement)this.contentElement);
            while (iter.hasNext()) {
                VariabilityElement ve = (VariabilityElement)iter.next();
                if (!(ve instanceof ContentElement) || UmaUtil.getMethodPlugin((EObject)ve) != elementPlugin) continue;
                this.usedContentElement = (ContentElement)ve;
                break;
            }
        }
        if (this.usedContentElement == null) {
            this.usedContentElement = this.contentElement;
        }
        this.redo();
    }

    public void redo() {
        if (this.usedContentElement == null) {
            return;
        }
        Iterator it = this.elementsList.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            int index = this.sectionList.indexOf(object);
            if (this.direction == UP) {
                if (index > 0) {
                    this.sectionList.move(index - 1, object);
                }
            } else if (this.direction == Down && index < this.sectionList.size()) {
                this.sectionList.move(index + this.elementsList.size(), object);
            }
            this.moved = true;
        }
        this.sectionList.apply();
    }

    public void undo() {
        if (this.moved) {
            Iterator it = this.elementsList.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                int index = this.sectionList.indexOf(object);
                if (this.direction == UP) {
                    if (index < this.sectionList.size()) {
                        this.sectionList.move(index + this.elementsList.size(), object);
                    }
                } else if (this.direction == Down && index > 0) {
                    this.sectionList.move(index - 1, object);
                }
                this.moved = true;
            }
            this.sectionList.apply();
            this.moved = false;
        }
    }

    public Collection getAffectedObjects() {
        return Collections.singletonList(this.usedContentElement);
    }
}

