/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.category.ObjectLinkItemProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.DescriptorUpdateBatchCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public abstract class BSDropCommand
extends AbstractCommand
implements IResourceAwareCommand {
    public static final Set DEFAULT_SYNCH_FEATURES = Collections.unmodifiableSet(new HashSet<EStructuralFeature>(Arrays.asList(UmaPackage.eINSTANCE.getNamedElement_Name(), UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), UmaPackage.eINSTANCE.getTask_OptionalInput(), UmaPackage.eINSTANCE.getTask_MandatoryInput(), UmaPackage.eINSTANCE.getTask_Output(), UmaPackage.eINSTANCE.getTask_Steps(), UmaPackage.eINSTANCE.getTask_PerformedBy(), UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy(), UmaPackage.eINSTANCE.getRole_ResponsibleFor(), UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())));
    public static final Map FEATURE_MAP = new HashMap();
    protected Activity activity;
    protected List dropElements;
    private Set modifiedResources;
    protected List elementsToAddToDefaultConfig;
    private HashSet addedObjects;
    private Process process;
    private boolean addedToDefaultConfig = false;
    protected boolean synchronize = false;
    protected ArrayList taskDescList;
    protected ArrayList taskDescriptorsToUpdate;
    private Map descriptorToOldRefreshableFeaturesMap;
    protected DescriptorUpdateBatchCommand batchCommand;
    private HashMap wpdToOldResponsibleRoleMap;
    private Map taskDescToNewStepsMap;
    protected boolean canceled;
    private MethodConfiguration config;
    protected Set synchFeatures = DEFAULT_SYNCH_FEATURES;
    private CompoundCommand refreshDescriptorsCommand;

    static {
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getNamedElement_Name(), UmaPackage.eINSTANCE.getNamedElement_Name());
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), UmaPackage.eINSTANCE.getDescribableElement_PresentationName());
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getTask_OptionalInput(), UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput());
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getTask_MandatoryInput(), UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput());
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getTask_Output(), UmaPackage.eINSTANCE.getTaskDescriptor_Output());
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getRole_ResponsibleFor(), UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor());
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts());
        FEATURE_MAP.put(UmaPackage.eINSTANCE.getTask_Steps(), UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps());
    }

    public BSDropCommand(Activity activity, List dropElements) {
        this(activity, dropElements, null, null, false);
    }

    public BSDropCommand(Activity activity, List dropElements, boolean synch) {
        this(activity, dropElements, null, null, synch);
    }

    public BSDropCommand(Activity activity, List dropElements, MethodConfiguration config, Set synchFeatures) {
        this(activity, dropElements, config, synchFeatures, true);
    }

    public BSDropCommand(Activity activity, List dropElements, MethodConfiguration config, Set synchFeatures, boolean synch) {
        this.activity = activity;
        this.process = TngUtil.getOwningProcess((BreakdownElement)activity);
        this.synchronize = synch;
        this.config = config;
        this.synchFeatures = synchFeatures == null ? DEFAULT_SYNCH_FEATURES : synchFeatures;
        this.dropElements = dropElements;
    }

    private void prepareDropElements() {
        ArrayList<Object> elements = new ArrayList<Object>();
        this.getMethodConfiguration();
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (element instanceof ObjectLinkItemProvider) {
                element = ((ObjectLinkItemProvider)((Object)element)).getTarget();
            }
            if (elements.contains(element = Providers.getConfigurationApplicator().resolve(element, this.config)) || element instanceof EObject && ((EObject)element).eIsProxy()) continue;
            elements.add(element);
        }
        this.dropElements = elements;
    }

    public MethodConfiguration getMethodConfiguration() {
        if (this.config == null) {
            this.config = TngUtil.getOwningProcess((BreakdownElement)this.activity).getDefaultContext();
        }
        return this.config;
    }

    public void dispose() {
        if (this.dropElements != null) {
            this.dropElements.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        if (this.elementsToAddToDefaultConfig != null) {
            this.elementsToAddToDefaultConfig.clear();
        }
        if (this.addedObjects != null) {
            this.addedObjects.clear();
        }
        if (this.descriptorToOldRefreshableFeaturesMap != null) {
            this.descriptorToOldRefreshableFeaturesMap.clear();
        }
        if (this.taskDescList != null) {
            this.taskDescList.clear();
        }
        if (this.taskDescToNewStepsMap != null) {
            this.taskDescToNewStepsMap.clear();
        }
        if (this.wpdToOldResponsibleRoleMap != null) {
            this.wpdToOldResponsibleRoleMap.clear();
        }
        if (this.taskDescriptorsToUpdate != null) {
            this.taskDescriptorsToUpdate.clear();
        }
        if (this.batchCommand != null) {
            this.batchCommand.dispose();
        }
        this.process = null;
        this.activity = null;
        super.dispose();
    }

    public Collection getModifiedResources() {
        if (this.modifiedResources == null) {
            this.modifiedResources = new HashSet();
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
        }
        return this.modifiedResources;
    }

    private boolean clearDescriptor(Descriptor descriptor) {
        HashSet<EStructuralFeature> excludeFeatures;
        HashSet<EStructuralFeature> excludeSynchFeatures = new HashSet<EStructuralFeature>(DEFAULT_SYNCH_FEATURES);
        excludeSynchFeatures.removeAll(this.synchFeatures);
        if (excludeSynchFeatures.isEmpty()) {
            excludeFeatures = excludeSynchFeatures;
        } else {
            excludeFeatures = new HashSet();
            Iterator iter = excludeSynchFeatures.iterator();
            while (iter.hasNext()) {
                EStructuralFeature feature = BSDropCommand.getDescriptorFeature((EStructuralFeature)iter.next());
                if (feature == null) continue;
                excludeFeatures.add(feature);
            }
        }
        boolean ret = ProcessCommandUtil.clearDescriptor(descriptor, this.descriptorToOldRefreshableFeaturesMap, excludeFeatures);
        if (ret && descriptor instanceof TaskDescriptor) {
            if (this.taskDescriptorsToUpdate == null) {
                this.taskDescriptorsToUpdate = new ArrayList();
            }
            this.taskDescriptorsToUpdate.add(descriptor);
        }
        return ret;
    }

    private static EStructuralFeature getDescriptorFeature(EStructuralFeature linkedElementFeature) {
        return (EStructuralFeature)FEATURE_MAP.get(linkedElementFeature);
    }

    protected boolean preExecute() {
        boolean b;
        this.prepareDropElements();
        boolean bl = b = !this.dropElements.isEmpty();
        if (b) {
            this.batchCommand = new DescriptorUpdateBatchCommand(false, this.synchFeatures, this.config);
        }
        return b;
    }

    private boolean addToDefaultConfiguration() {
        if (this.elementsToAddToDefaultConfig == null) {
            Object element;
            this.elementsToAddToDefaultConfig = new ArrayList();
            Iterator iter = this.dropElements.iterator();
            while (iter.hasNext()) {
                element = iter.next();
                switch (UserInteractionHelper.checkAgainstDefaultConfiguration(this.process, element)) {
                    case 0: {
                        iter.remove();
                        break;
                    }
                    case 2: {
                        this.elementsToAddToDefaultConfig.add(element);
                        break;
                    }
                    case -1: {
                        return false;
                    }
                }
            }
            if (!this.elementsToAddToDefaultConfig.isEmpty()) {
                this.addedObjects = new HashSet();
                iter = this.elementsToAddToDefaultConfig.iterator();
                while (iter.hasNext()) {
                    element = (EObject)iter.next();
                    ProcessUtil.addToDefaultConfiguration(this.process, element, this.addedObjects);
                }
                if (!this.addedObjects.isEmpty()) {
                    this.getModifiedResources().add(this.process.getDefaultContext().eResource());
                }
                this.addedToDefaultConfig = true;
            }
        }
        return true;
    }

    public void execute() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                if (!BSDropCommand.this.synchronize && BSDropCommand.this.addToDefaultConfiguration() && BSDropCommand.this.preExecute()) {
                    BSDropCommand.this.redo();
                }
            }
        });
    }

    public void redo() {
        try {
            if (!this.synchronize && !this.addedToDefaultConfig) {
                this.addToDefaultConfiguration();
            }
            this.doExecute();
            this.updateDescriptors();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            throw e;
        }
    }

    protected void updateDescriptors() {
        if (this.synchronize) {
            this.clearDescriptors();
        }
        this.batchCommand.execute();
        if (this.refreshDescriptorsCommand != null) {
            this.refreshDescriptorsCommand.execute();
        }
        this.updateTaskDescriptors();
        this.setResponsibleRole();
    }

    protected void undoUpdateDescriptors() {
        this.undoSetResponsibleRole();
        this.undoUpdateTaskDescriptors();
        this.batchCommand.undo();
        if (this.refreshDescriptorsCommand != null) {
            this.refreshDescriptorsCommand.undo();
        }
        if (this.synchronize) {
            this.undoClearDescriptors();
        }
    }

    private void clearDescriptors() {
        if (this.descriptorToOldRefreshableFeaturesMap == null) {
            this.descriptorToOldRefreshableFeaturesMap = new HashMap();
            if (!this.batchCommand.getDescriptorsToRefresh().isEmpty()) {
                Iterator iter = this.batchCommand.getDescriptorsToRefresh().iterator();
                while (iter.hasNext()) {
                    this.clearDescriptor((Descriptor)iter.next());
                }
            }
        }
    }

    private void updateTaskDescriptors() {
        if (this.taskDescriptorsToUpdate != null && this.synchFeatures.contains(UmaPackage.eINSTANCE.getTask_Steps())) {
            if (this.taskDescToNewStepsMap == null) {
                this.taskDescToNewStepsMap = new HashMap();
            }
            IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
            Iterator iter = this.taskDescriptorsToUpdate.iterator();
            while (iter.hasNext()) {
                TaskDescriptor taskDesc = (TaskDescriptor)iter.next();
                Task task = taskDesc.getTask();
                if (task == null || task.eIsProxy()) continue;
                List steps = (List)configApplicator.getReference(task.getPresentation(), (MethodElement)task, UmaPackage.eINSTANCE.getContentDescription_Sections(), this.config);
                ArrayList newSteps = new ArrayList();
                taskDesc.getSelectedSteps().retainAll(steps);
                Iterator iter1 = steps.iterator();
                while (iter1.hasNext()) {
                    Object step = iter1.next();
                    if (taskDesc.getSelectedSteps().contains(step)) continue;
                    newSteps.add(step);
                }
                if (newSteps.isEmpty()) continue;
                taskDesc.getSelectedSteps().addAll(newSteps);
                this.taskDescToNewStepsMap.put(taskDesc, newSteps);
            }
        }
    }

    private void undoUpdateTaskDescriptors() {
        if (this.taskDescToNewStepsMap != null) {
            Iterator iter = this.taskDescToNewStepsMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                TaskDescriptor taskDesc = (TaskDescriptor)entry.getKey();
                taskDesc.getSelectedSteps().removeAll((Collection)entry.getValue());
            }
        }
    }

    private void setResponsibleRole() {
        if (!this.synchFeatures.contains(UmaPackage.eINSTANCE.getRole_ResponsibleFor())) {
            return;
        }
        if (this.wpdToOldResponsibleRoleMap == null) {
            this.wpdToOldResponsibleRoleMap = new HashMap();
        }
        List brElements = this.activity.getBreakdownElements();
        ArrayList wpDescList = new ArrayList();
        ArrayList roleDescriptors = new ArrayList();
        Iterator itor = brElements.iterator();
        while (itor.hasNext()) {
            Object obj = itor.next();
            if (obj instanceof WorkProductDescriptor) {
                wpDescList.add(obj);
                continue;
            }
            if (!(obj instanceof RoleDescriptor)) continue;
            roleDescriptors.add(obj);
        }
        itor = roleDescriptors.iterator();
        while (itor.hasNext()) {
            RoleDescriptor roleDesc = (RoleDescriptor)itor.next();
            Role role = roleDesc.getRole();
            if (role == null) continue;
            List responsibleWorkProducts = (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)role, UmaPackage.eINSTANCE.getRole_ResponsibleFor(), this.config);
            int j = wpDescList.size() - 1;
            while (j > -1) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)wpDescList.get(j);
                if (responsibleWorkProducts.contains(wpDesc.getWorkProduct()) && wpDesc.getResponsibleRole() != roleDesc) {
                    this.wpdToOldResponsibleRoleMap.put(wpDesc, wpDesc.getResponsibleRole());
                    wpDesc.setResponsibleRole(roleDesc);
                }
                --j;
            }
        }
    }

    public void undo() {
        if (this.addedObjects != null && !this.addedObjects.isEmpty()) {
            MethodConfiguration config = this.process.getDefaultContext();
            Iterator iter = this.addedObjects.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element instanceof MethodPlugin) {
                    config.getMethodPluginSelection().remove(element);
                    continue;
                }
                if (!(element instanceof MethodPackage)) continue;
                config.getMethodPackageSelection().remove(element);
            }
            this.addedToDefaultConfig = false;
        }
        this.undoUpdateDescriptors();
        this.doUndo();
    }

    private void undoClearDescriptors() {
        if (this.descriptorToOldRefreshableFeaturesMap != null) {
            Iterator iter = this.descriptorToOldRefreshableFeaturesMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Descriptor desc = (Descriptor)entry.getKey();
                Map featureMap = (Map)entry.getValue();
                Iterator iterator = featureMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    desc.eSet((EStructuralFeature)entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private void undoSetResponsibleRole() {
        if (this.wpdToOldResponsibleRoleMap != null && !this.wpdToOldResponsibleRoleMap.isEmpty()) {
            Iterator iter = this.wpdToOldResponsibleRoleMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                WorkProductDescriptor wpd = (WorkProductDescriptor)entry.getKey();
                wpd.setResponsibleRole((RoleDescriptor)entry.getValue());
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    protected abstract void doExecute();

    protected abstract void doUndo();

    public static interface IExecutor {
        public boolean preExecute();

        public void doExcecute();

        public void doUndo();
    }
}

