/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;

public class WBSDropCommand
extends BSDropCommand {
    private ArrayList roleDescList;
    private ArrayList wpDescList;
    private HashMap wpDescToDeliverableParts;
    private HashMap wpdToDeliverableDescriptorMap;
    private HashMap roleDescTeamProfileMap;
    private BSDropCommand.IExecutor executor;

    public WBSDropCommand(Activity act, List tasks) {
        super(act, tasks);
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof Task) continue;
            iter.remove();
        }
    }

    public WBSDropCommand(Activity activity, List dropElements, boolean synch) {
        super(activity, dropElements, synch);
    }

    public WBSDropCommand(Activity activity, List dropElements, MethodConfiguration config, Set synchFeatures) {
        super(activity, dropElements, config, synchFeatures);
    }

    public BSDropCommand.IExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new Executor();
        }
        return this.executor;
    }

    protected boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        return this.getExecutor().preExecute();
    }

    protected void doExecute() {
        this.executor.doExcecute();
        this.getModifiedResources().add(this.activity.eResource());
    }

    public Collection getAffectedObjects() {
        if (this.taskDescList != null) {
            return this.taskDescList;
        }
        return super.getAffectedObjects();
    }

    protected void doUndo() {
        this.executor.doUndo();
    }

    public void dispose() {
        if (this.roleDescList != null) {
            this.roleDescList.clear();
        }
        if (this.roleDescTeamProfileMap != null) {
            this.roleDescTeamProfileMap.clear();
        }
        if (this.wpDescList != null) {
            this.wpDescList.clear();
        }
        if (this.wpDescToDeliverableParts != null) {
            this.wpDescToDeliverableParts.clear();
        }
        if (this.wpdToDeliverableDescriptorMap != null) {
            this.wpdToDeliverableDescriptorMap.clear();
        }
        super.dispose();
    }

    private class Executor
    implements BSDropCommand.IExecutor {
        Executor() {
        }

        public boolean preExecute() {
            WBSDropCommand.this.taskDescList = new ArrayList();
            WBSDropCommand.this.roleDescList = new ArrayList();
            WBSDropCommand.this.wpDescList = new ArrayList();
            WBSDropCommand.this.wpDescToDeliverableParts = new HashMap();
            WBSDropCommand.this.wpdToDeliverableDescriptorMap = new HashMap();
            Set descriptorsToRefresh = WBSDropCommand.this.synchronize ? WBSDropCommand.this.batchCommand.getDescriptorsToRefresh() : null;
            int i = 0;
            while (i < WBSDropCommand.this.dropElements.size()) {
                Task task = (Task)WBSDropCommand.this.dropElements.get(i);
                TaskDescriptor desc = ProcessCommandUtil.createTaskDescriptor(task, WBSDropCommand.this.activity, WBSDropCommand.this.roleDescList, WBSDropCommand.this.wpDescList, WBSDropCommand.this.wpDescToDeliverableParts, WBSDropCommand.this.wpdToDeliverableDescriptorMap, descriptorsToRefresh, WBSDropCommand.this.batchCommand.getObjectToNewFeatureValuesMap(), WBSDropCommand.this.getMethodConfiguration(), WBSDropCommand.this.synchFeatures);
                if (desc != null) {
                    WBSDropCommand.this.taskDescList.add(desc);
                }
                ++i;
            }
            return !WBSDropCommand.this.taskDescList.isEmpty() || !WBSDropCommand.this.roleDescList.isEmpty() || !WBSDropCommand.this.wpDescList.isEmpty() || !WBSDropCommand.this.wpDescToDeliverableParts.isEmpty() || !WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty() || WBSDropCommand.this.batchCommand.canExecute();
        }

        public void doExcecute() {
            Map.Entry entry;
            Iterator iter;
            if (!WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty()) {
                iter = WBSDropCommand.this.wpdToDeliverableDescriptorMap.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                    if (deliverable.getDeliverableParts().contains(entry.getKey())) continue;
                    try {
                        deliverable.getDeliverableParts().add(entry.getKey());
                    }
                    catch (Exception e) {
                        LibraryEditPlugin.INSTANCE.log("WBSDropCommand::doExecute - Adding deliverable part to deliverable" + e);
                    }
                }
            }
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.taskDescList);
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.roleDescList);
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.wpDescList);
            if (!WBSDropCommand.this.wpDescToDeliverableParts.isEmpty()) {
                iter = WBSDropCommand.this.wpDescToDeliverableParts.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                    wpDesc.getDeliverableParts().addAll((Collection)entry.getValue());
                }
            }
            if (WBSDropCommand.this.roleDescTeamProfileMap == null) {
                WBSDropCommand.this.roleDescTeamProfileMap = new HashMap();
                iter = WBSDropCommand.this.roleDescList.iterator();
                while (iter.hasNext()) {
                    RoleDescriptor roleDesc = (RoleDescriptor)iter.next();
                    TeamProfile teamProfile = UserInteractionHelper.getTeam(WBSDropCommand.this.activity, roleDesc.getRole());
                    if (teamProfile == null) continue;
                    WBSDropCommand.this.roleDescTeamProfileMap.put(roleDesc, teamProfile);
                }
            }
            iter = WBSDropCommand.this.roleDescTeamProfileMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                TeamProfile team = (TeamProfile)entry.getValue();
                team.getTeamRoles().add(entry.getKey());
            }
            ProcessPackage pkg = (ProcessPackage)WBSDropCommand.this.activity.eContainer();
            if (pkg != null) {
                pkg.getProcessElements().addAll(WBSDropCommand.this.taskDescList);
                pkg.getProcessElements().addAll(WBSDropCommand.this.roleDescList);
                pkg.getProcessElements().addAll(WBSDropCommand.this.wpDescList);
            }
        }

        public void doUndo() {
            Map.Entry entry;
            Iterator iter;
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.wpDescList);
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.roleDescList);
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.taskDescList);
            if (!WBSDropCommand.this.wpDescToDeliverableParts.isEmpty()) {
                iter = WBSDropCommand.this.wpDescToDeliverableParts.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                    wpDesc.getDeliverableParts().removeAll((Collection)entry.getValue());
                }
            }
            if (!WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty()) {
                iter = WBSDropCommand.this.wpdToDeliverableDescriptorMap.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                    deliverable.getDeliverableParts().remove(entry.getKey());
                }
            }
            iter = WBSDropCommand.this.roleDescTeamProfileMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                TeamProfile team = (TeamProfile)entry.getValue();
                team.getTeamRoles().remove(entry.getKey());
            }
            ProcessPackage pkg = (ProcessPackage)WBSDropCommand.this.activity.eContainer();
            if (pkg != null) {
                pkg.getProcessElements().removeAll(WBSDropCommand.this.taskDescList);
                pkg.getProcessElements().removeAll(WBSDropCommand.this.roleDescList);
                pkg.getProcessElements().removeAll(WBSDropCommand.this.wpDescList);
            }
        }
    }
}

