/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.ui;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.NamedElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessContribution;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.ProcessPlanningTemplate;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.UmaUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewProcessComponentDialog
extends Dialog {
    private Composite area;
    private Text ctrl_name;
    private ComboViewer configComboViewer;
    private MethodConfiguration[] availableConfigurations;
    private ProcessComponent newProcComp;
    private ComboViewer processComboViewer;
    private Process[] availableBaseProcesses;
    private MethodPlugin currentPlugin;
    private CheckboxTableViewer processTableViewer;
    private static final Collection ECLASS = new HashSet();
    private IValidator validator;

    static {
        ECLASS.add(UmaPackage.eINSTANCE.getProcessComponent());
    }

    public NewProcessComponentDialog(Shell parent, MethodConfiguration[] availableConfigurations, ProcessComponent newComp, Process[] availableBaseProcesses, MethodPlugin currentPlugin, ProcessPackage owner) {
        super(parent);
        this.availableConfigurations = availableConfigurations;
        this.newProcComp = newComp;
        this.availableBaseProcesses = availableBaseProcesses;
        this.currentPlugin = currentPlugin;
        this.validator = IValidatorFactory.INSTANCE.createNameValidator((Object)owner, (NamedElement)this.newProcComp);
    }

    protected Control createDialogArea(Composite parent) {
        this.area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.area.setLayout((Layout)gridLayout);
        this.area.setLayoutData((Object)new GridData());
        Label nameLabel = new Label(this.area, 0);
        nameLabel.setText(LibraryEditResources.getString("LibraryEdit.nameLabel.text"));
        GridData gridData = new GridData(1);
        nameLabel.setLayoutData((Object)gridData);
        this.ctrl_name = new Text(this.area, 2048);
        gridData = new GridData(769);
        gridData.horizontalSpan = 2;
        this.ctrl_name.setLayoutData((Object)gridData);
        Label refModelLabel = new Label(this.area, 0);
        refModelLabel.setText(LibraryEditResources.getString("LibraryEdit.defaultConfigLabel.text"));
        GridData gridData2 = new GridData(1);
        refModelLabel.setLayoutData((Object)gridData2);
        Composite comp = new Composite(this.area, 0);
        GridData gridData3 = new GridData(769);
        gridData3.horizontalSpan = 2;
        comp.setLayoutData((Object)gridData3);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        this.configComboViewer = new ComboViewer(comp, 2056);
        this.configComboViewer.getCombo().setLayoutData((Object)new GridData(769));
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof MethodElement) {
                    return ((MethodElement)element).getName();
                }
                return element.toString();
            }
        };
        this.configComboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.configComboViewer.add((Object[])this.availableConfigurations);
        if (this.newProcComp.getProcess().getDefaultContext() != null) {
            this.configComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.newProcComp.getProcess().getDefaultContext()));
        }
        if (this.newProcComp.getProcess() instanceof ProcessContribution) {
            ProcessContribution procContrib = (ProcessContribution)this.newProcComp.getProcess();
            Label label = new Label(this.area, 0);
            label.setText(LibraryEditResources.getString("LibraryEdit.baseProcessLabel.text"));
            GridData gridData4 = new GridData(1);
            label.setLayoutData((Object)gridData4);
            comp = new Composite(this.area, 0);
            gridData4 = new GridData(769);
            gridData4.horizontalSpan = 2;
            comp.setLayoutData((Object)gridData4);
            GridLayout layout2 = new GridLayout();
            layout2.marginWidth = 0;
            layout2.marginHeight = 0;
            comp.setLayout((Layout)layout2);
            this.processComboViewer = new ComboViewer(comp, 2056);
            this.processComboViewer.getCombo().setLayoutData((Object)new GridData(769));
            LabelProvider processLabelProvider = new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof MethodElement) {
                        MethodElement e = (MethodElement)element;
                        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
                        String name = e.getName();
                        if (plugin == NewProcessComponentDialog.this.currentPlugin) {
                            return name;
                        }
                        return String.valueOf(name) + " (" + plugin.getName() + ')';
                    }
                    return element.toString();
                }
            };
            this.processComboViewer.setLabelProvider((IBaseLabelProvider)processLabelProvider);
            this.processComboViewer.add((Object[])this.availableBaseProcesses);
            if (procContrib.getBaseProcess() != null) {
                this.configComboViewer.setSelection((ISelection)new StructuredSelection((Object)procContrib.getBaseProcess()));
            }
        } else if (this.newProcComp.getProcess() instanceof ProcessPlanningTemplate) {
            Label label = new Label(this.area, 0);
            label.setText(LibraryEditResources.getString("LibraryEdit.basedOnProcessesLabel.text"));
            GridData gridData5 = new GridData(1);
            label.setLayoutData((Object)gridData5);
            comp = new Composite(this.area, 0);
            gridData5 = new GridData(769);
            gridData5.horizontalSpan = 2;
            comp.setLayoutData((Object)gridData5);
            GridLayout layout3 = new GridLayout();
            layout3.marginWidth = 0;
            layout3.marginHeight = 0;
            comp.setLayout((Layout)layout3);
            this.processTableViewer = CheckboxTableViewer.newCheckList((Composite)comp, (int)2048);
            this.processTableViewer.getTable().setLayoutData((Object)new GridData(769));
            ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
            this.processTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
            this.processTableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            this.processTableViewer.add((Object[])this.availableBaseProcesses);
        }
        if (this.newProcComp.getName() != null) {
            this.ctrl_name.setText(this.newProcComp.getName());
        }
        super.getShell().setText(LibraryEditResources.getString("LibraryEdit.newProcessComponentDialog.title"));
        return this.area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        super.getButton(0);
        super.getButton(1);
    }

    protected void okPressed() {
        String name = this.ctrl_name.getText().trim();
        String msg = this.validator.isValid(name);
        if (msg != null) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.createProcess.text"), msg);
            this.ctrl_name.setFocus();
            this.ctrl_name.selectAll();
            return;
        }
        IStructuredSelection selected = (IStructuredSelection)this.configComboViewer.getSelection();
        if (selected.isEmpty()) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.createProcess.text"), LibraryEditResources.getString("LibraryEdit.noDefaultConfigError.msg"));
            return;
        }
        this.newProcComp.setName(name);
        this.newProcComp.getProcess().setName(name);
        this.newProcComp.getProcess().setPresentationName(name);
        this.newProcComp.getProcess().setDefaultContext((MethodConfiguration)((IStructuredSelection)this.configComboViewer.getSelection()).getFirstElement());
        if (this.newProcComp.getProcess() instanceof ProcessContribution) {
            ProcessContribution procContrib = (ProcessContribution)this.newProcComp.getProcess();
            procContrib.setBaseProcess((Process)((IStructuredSelection)this.processComboViewer.getSelection()).getFirstElement());
        } else if (this.newProcComp.getProcess() instanceof ProcessPlanningTemplate) {
            ProcessPlanningTemplate procPlanningTempl = (ProcessPlanningTemplate)this.newProcComp.getProcess();
            procPlanningTempl.getBasedOnProcesses().addAll(Arrays.asList(this.processTableViewer.getCheckedElements()));
        }
        super.okPressed();
    }
}

