/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Constraint;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Process;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.UmaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class Suppression {
    private static final String WBS = "wbs";
    private static final String TBS = "tbs";
    private static final String WPBS = "wpbs";
    private static final String CBS = "cbs";
    private static final Map procToSuppressionMap = new HashMap();
    private static boolean autoInheritIntermediateSuppressionState = true;
    private Process process;
    private Set suppressedExternalElementPaths;
    private boolean modified;
    private Set internalUnsuppressedElements = new HashSet();
    static /* synthetic */ Class class$0;

    public static final void clearCachedSuppressions() {
        procToSuppressionMap.clear();
    }

    public static final void setAutoInheritSuppressionStates(boolean b) {
        autoInheritIntermediateSuppressionState = b;
    }

    public Suppression(Process process) {
        this.process = process;
        this.suppressedExternalElementPaths = this.loadSuppressedElementPaths();
    }

    public Process getProcess() {
        return this.process;
    }

    private Set loadSuppressedElementPaths() {
        Constraint rule = ConstraintManager.getConstraint((MethodElement)this.process, "", false);
        if (rule != null && rule.getBody().length() > 0) {
            HashSet<String> paths = new HashSet<String>();
            StringTokenizer tokens = new StringTokenizer(rule.getBody());
            while (tokens.hasMoreTokens()) {
                paths.add(tokens.nextToken());
            }
            return paths;
        }
        return null;
    }

    private Set getSuppressedExternalElementPaths() {
        if (this.suppressedExternalElementPaths == null) {
            this.suppressedExternalElementPaths = this.loadSuppressedElementPaths();
            if (this.suppressedExternalElementPaths == null) {
                this.suppressedExternalElementPaths = new HashSet();
            }
        }
        return this.suppressedExternalElementPaths;
    }

    public boolean hasSuppressed(Collection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof BreakdownElementWrapperItemProvider ? this.isSuppressed((BreakdownElementWrapperItemProvider)element) : element instanceof BreakdownElement && this.isSuppressed((BreakdownElement)element))) continue;
            return true;
        }
        return false;
    }

    public boolean canSuppress(Collection selection) {
        return this.canDo(selection, true);
    }

    public boolean canReveal(Collection selection) {
        return this.canDo(selection, false);
    }

    private Collection getApplicableItems(Collection selection, boolean suppressed) {
        ArrayList applicableItems = new ArrayList();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
                if (wrapper.isReadOnly()) {
                    if (this.isInSuppressedList(wrapper) == suppressed) continue;
                    applicableItems.add(element);
                    continue;
                }
                Object e = TngUtil.unwrap(wrapper);
                if (!(e instanceof MethodElement) || ((MethodElement)e).getSuppressed() == suppressed) continue;
                applicableItems.add(element);
                continue;
            }
            if (!(element instanceof MethodElement) || ((MethodElement)element).getSuppressed() == suppressed) continue;
            applicableItems.add(element);
        }
        return applicableItems;
    }

    public static boolean isValid(Object element) {
        BreakdownElement obj = null;
        if (element instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
            if (wrapper.isRollupChild()) {
                return false;
            }
            obj = (BreakdownElement)TngUtil.unwrap(wrapper);
        } else if (element instanceof BreakdownElement) {
            obj = (BreakdownElement)element;
        }
        return !(obj instanceof RoleDescriptor) && !(obj instanceof WorkProductDescriptor) || obj.getSuperActivities() != null && !obj.getSuperActivities().isEmpty();
    }

    private boolean canDo(Collection selection, boolean suppressed) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!Suppression.isValid(element)) continue;
            if (element instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
                if (wrapper.isReadOnly()) {
                    if (this.isInSuppressedList(wrapper) == suppressed) continue;
                    return true;
                }
                Object e = TngUtil.unwrap(wrapper);
                if (!(e instanceof MethodElement)) continue;
                ((MethodElement)e).getSuppressed().booleanValue();
                continue;
            }
            if (!(element instanceof MethodElement) || ((MethodElement)element).getSuppressed() == suppressed) continue;
            return true;
        }
        return false;
    }

    private boolean __isSuppressed(BreakdownElement e) {
        return Suppression.getSuppressed(e, true, null) != null;
    }

    private static boolean isDirectlySuppressed(MethodElement e) {
        VariabilityElement ve;
        VariabilityType variabilityType;
        Boolean b = e.getSuppressed();
        if (b != null && b.booleanValue()) {
            return true;
        }
        if (e instanceof VariabilityElement && ((variabilityType = (ve = (VariabilityElement)e).getVariabilityType()) == VariabilityType.EXTENDS_LITERAL || variabilityType == VariabilityType.CONTRIBUTES_LITERAL) && ve.getVariabilityBasedOnElement() != null) {
            return Suppression.isDirectlySuppressed((MethodElement)ve.getVariabilityBasedOnElement());
        }
        return false;
    }

    private static BreakdownElement getSuppressed(BreakdownElement e, boolean checkParent, Object top) {
        if (e.getSuppressed().booleanValue()) {
            return e;
        }
        if (checkParent) {
            TeamProfile superTeam;
            BreakdownElement be = e;
            while (be != top && !be.getSuperActivities().isEmpty()) {
                if (!(be = (BreakdownElement)be.getSuperActivities().get(0)).getSuppressed().booleanValue()) continue;
                return be;
            }
            if (e instanceof WorkProductDescriptor) {
                List list;
                Activity act;
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)e;
                WorkProduct wp = wpDesc.getWorkProduct();
                if (wp instanceof Artifact && (act = UmaUtil.getParentActivity((BreakdownElement)e)) != null) {
                    Iterator iter = act.getBreakdownElements().iterator();
                    while (iter.hasNext()) {
                        WorkProductDescriptor wpd;
                        WorkProduct otherWp;
                        Object element = iter.next();
                        if (element == e || !(element instanceof WorkProductDescriptor) || !((otherWp = (wpd = (WorkProductDescriptor)element).getWorkProduct()) instanceof Artifact) || !UmaUtil.isContainedBy((EObject)wp, (Object)otherWp) || !wpd.getSuppressed().booleanValue()) continue;
                        return wpd;
                    }
                }
                if (wpDesc != top && wpDesc.getSuperActivities().isEmpty() && (list = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)wpDesc)).size() == 1) {
                    return Suppression.getSuppressed((BreakdownElement)list.get(0), checkParent, top);
                }
            } else if (e instanceof RoleDescriptor) {
                TeamProfile team;
                List list;
                if (e.getSuperActivities().isEmpty() && (list = AssociationHelper.getTeamProfiles((RoleDescriptor)((RoleDescriptor)e))).size() == 1 && (team = (TeamProfile)list.get(0)) != top && team != null) {
                    return Suppression.getSuppressed((BreakdownElement)team, checkParent, top);
                }
            } else if (e instanceof TeamProfile && e.getSuperActivities().isEmpty() && (superTeam = ((TeamProfile)e).getSuperTeam()) != top && superTeam != null) {
                return Suppression.getSuppressed((BreakdownElement)superTeam, checkParent, top);
            }
        }
        return null;
    }

    public boolean isInSuppressedList(BreakdownElementWrapperItemProvider wrapper) {
        if (this.suppressedExternalElementPaths == null) {
            return false;
        }
        String path = Suppression.getPath(wrapper);
        return this.suppressedExternalElementPaths.contains(path);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper) {
        return this.getSuppressed(wrapper, true);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper, boolean checkBase) {
        return this.getSuppressed(wrapper, checkBase, true, autoInheritIntermediateSuppressionState);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper, boolean checkBase, boolean checkLocal, boolean inheritSuppressionState) {
        return this.getSuppressed(wrapper, checkBase, checkLocal, inheritSuppressionState, true, null);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper, boolean checkBase, boolean checkLocal, boolean inheritSuppressionState, boolean checkParent, Object top) {
        BreakdownElement suppressed;
        BreakdownElement e = (BreakdownElement)TngUtil.unwrap(wrapper);
        if (!wrapper.isReadOnly()) {
            return Suppression.getSuppressed(e, checkParent, top);
        }
        if (checkBase && (suppressed = Suppression.getSuppressed(e, checkParent, top)) != null) {
            return suppressed;
        }
        Object parent = null;
        if (checkLocal) {
            BreakdownElement suppressed2;
            if (this.isInSuppressedList(wrapper)) {
                return e;
            }
            if (checkParent && (parent = wrapper.getParent(wrapper)) instanceof BreakdownElement && parent != top && (suppressed2 = Suppression.getSuppressed((BreakdownElement)parent, checkParent, top)) != null) {
                return suppressed2;
            }
        }
        if (inheritSuppressionState) {
            Process immediateBaseProc;
            Process proc = TngUtil.getOwningProcess(e);
            Activity inheritor = ProcessUtil.getInheritor(wrapper);
            BreakdownElement base = (BreakdownElement)inheritor.getVariabilityBasedOnElement();
            if (base != null && proc != (immediateBaseProc = TngUtil.getOwningProcess(base))) {
                Suppression suppression;
                Object element;
                Object object = inheritor.getVariabilityBasedOnElement();
                ArrayList<BreakdownElement> objects = new ArrayList<BreakdownElement>(ProcessUtil.getParentList(inheritor, wrapper));
                objects.add(e);
                Iterator iter = objects.iterator();
                block2: while (iter.hasNext()) {
                    element = iter.next();
                    AdapterFactory adapterFactory = wrapper.getAdapterFactory();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)clazz);
                    Iterator iterator = adapter.getChildren(object).iterator();
                    while (iterator.hasNext()) {
                        Object child = iterator.next();
                        if (element != TngUtil.unwrap(child)) continue;
                        object = child;
                        continue block2;
                    }
                }
                if (object instanceof BreakdownElementWrapperItemProvider && (element = (suppression = Suppression.getSuppression(immediateBaseProc)).getSuppressed((BreakdownElementWrapperItemProvider)object, false, true, inheritSuppressionState, checkParent, TngUtil.unwrap(object))) != null) {
                    return element;
                }
            }
        }
        if (checkParent) {
            if (parent == null) {
                parent = wrapper.getParent(wrapper);
            }
            if (parent instanceof BreakdownElementWrapperItemProvider && TngUtil.unwrap(parent) != top) {
                return this.getSuppressed((BreakdownElementWrapperItemProvider)parent, checkBase, true, inheritSuppressionState, checkParent, top);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Suppression getSuppression(Process proc) {
        Suppression suppression = (Suppression)procToSuppressionMap.get(proc);
        if (suppression == null) {
            Map map = procToSuppressionMap;
            synchronized (map) {
                suppression = (Suppression)procToSuppressionMap.get(proc);
                if (suppression == null) {
                    suppression = new Suppression(proc);
                    procToSuppressionMap.put(proc, suppression);
                }
            }
        }
        return suppression;
    }

    private boolean __isSuppressed(BreakdownElementWrapperItemProvider wrapper) {
        return this.getSuppressed(wrapper) != null;
    }

    public void saveToModel() {
        if (this.suppressedExternalElementPaths == null) {
            return;
        }
        StringBuffer paths = new StringBuffer();
        Iterator iter = this.suppressedExternalElementPaths.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (!this.isValid(path)) continue;
            paths.append(path).append(' ');
        }
        Constraint rule = ConstraintManager.getConstraint((MethodElement)this.process, "", true);
        rule.setBody(paths.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValid(String path) {
        IConfigurator configurator;
        MethodConfiguration currentConfig;
        block22: {
            URI uri = URI.createURI((String)path);
            String type = uri.scheme();
            ConfigurableComposedAdapterFactory adapterFactory = null;
            if (WBS.equals(type)) {
                adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            } else if (TBS.equals(type)) {
                adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            } else if (WPBS.equals(type)) {
                adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            } else {
                if (!CBS.equals(type)) return false;
                adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            }
            currentConfig = null;
            configurator = null;
            IFilter filter = adapterFactory.getFilter();
            if (filter instanceof IConfigurator) {
                configurator = (IConfigurator)adapterFactory.getFilter();
                currentConfig = configurator.getMethodConfiguration();
                configurator.setMethodConfiguration(this.process.getDefaultContext());
            }
            try {
                String guid = uri.authority();
                if (!this.process.getGuid().equals(guid)) {
                    Object var16_9 = null;
                    if (configurator == null) return false;
                    configurator.setMethodConfiguration(currentConfig);
                    return false;
                }
                Object object = this.process;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)clazz);
                int i = 0;
                while (true) {
                    if (i >= uri.segmentCount()) {
                        break block22;
                    }
                    guid = uri.segment(i);
                    Iterator iter = adapter.getChildren(object).iterator();
                    adapter = null;
                    while (iter.hasNext()) {
                        Object child = iter.next();
                        object = TngUtil.unwrap(child);
                        if (object instanceof MethodElement) {
                            if (!guid.equals(((MethodElement)object).getGuid())) continue;
                            if (child instanceof ITreeItemContentProvider) {
                                adapter = (ITreeItemContentProvider)child;
                                break;
                            }
                            Class<?> clazz3 = class$0;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            adapter = (ITreeItemContentProvider)adapterFactory.adapt(child, (Object)clazz3);
                            break;
                        }
                        ItemProviderAdapter itemProvider = (ItemProviderAdapter)object;
                        MethodElement e = (MethodElement)itemProvider.getTarget();
                        if (!guid.equals(e.getGuid())) continue;
                        adapter = (ITreeItemContentProvider)itemProvider;
                        break;
                    }
                    if (adapter == null) {
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var16_12 = null;
                if (configurator == null) throw throwable;
                configurator.setMethodConfiguration(currentConfig);
                throw throwable;
            }
            Object var16_10 = null;
            if (configurator == null) return false;
            configurator.setMethodConfiguration(currentConfig);
            return false;
        }
        Object var16_11 = null;
        if (configurator == null) return true;
        configurator.setMethodConfiguration(currentConfig);
        return true;
    }

    private boolean reveal(List selection, Collection revealedDescriptors) {
        boolean readOnlyElementAffected = false;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
                MethodElement e = (MethodElement)TngUtil.unwrap(wrapper);
                if (!wrapper.isReadOnly()) {
                    e.setSuppressed(Boolean.FALSE);
                    if (!(e instanceof Descriptor)) continue;
                    revealedDescriptors.add(e);
                    continue;
                }
                String path = Suppression.getPath(wrapper);
                this.getSuppressedExternalElementPaths().remove(path);
                readOnlyElementAffected = true;
                continue;
            }
            if (!(element instanceof MethodElement)) continue;
            ((MethodElement)element).setSuppressed(Boolean.FALSE);
            if (!(element instanceof Descriptor)) continue;
            revealedDescriptors.add(element);
        }
        this.modified = true;
        return readOnlyElementAffected;
    }

    public boolean reveal(List selection) {
        ArrayList revealedDescriptors = new ArrayList();
        boolean ret = this.reveal(selection, revealedDescriptors);
        List descriptorsToReveal = Suppression.getOwnRelatedElements(revealedDescriptors, false);
        if (descriptorsToReveal != null) {
            boolean ret2 = this.reveal(descriptorsToReveal, revealedDescriptors);
            return ret || ret2;
        }
        return ret;
    }

    private static String getViewType(BreakdownElementWrapperItemProvider wrapper) {
        Object e = TngUtil.unwrap(wrapper);
        if (e instanceof WorkBreakdownElement) {
            return WBS;
        }
        if (e instanceof TeamProfile || e instanceof RoleDescriptor) {
            return TBS;
        }
        if (e instanceof WorkProductDescriptor) {
            return WPBS;
        }
        return "";
    }

    private static String getPath(BreakdownElementWrapperItemProvider wrapper) {
        StringBuffer path = new StringBuffer();
        List parentList = ProcessUtil.getParentList(null, wrapper);
        if (!parentList.isEmpty()) {
            Iterator iter = parentList.iterator();
            while (iter.hasNext()) {
                MethodElement e = (MethodElement)iter.next();
                if (e instanceof TaskDescriptor || e instanceof RoleDescriptor) continue;
                path.append('/').append(e.getGuid());
            }
        }
        MethodElement e = (MethodElement)TngUtil.unwrap(wrapper);
        path.append('/').append(e.getGuid());
        String viewType = Suppression.getViewType(wrapper);
        path.insert(0, ":/").insert(0, viewType);
        return path.toString();
    }

    private static List getOwnRelatedElements(Collection changedDescriptors, boolean suppressed) {
        if (!changedDescriptors.isEmpty()) {
            ArrayList<Descriptor> descriptorsToChange = new ArrayList<Descriptor>();
            Iterator iter = new ArrayList(changedDescriptors).iterator();
            while (iter.hasNext()) {
                Descriptor desc = (Descriptor)iter.next();
                EStructuralFeature[] relationships = null;
                if (desc instanceof TaskDescriptor) {
                    relationships = RemoveUnusedDescriptorsCommand.TASK_DESCRIPTOR__RELATIONSHIPS;
                } else if (desc instanceof RoleDescriptor) {
                    relationships = RemoveUnusedDescriptorsCommand.ROLE_DESCRIPTOR__RELATIONSHIPS;
                } else if (desc instanceof WorkProductDescriptor) {
                    relationships = RemoveUnusedDescriptorsCommand.WORK_PRODUCT_DESCRIPTOR__RELATIONSHIPS;
                }
                if (relationships == null) continue;
                int i = 0;
                while (i < relationships.length) {
                    EStructuralFeature feature = relationships[i];
                    if (feature.isMany()) {
                        Iterator iterator = ((Collection)desc.eGet(feature)).iterator();
                        while (iterator.hasNext()) {
                            Descriptor ref = (Descriptor)iterator.next();
                            if (ref.getSuppressed() == suppressed || ProcessUtil.checkDescriptorReferences(changedDescriptors, ref)) continue;
                            descriptorsToChange.add(ref);
                            changedDescriptors.add(ref);
                        }
                    } else {
                        Descriptor ref = (Descriptor)desc.eGet(feature);
                        if (ref.getSuppressed() != suppressed && !ProcessUtil.checkDescriptorReferences(changedDescriptors, ref)) {
                            descriptorsToChange.add(ref);
                            changedDescriptors.add(ref);
                        }
                    }
                    ++i;
                }
            }
            return descriptorsToChange;
        }
        return null;
    }

    public boolean suppress(List selection) {
        ArrayList suppressedDescriptors = new ArrayList();
        boolean ret = this.suppress(selection, suppressedDescriptors);
        List descriptorsToSuppress = Suppression.getOwnRelatedElements(suppressedDescriptors, true);
        if (descriptorsToSuppress != null) {
            ArrayList out = new ArrayList();
            boolean ret2 = this.suppress(descriptorsToSuppress, out);
            if (out.size() != descriptorsToSuppress.size()) {
                LibraryEditPlugin.getDefault().getLogger().logError("Suppression.suppress(List) is buggy.");
            }
            return ret || ret2;
        }
        return ret;
    }

    private boolean suppress(List selection, Collection suppressedDescriptors) {
        boolean readOnlyElementSuppressed = false;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
                if (this.isSuppressed(wrapper)) continue;
                BreakdownElement e = (BreakdownElement)TngUtil.unwrap(wrapper);
                if (!wrapper.isReadOnly()) {
                    e.setSuppressed(Boolean.TRUE);
                    if (!(e instanceof Descriptor)) continue;
                    suppressedDescriptors.add(e);
                    continue;
                }
                String path = Suppression.getPath(wrapper);
                this.getSuppressedExternalElementPaths().add(path);
                readOnlyElementSuppressed = true;
                continue;
            }
            if (!(element instanceof MethodElement)) continue;
            ((MethodElement)element).setSuppressed(Boolean.TRUE);
            if (!(element instanceof Descriptor)) continue;
            suppressedDescriptors.add(element);
        }
        this.modified = true;
        return readOnlyElementSuppressed;
    }

    public boolean hasUnsuppressed(List selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof BreakdownElementWrapperItemProvider ? !this.isSuppressed((BreakdownElementWrapperItemProvider)element) : element instanceof BreakdownElement && !this.isSuppressed((BreakdownElement)element))) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveNeeded() {
        return this.modified;
    }

    public void saveIsDone() {
        this.modified = false;
    }

    public boolean isSuppressed(Object e) {
        if (e == null) {
            return true;
        }
        if (this.internalUnsuppressedElements.contains(e)) {
            return false;
        }
        if (e instanceof BreakdownElementWrapperItemProvider) {
            return this.__isSuppressed((BreakdownElementWrapperItemProvider)e);
        }
        if (e instanceof BreakdownElement) {
            return this.__isSuppressed((BreakdownElement)e);
        }
        Object targetObj = null;
        if (e instanceof WrapperItemProvider) {
            targetObj = ((WrapperItemProvider)e).getValue();
        } else if (e instanceof ItemProviderAdapter) {
            targetObj = ((ItemProviderAdapter)e).getTarget();
        }
        if (targetObj != null && targetObj != e) {
            return this.isSuppressed(targetObj);
        }
        return false;
    }

    public boolean updateSuppressionFromBase(BreakdownElementWrapperItemProvider wrapper) {
        String path = Suppression.getPath(wrapper);
        BreakdownElement e = this.getSuppressed(wrapper, true, false, true, false, null);
        boolean ret = e != null ? this.getSuppressedExternalElementPaths().add(path) : this.getSuppressedExternalElementPaths().remove(path);
        if (ret) {
            this.modified = true;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String checkDuplicateNameAfterReveal(Collection selectionToRevealOrSuppress, AdapterFactory adapterFactory) {
        Collection elementsToReveal = this.getApplicableItems(selectionToRevealOrSuppress, false);
        Iterator iter = elementsToReveal.iterator();
        while (true) {
            Object var15_15;
            Object element;
            block17: {
                String string;
                block16: {
                    ITreeItemContentProvider itemProvider;
                    Object parent;
                    if (!iter.hasNext()) {
                        return null;
                    }
                    element = iter.next();
                    if (element instanceof BreakdownElement) {
                        BreakdownElement be = (BreakdownElement)element;
                        String msg = ProcessUtil.checkBreakdownElementName(adapterFactory, be, be.getName(), this);
                        if (msg != null) {
                            return LibraryEditResources.getString("LibraryEdit.Suppression.nameDuplication");
                        }
                        msg = ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, be, be.getPresentationName(), this);
                        if (msg == null) continue;
                        return LibraryEditResources.getString("LibraryEdit.Suppression.presentationNameDuplication");
                    }
                    Object unwrapped = TngUtil.unwrap(element);
                    if (!(unwrapped instanceof BreakdownElement)) continue;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!((parent = (itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(element, (Object)clazz)).getParent(element)) instanceof BreakdownElement)) continue;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz2);
                    Collection siblings = itemProvider.getChildren(parent);
                    MethodElement linkedElement = null;
                    if (element instanceof Descriptor) {
                        linkedElement = ProcessUtil.getAssociatedElement((Descriptor)element);
                    }
                    try {
                        this.internalUnsuppressedElements.add(element);
                        Iterator iterator = siblings.iterator();
                        while (iterator.hasNext()) {
                            MethodElement otherLinkedElement;
                            BreakdownElement be;
                            Object sibling = iterator.next();
                            if (!(sibling instanceof BreakdownElement) || (be = (BreakdownElement)sibling).getSuppressed().booleanValue() || linkedElement != null && sibling instanceof Descriptor && (otherLinkedElement = ProcessUtil.getAssociatedElement((Descriptor)element)) == linkedElement) continue;
                            String msg = ProcessUtil.checkBreakdownElementName(adapterFactory, be, be.getName(), this);
                            if (msg != null) {
                                String string2 = LibraryEditResources.getString("LibraryEdit.Suppression.nameDuplication");
                                var15_15 = null;
                                this.internalUnsuppressedElements.remove(element);
                                return string2;
                            }
                            msg = ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, be, be.getPresentationName(), this);
                            if (msg == null) continue;
                            string = LibraryEditResources.getString("LibraryEdit.Suppression.presentationNameDuplication");
                            break block16;
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        var15_15 = null;
                        this.internalUnsuppressedElements.remove(element);
                        throw throwable;
                    }
                }
                var15_15 = null;
                this.internalUnsuppressedElements.remove(element);
                return string;
            }
            var15_15 = null;
            this.internalUnsuppressedElements.remove(element);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObjectByPath(String[] guidPath, AdapterFactory adapterFactory) {
        if (guidPath.length == 0 || adapterFactory == null || !guidPath[0].equals(this.process.getGuid())) {
            return null;
        }
        Object object = this.process;
        int len = guidPath.length;
        int i = 1;
        while (true) {
            Iterator iter;
            boolean found;
            block17: {
                Object var11_11;
                if (i >= len) {
                    return object;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)clazz);
                found = false;
                IBSItemProvider rolledUpAdapter = null;
                iter = null;
                try {
                    if (TngUtil.unwrap(object) instanceof Activity) {
                        IBSItemProvider itemProvider;
                        if (adapter instanceof BSActivityItemProvider) {
                            BSActivityItemProvider activityItemProvider = (BSActivityItemProvider)adapter;
                            if (activityItemProvider.isRolledUp()) {
                                activityItemProvider.basicSetRolledUp(false);
                                rolledUpAdapter = activityItemProvider;
                            }
                        } else if (adapter instanceof IBSItemProvider && (itemProvider = (IBSItemProvider)adapter).isRolledUp()) {
                            itemProvider.setRolledUp(false);
                            rolledUpAdapter = itemProvider;
                        }
                    }
                    iter = adapter.getChildren(object).iterator();
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    if (rolledUpAdapter != null) {
                        rolledUpAdapter.setRolledUp(true);
                    }
                    throw throwable;
                }
                {
                    var11_11 = null;
                    if (rolledUpAdapter == null) break block17;
                    rolledUpAdapter.setRolledUp(true);
                }
            }
            while (iter.hasNext()) {
                Object child = iter.next();
                Object e = TngUtil.unwrap(child);
                if (!(e instanceof MethodElement) || !((MethodElement)e).getGuid().equals(guidPath[i])) continue;
                found = true;
                object = child;
                break;
            }
            if (!found) {
                return null;
            }
            ++i;
        }
    }

    public boolean isSuppressed(String[] guidPath, AdapterFactory adapterFactory) throws IllegalArgumentException {
        Object object = this.getObjectByPath(guidPath, adapterFactory);
        if (object == null) {
            throw new IllegalArgumentException("Could not find object with path '" + guidPath + "'");
        }
        return this.isSuppressed(object);
    }

    public static Set getSuppressedItems(Process proc, AdapterFactory[] adapterFactories) {
        HashSet suppressedItems = new HashSet();
        Suppression suppression = new Suppression(proc);
        int i = 0;
        while (i < adapterFactories.length) {
            AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactories[i], (Object)proc);
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!suppression.isSuppressed(item)) continue;
                suppressedItems.add(item);
            }
            ++i;
        }
        return suppressedItems;
    }
}

