/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodUnit;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.TxRecord;
import org.eclipse.epf.resourcemanager.ResourceManager;

public class MultiFileXMISaveImpl
extends XMISaveImpl {
    public static final String SAVE_SEPARATELY_CLASS_SET = "SAVE_SEPARATELY_CLASS_SET";
    public static final String SAVE_ALL = "SAVE_ALL";
    public static final String SAVE_TOGETHER_CLASS_SET = "SAVE_TOGETHER_CLASS_SET";
    public static final String BACK_UP_BEFORE_SAVE = "BACK_UP_BEFORE_SAVE";
    public static final String DISCARD_UNRESOLVED_REFERENCES = "DISCARD_UNRESOLVED_REFERENCES";
    static final String MODIFIED_RESOURCE_SET = "MODIFIED_RESOURCE_SET";
    static final String TX_RECORD = "TX_RECORD";
    public static final String MULTI_FILE = "MULTI_FILE";
    private Set saveSeparatelyClassSet;
    private Set modifiedResources;
    private Map options;
    private TxRecord txRecord;

    public MultiFileXMISaveImpl(XMLHelper helper) {
        super(helper);
    }

    XMLHelper getXMLHelper() {
        return this.helper;
    }

    protected void init(XMLResource resource, Map opts) {
        super.init(resource, opts);
        if (this.escape != null) {
            this.escape = new MyEscape();
        }
        this.saveSeparatelyClassSet = (Set)opts.get(SAVE_SEPARATELY_CLASS_SET);
        this.modifiedResources = (Set)opts.get(MODIFIED_RESOURCE_SET);
        this.txRecord = (TxRecord)opts.get(TX_RECORD);
        opts.get(SAVE_ALL);
        this.options = opts;
        Object resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            resourceSet = new MultiFileResourceSetImpl();
            resourceSet.getResources().add((Object)resource);
        }
    }

    boolean canSaveSeparately(Object obj) {
        if (obj instanceof MethodUnit) {
            return true;
        }
        if (this.saveSeparatelyClassSet == null) {
            return false;
        }
        Iterator iter = this.saveSeparatelyClassSet.iterator();
        while (iter.hasNext()) {
            EClass eCls = (EClass)iter.next();
            if (!eCls.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    private String getUmaHREF(Resource resource, InternalEObject o) {
        if (o.eIsProxy() && o.eProxyURI().scheme().equals("uma")) {
            return o.eProxyURI().toString();
        }
        String href = null;
        if (o instanceof MethodElement) {
            href = this.helper.getHREF((EObject)o);
        }
        if (href == null) {
            return MultiFileSaveUtil.getHREF(resource, o);
        }
        return href;
    }

    protected boolean saveFeatures(EObject o) {
        try {
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)o.eResource();
            if (resource != null) {
                EObject container = o.eContainer();
                InternalEObject internalEObject = (InternalEObject)o;
                if (o instanceof MethodElement && this.canSaveSeparately(o) && container != null) {
                    boolean containsNewFeature = resource == container.eResource();
                    MethodElement e = (MethodElement)o;
                    URI uri = MultiFileSaveUtil.createFileURI((MethodElement)o);
                    if (containsNewFeature) {
                        if (!internalEObject.eIsProxy()) {
                            resource = (MultiFileXMIResourceImpl)MultiFileSaveUtil.save(o, uri, this.options);
                        }
                    } else {
                        MultiFileURIConverter uriConverter;
                        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(container.eResource());
                        if (resMgr != null && resMgr.getResourceDescriptor(e.getGuid()) == null && (uriConverter = (MultiFileURIConverter)resource.getResourceSet().getURIConverter()).findResourceDescriptor(e.getGuid()) == null) {
                            MultiFileSaveUtil.registerWithResourceManager(resMgr, e, resource.getFinalURI());
                        }
                    }
                    String href = this.getUmaHREF((Resource)resource, internalEObject);
                    this.doc.addAttribute("href", href);
                    this.endSaveFeatures(o, 0, null);
                    return true;
                }
                if (o instanceof ResourceManager && this.helper.getResource() != resource) {
                    String href = this.getUmaHREF((Resource)resource, internalEObject);
                    this.doc.addAttribute("href", href);
                    this.endSaveFeatures(o, 0, null);
                    return true;
                }
            }
            return super.saveFeatures(o);
        }
        catch (RuntimeException e) {
            CommonPlugin.INSTANCE.log((Object)e);
            throw e;
        }
    }

    public static class MyEscape
    extends XMLSaveImpl.Escape {
        protected final char[] GREATER = new char[]{'&', 'g', 't', ';'};
        protected final char[] BLANK = new char[0];

        public String convert(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            char ch = '\u0000';
            while (inputLength-- > 0) {
                ch = this.value[pos];
                switch (ch) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '>': {
                        pos = this.replace(pos, this.GREATER, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        public String convertText(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            while (inputLength-- > 0) {
                switch (this.value[pos]) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '>': {
                        pos = this.replace(pos, this.GREATER, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    case '\r': {
                        pos = this.replace(pos, this.BLANK, inputLength);
                        changed = true;
                        break;
                    }
                    case '\n': {
                        pos = this.replace(pos, this.LINE_FEED, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        public String myConvertText(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            while (inputLength-- > 0) {
                switch (this.value[pos]) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '>': {
                        pos = this.replace(pos, this.GREATER, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    case '\n': {
                        pos = this.replace(pos, this.LINE_FEED, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }
    }
}

