/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.ContentDescription;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Guideline;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLPackage;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLRegistry;
import org.eclipse.emf.mapping.ecore2xml.impl.Ecore2XMLRegistryImpl;
import org.eclipse.emf.mapping.ecore2xml.util.Ecore2XMLExtendedMetaData;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIHelperImpl;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.migration.Migrator;
import org.eclipse.epf.persistence.migration.UMA2UMAResourceHandler;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;

public class Migrator {
    public static final String OLD_UMA_NS_URI = "http:///com/ibm/uma.ecore";
    public static final String UMA_NS_URI = "http://www.ibm.com/uma/1.0.2/uma.ecore";
    private ExtendedMetaData[] extendedMetaDatas;
    private UMA2UMAResourceHandler resourceHandler;
    public HashMap oldPathToNewURIMap = new HashMap();
    public Collection anyTypeFeatureValues = new ArrayList();
    static /* synthetic */ Class class$0;

    private static final ExtendedMetaData getExtendedMetaData(String oldNsURI, URI ecore2XMLURI) {
        EPackageRegistryImpl ePackageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        ePackageRegistry.put((Object)oldNsURI, (Object)UmaPackage.eINSTANCE);
        Ecore2XMLRegistryImpl ecore2xmlRegistry = new Ecore2XMLRegistryImpl(Ecore2XMLRegistry.INSTANCE);
        ecore2xmlRegistry.put((Object)oldNsURI, EcoreUtil.getObjectByType((Collection)new ResourceSetImpl().getResource(ecore2XMLURI, true).getContents(), (EClassifier)Ecore2XMLPackage.eINSTANCE.getXMLMap()));
        return new Ecore2XMLExtendedMetaData((EPackage.Registry)ePackageRegistry, (Ecore2XMLRegistry)ecore2xmlRegistry){

            public EClassifier getType(EPackage ePackage, String name) {
                EClassifier type = super.getType(ePackage, name);
                if (type == null) {
                    EList eClassifiers = ePackage.getEClassifiers();
                    int i = 0;
                    int size = eClassifiers.size();
                    while (i < size) {
                        EClassifier eClassifier = (EClassifier)eClassifiers.get(i);
                        if (name.equals(eClassifier.getName())) {
                            return eClassifier;
                        }
                        ++i;
                    }
                }
                return type;
            }
        };
    }

    public Migrator(String[] nsURIs, URI[] ecore2XMLURIs, UMA2UMAResourceHandler resourceHandler) {
        int size = ecore2XMLURIs.length;
        this.extendedMetaDatas = new ExtendedMetaData[size];
        int i = 0;
        while (i < ecore2XMLURIs.length) {
            this.extendedMetaDatas[i] = Migrator.getExtendedMetaData(nsURIs[i], ecore2XMLURIs[i]);
            ++i;
        }
        this.resourceHandler = resourceHandler;
    }

    private static void updateStatus(IProgressMonitor monitor, String msg) {
        if (monitor != null) {
            monitor.setTaskName(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void migrate(String libPath, IProgressMonitor monitor) throws Exception {
        HashSet<String> classNames = new HashSet<String>();
        classNames.add("Technique");
        MigratorResourceSet resourceSet = new MigratorResourceSet();
        int i = 0;
        while (i < this.extendedMetaDatas.length) {
            resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            if (i < 2) {
                resourceSet.getLoadOptions().put("RESOURCE_HANDLER", this.resourceHandler);
            }
            resourceSet.getLoadOptions().put("EXTENDED_META_DATA", this.extendedMetaDatas[i]);
            if (i == 0) {
                this.resourceHandler.savePresentationURIFor(classNames);
            } else {
                this.resourceHandler.savePresentationURIFor(null);
            }
            Migrator.updateStatus(monitor, PersistenceResources.getString("Persistence.loadLibraryTask.name"));
            ((MultiFileResourceSetImpl)resourceSet).loadLibrary(libPath);
            MethodLibrary lib = resourceSet.getMethodLibrary();
            if (lib == null) {
                return;
            }
            Migrator.updateStatus(monitor, PersistenceResources.getString("Persistence.loadResourcesTask.name"));
            TreeIterator iter = lib.eAllContents();
            while (iter.hasNext()) {
                Guideline guideline;
                URI uri;
                EObject element = (EObject)iter.next();
                if (element instanceof Guideline && i > 0 && (uri = this.resourceHandler.getPresentationURI((guideline = (Guideline)element).getGuid())) != null) {
                    ContentDescription presentation = (ContentDescription)((MultiFileResourceSetImpl)resourceSet).getEObject(uri, true);
                    guideline.setPresentation(presentation);
                }
                if (!(element instanceof MethodElement)) continue;
                try {
                    Iterator iterator = element.eCrossReferences().iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                    }
                }
                catch (Exception e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    System.err.println("Error iterate thru cross references of element: " + element);
                }
            }
            if (i == 0) {
                Migrator.migrateProcessContentDescriptions(monitor, lib);
                Migrator.updateStatus(monitor, PersistenceResources.getString("Persistence.moveDataTask.name"));
            }
            if (i < 2) {
                this.resourceHandler.moveData();
                this.resourceHandler.clearMoveInfos();
            }
            if (i == this.extendedMetaDatas.length - 1) {
                Migrator.migrateProcesses(monitor, lib);
                this.restoreReferences(resourceSet);
            }
            Migrator.updateStatus(monitor, PersistenceResources.getString("Persistence.saveLibraryTask.name"));
            resourceSet.save(null, true);
            resourceSet.reset();
            ++i;
        }
        try {
            File resMgrFile = new File(new File(libPath).getParentFile(), "resmgr.xmi");
            if (resMgrFile.exists()) {
                resMgrFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void restoreReferences(MultiFileResourceSetImpl resourceSet) {
        Iterator iter = this.anyTypeFeatureValues.iterator();
        while (iter.hasNext()) {
            AnyTypeFeatureValue element = (AnyTypeFeatureValue)iter.next();
            if (element.ownerId == null || element.valueId == null) continue;
            EObject owner = resourceSet.getEObject(element.ownerId);
            EObject value = resourceSet.getEObject(element.valueId);
            UMA2UMAResourceHandler.setValue(owner, element.feature, value);
        }
        this.anyTypeFeatureValues.clear();
    }

    private static void migrateProcesses(IProgressMonitor monitor, MethodLibrary lib) {
        Migrator.updateStatus(monitor, PersistenceResources.getString("Persistence.fixPresentationNameTask.name"));
        String[][] procPkgPaths = MultiFileResourceSetImpl.PROCESS_PACKAGE_PATHS;
        Iterator iter = lib.getMethodPlugins().iterator();
        while (iter.hasNext()) {
            MethodPackage pkg;
            MethodPlugin plugin = (MethodPlugin)iter.next();
            ArrayList<MethodPackage> procPkgs = new ArrayList<MethodPackage>();
            int j = 0;
            while (j < procPkgPaths.length) {
                pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])procPkgPaths[j]);
                if (pkg != null) {
                    procPkgs.add(pkg);
                }
                ++j;
            }
            Iterator iterator = procPkgs.iterator();
            while (iterator.hasNext()) {
                pkg = (ProcessPackage)iterator.next();
                Iterator iterator1 = pkg.getChildPackages().iterator();
                while (iterator1.hasNext()) {
                    EObject childPkg = (EObject)iterator1.next();
                    if (!(childPkg instanceof ProcessComponent)) continue;
                    Process proc = ((ProcessComponent)childPkg).getProcess();
                    if (proc != null) {
                        Migrator.fixPresentationName((BreakdownElement)proc);
                        continue;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.epf.persistence.migration.Migrator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    String msg = String.valueOf(clazz.getName()) + ": invalid ProcessComponent (with no Process): " + childPkg + "\n  ProcessComponent's resource URI: " + (childPkg.eResource() != null ? childPkg.eResource().getURI() : null) + "\n  Parent package: " + pkg + "\n  Parent package's resource URI: " + (pkg.eResource() != null ? pkg.eResource().getURI() : null);
                    CommonPlugin.INSTANCE.log((Object)msg);
                    System.err.println(msg);
                }
            }
        }
    }

    private static void migrateProcessContentDescriptions(IProgressMonitor monitor, MethodLibrary lib) {
        Migrator.updateStatus(monitor, PersistenceResources.getString("Persistence.migrateContentDescriptionsTask.name"));
        String[][] procPkgPaths = MultiFileResourceSetImpl.PROCESS_PACKAGE_PATHS;
        Iterator iter = lib.getMethodPlugins().iterator();
        while (iter.hasNext()) {
            MethodPackage pkg;
            MethodPlugin plugin = (MethodPlugin)iter.next();
            ArrayList<MethodPackage> procPkgs = new ArrayList<MethodPackage>();
            int j = 0;
            while (j < procPkgPaths.length) {
                pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])procPkgPaths[j]);
                if (pkg != null) {
                    procPkgs.add(pkg);
                }
                ++j;
            }
            Iterator iterator = procPkgs.iterator();
            while (iterator.hasNext()) {
                pkg = (ProcessPackage)iterator.next();
                Iterator iterator1 = pkg.getChildPackages().iterator();
                while (iterator1.hasNext()) {
                    Object childPkg = iterator1.next();
                    if (!(childPkg instanceof ProcessComponent)) continue;
                    Process proc = ((ProcessComponent)childPkg).getProcess();
                    Migrator.migrateContentDescription((BreakdownElement)proc);
                }
            }
        }
    }

    private static void migrateContentDescription(BreakdownElement e) {
        if (ContentDescriptionFactory.hasPresentation((MethodElement)e)) {
            ContentDescription content = e.getPresentation();
            EClass eCls = ContentDescriptionFactory.getContentDescriptionEClass((DescribableElement)e);
            if (eCls != content) {
                ContentDescription newContent = ContentDescriptionFactory.createContentDescription((DescribableElement)e);
                newContent.setMainDescription(content.getMainDescription());
                newContent.setKeyConsiderations(content.getKeyConsiderations());
                newContent.getSections().addAll(content.getSections());
                e.setPresentation(newContent);
            }
        }
        if (e instanceof Activity) {
            Iterator iter = ((Activity)e).getBreakdownElements().iterator();
            while (iter.hasNext()) {
                Migrator.migrateContentDescription((BreakdownElement)iter.next());
            }
        }
    }

    private static void fixPresentationName(BreakdownElement e) {
        if (e.getPresentationName() == null || e.getPresentationName().trim().length() == 0) {
            e.setPresentationName(e.getName());
        }
        if (e instanceof Activity) {
            Iterator iter = ((Activity)e).getBreakdownElements().iterator();
            while (iter.hasNext()) {
                Migrator.fixPresentationName((BreakdownElement)iter.next());
            }
        }
    }

    private static class AnyTypeFeatureValue {
        String ownerId;
        EObject owner;
        EStructuralFeature feature;
        String valueId;
        AnyType value;
        int index;

        AnyTypeFeatureValue() {
        }
    }

    class MigratorURIConverter
    extends MultiFileURIConverter {
        private ResourceManager oldResMgr;

        public MigratorURIConverter(MultiFileResourceSetImpl resourceSet) {
            super(resourceSet);
        }

        public URI normalize(URI uri) {
            String id;
            URI normalized = super.normalize(uri);
            if (normalized == null && "uma".equalsIgnoreCase(uri.scheme()) && this.oldResMgr != null && (normalized = this.getURIFromOldResourceManager(id = uri.authority())) != null) {
                normalized = uri.hasFragment() ? normalized.appendFragment(uri.fragment()) : normalized.appendFragment(id);
            }
            return normalized;
        }

        public URI getURIFromOldResourceManager(String id) {
            if (this.oldResMgr == null) {
                return null;
            }
            ResourceDescriptor desc = this.oldResMgr.getResourceDescriptor(id);
            if (desc != null) {
                URI normalized = desc.getResolvedURI();
                URI newURI = (URI)Migrator.this.oldPathToNewURIMap.get(normalized.toFileString());
                if (newURI != null) {
                    normalized = newURI;
                }
                return normalized;
            }
            return null;
        }

        public void dispose() {
            if (this.oldResMgr != null) {
                this.oldResMgr.dispose();
                this.oldResMgr = null;
            }
            super.dispose();
        }

        public void setOldResourceManager(ResourceManager resMgr) {
            this.oldResMgr = resMgr;
        }

        public ResourceManager getOldResourceManager() {
            return this.oldResMgr;
        }

        public void setURIMapping(EObject e, URI uri, Set modifiedResources) {
            ResourceDescriptor desc;
            MigratorURIConverter uriConverter;
            ResourceManager oldResMgr;
            if (e instanceof MethodElement && (oldResMgr = (uriConverter = (MigratorURIConverter)((MultiFileResourceSetImpl)e.eResource().getResourceSet()).getURIConverter()).getOldResourceManager()) != null && (desc = oldResMgr.getResourceDescriptor(((MethodElement)e).getGuid())) != null) {
                Migrator.this.oldPathToNewURIMap.put(desc.getResolvedURI().toFileString(), uri);
            }
            super.setURIMapping(e, uri, modifiedResources);
        }
    }

    class MigratorResourceSet
    extends MultiFileResourceSetImpl {
        MigratorResourceSet() {
        }

        public URIConverter getURIConverter() {
            if (this.uriConverter == null) {
                this.uriConverter = new MigratorURIConverter(this);
            }
            return this.uriConverter;
        }

        private void loadOldResourceManager(String libPath) throws IOException {
            String libDir = String.valueOf(new File(libPath).getParent()) + File.separator;
            File file = new File(libDir, "resmgr.xmi");
            ResourceManager resMgr = null;
            MultiFileURIConverter multiFileURIConverter = (MultiFileURIConverter)this.getURIConverter();
            if (file.exists()) {
                XMIResourceImpl resMgrRes = new XMIResourceImpl(URI.createFileURI((String)file.getAbsolutePath()));
                resMgrRes.load(null);
                if (!resMgrRes.getContents().isEmpty()) {
                    Object obj = resMgrRes.getContents().get(0);
                    if (obj instanceof ResourceManager) {
                        resMgr = (ResourceManager)obj;
                    } else {
                        System.err.println("Invalid ResourceManager file: " + file);
                    }
                }
            }
            ((MigratorURIConverter)multiFileURIConverter).setOldResourceManager(resMgr);
        }

        public MethodLibrary loadLibrary(String path) throws Exception {
            this.loadOldResourceManager(path);
            return this.loadLibraryWithoutReset(path);
        }

        protected EObject findEObjectInUnloadedResources(String id) {
            EObject object = null;
            if (this.getResourceManager() != null) {
                object = super.findEObjectInUnloadedResources(id);
            }
            if (object == null) {
                URI uri = ((MigratorURIConverter)this.getURIConverter()).getURIFromOldResourceManager(id);
                Resource resource = super.getResource(uri, true);
                return resource.getEObject(id);
            }
            return null;
        }

        public EObject getEObject(URI uri, boolean loadOnDemand) {
            EObject eObj = super.getEObject(uri, loadOnDemand);
            if (eObj == null && "uma".equalsIgnoreCase(uri.scheme()) && !uri.hasFragment()) {
                eObj = super.getEObject(uri.authority());
            }
            if (eObj == null || eObj.eIsProxy()) {
                throw new RuntimeException("Could not load object with URI '" + uri + "' (normalized URI: '" + this.getURIConverter().normalize(uri) + "').\nPlease see log file for more details.");
            }
            return eObj;
        }

        public EObject superGetEObject(URI uri, boolean loadOnDemand) {
            try {
                URI normalized = this.getURIConverter().normalize(uri);
                if (normalized == null) {
                    return null;
                }
                Resource resource = null;
                resource = this.getResource(normalized.trimFragment(), loadOnDemand);
                if (resource != null) {
                    String fragment = normalized.fragment();
                    if (fragment == null || fragment.length() == 0) {
                        return MultiFileSaveUtil.getMethodElement(resource);
                    }
                    return resource.getEObject(fragment);
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public Resource createResource(URI uri) {
            MultiFileXMIResourceImpl result = new MultiFileXMIResourceImpl(this, uri){
                final /* synthetic */ MigratorResourceSet this$1;
                {
                    this.this$1 = migratorResourceSet;
                    super($anonymous0);
                }

                protected XMLHelper createXMLHelper() {
                    return new MultiFileXMIHelperImpl(this, this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                            super($anonymous0);
                        }

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
                            boolean old = this.logError;
                            try {
                                try {
                                    this.logError = false;
                                    super.setValue(object, feature, value, position);
                                }
                                catch (RuntimeException e) {
                                    if (!(value instanceof AnyType)) throw e;
                                    if (!(object instanceof MethodElement)) throw e;
                                    AnyTypeFeatureValue fvalue = new AnyTypeFeatureValue();
                                    fvalue.ownerId = ((MethodElement)object).getGuid();
                                    fvalue.feature = feature;
                                    fvalue.valueId = (String)UMA2UMAResourceHandler.getSingleValue(((AnyType)value).getAnyAttribute(), "guid");
                                    fvalue.index = position;
                                    MigratorResourceSet.access$0((MigratorResourceSet)1.access$0(this.this$2)).anyTypeFeatureValues.add(fvalue);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_9 = null;
                                this.logError = old;
                                throw throwable;
                            }
                            {
                                Object var8_10 = null;
                                this.logError = old;
                                return;
                            }
                        }

                        public List setManyReference(XMLHelper.ManyReference reference, String location) {
                            List exceptions = super.setManyReference(reference, location);
                            if (exceptions == null) {
                                return null;
                            }
                            Iterator<E> iter = exceptions.iterator();
                            while (iter.hasNext()) {
                                IllegalValueException ive;
                                E ex = iter.next();
                                if (!(ex instanceof IllegalValueException) || !((ive = (IllegalValueException)ex).getValue() instanceof AnyType) || !(ive.getObject() instanceof MethodElement)) continue;
                                AnyTypeFeatureValue fvalue = new AnyTypeFeatureValue();
                                fvalue.ownerId = ((MethodElement)ive.getObject()).getGuid();
                                fvalue.feature = ive.getFeature();
                                fvalue.valueId = (String)UMA2UMAResourceHandler.getSingleValue(((AnyType)ive.getValue()).getAnyAttribute(), "guid");
                                fvalue.index = -1;
                                MigratorResourceSet.access$0((MigratorResourceSet)1.access$0(this.this$2)).anyTypeFeatureValues.add(fvalue);
                                iter.remove();
                            }
                            if (exceptions.isEmpty()) {
                                return null;
                            }
                            return exceptions;
                        }
                    };
                }

                static /* synthetic */ MigratorResourceSet access$0(1 var0) {
                    return var0.this$1;
                }
            };
            result.setTrackingModification(true);
            this.getResources().add((Object)result);
            return result;
        }

        static /* synthetic */ Migrator access$0(MigratorResourceSet migratorResourceSet) {
            return migratorResourceSet.Migrator.this;
        }
    }
}

