/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.util;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.uma.ecore.ResolveException;

public class UnresolvedProxyMarkerManager {
    private Map unresolvedResourceGUIDToMarkersMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markerExistsFor(URI proxyURI) {
        String resourceGUID = proxyURI.authority();
        Map map = this.unresolvedResourceGUIDToMarkersMap;
        synchronized (map) {
            Map guidToMarkerMap = (Map)this.unresolvedResourceGUIDToMarkersMap.get(resourceGUID);
            return guidToMarkerMap != null && guidToMarkerMap.containsKey(proxyURI.fragment());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMarker(ResolveException re) {
        URI containerURI;
        InternalEObject proxy = (InternalEObject)re.getProxy();
        if (this.markerExistsFor(proxy.eProxyURI())) {
            return;
        }
        URI uRI = containerURI = re.getResolver() != null ? re.getResolver().eResource().getURI() : null;
        if (containerURI != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(containerURI.toFileString());
            IFile file = workspace.getRoot().getFileForLocation((IPath)path);
            if (file != null) {
                String errMsg;
                String uri = proxy.eProxyURI().toString();
                String location = containerURI != null ? containerURI.toFileString() : "";
                String string = errMsg = re.getMessage() == null ? re.toString() : re.getMessage();
                if (location.length() != 0) {
                    location = MessageFormat.format(PersistenceResources.getString("Persistence.marker.location"), location);
                }
                String msg = MessageFormat.format(PersistenceResources.getString("Persistence.marker.err.cannotResolveProxy"), proxy.eClass().getName(), uri, errMsg);
                try {
                    file.refreshLocal(0, null);
                    IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("message", (Object)msg);
                    Map map = this.unresolvedResourceGUIDToMarkersMap;
                    synchronized (map) {
                        String resourceGUID = proxy.eProxyURI().authority();
                        HashMap<String, IMarker> markers = (HashMap<String, IMarker>)this.unresolvedResourceGUIDToMarkersMap.get(resourceGUID);
                        if (markers == null) {
                            markers = new HashMap<String, IMarker>();
                            this.unresolvedResourceGUIDToMarkersMap.put(resourceGUID, markers);
                        }
                        markers.put(proxy.eProxyURI().fragment(), marker);
                    }
                }
                catch (CoreException ex) {
                    CommonPlugin.INSTANCE.log((Object)ex);
                }
            }
        }
    }

    public void clearMarkers(String resourceGUID) {
        Map markers = (Map)this.unresolvedResourceGUIDToMarkersMap.remove(resourceGUID);
        if (markers != null && !markers.isEmpty()) {
            this.clearMarkers(markers.values());
        }
    }

    private void clearMarkers(Collection markers) {
        Iterator iter = markers.iterator();
        while (iter.hasNext()) {
            IMarker marker = (IMarker)iter.next();
            try {
                marker.delete();
            }
            catch (CoreException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Map map = this.unresolvedResourceGUIDToMarkersMap;
        synchronized (map) {
            Iterator iter = this.unresolvedResourceGUIDToMarkersMap.values().iterator();
            while (iter.hasNext()) {
                Map guidToMarkerMap = (Map)iter.next();
                this.clearMarkers(guidToMarkerMap.values());
            }
            this.unresolvedResourceGUIDToMarkersMap.clear();
        }
    }

    public boolean hasUnresolvedProxy() {
        return !this.unresolvedResourceGUIDToMarkersMap.isEmpty();
    }
}

